<?php $__env->startSection('title', 'Kategoriler'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="display-5 fw-bold text-primary mb-3">Çiçek Kategorileri</h1>
            <p class="lead text-muted">İhtiyacınıza uygun kategoriyi seçin</p>
        </div>
    </div>

    <!-- Categories Grid -->
    <div class="row g-4">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-3 col-md-6">
            <div class="card category-card h-100 border-0 shadow-sm">
                <div class="position-relative">
                    <?php if($category->image): ?>
                        <img src="<?php echo e(asset('storage/' . $category->image)); ?>"
                             alt="<?php echo e($category->name); ?>"
                             class="card-img-top"
                             style="height: 200px; object-fit: cover;">
                        <div class="position-absolute top-0 start-0 w-100 h-100"
                             style="background: linear-gradient(135deg, <?php echo e($category->color); ?>40, transparent);"></div>
                    <?php else: ?>
                        <div class="card-img-top d-flex align-items-center justify-content-center"
                             style="height: 200px; background: linear-gradient(135deg, <?php echo e($category->color); ?>20, #FFF);">
                            <i class="<?php echo e($category->icon); ?>" style="font-size: 4rem; color: <?php echo e($category->color); ?>;"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-body text-center p-4">
                    <h5 class="card-title fw-bold"><?php echo e($category->name); ?></h5>
                    <p class="card-text text-muted"><?php echo e($category->active_products_count); ?> ürün</p>
                    <a href="<?php echo e(route('categories.show', $category->slug)); ?>"
                       class="btn"
                       style="background-color: <?php echo e($category->color); ?>; color: white;">
                        İncele
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Popular Categories Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="fw-bold text-primary mb-4">Popüler Kategoriler</h3>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <i class="bi bi-flower1 fs-1 text-danger"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="fw-bold mb-1">Sevgililer Günü Özel</h6>
                            <p class="text-muted mb-2 small">Romantik buketler ve özel tasarımlar</p>
                            <a href="<?php echo e(route('categories.show', 'sevgililer-gunu')); ?>" class="btn btn-sm btn-outline-danger">
                                Keşfet <i class="bi bi-arrow-right ms-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <i class="bi bi-gift fs-1 text-warning"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="fw-bold mb-1">Özel Gün Buketleri</h6>
                            <p class="text-muted mb-2 small">Doğum günü, yıldönümü için</p>
                            <a href="<?php echo e(route('categories.show', 'buketler')); ?>" class="btn btn-sm btn-outline-warning">
                                Keşfet <i class="bi bi-arrow-right ms-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <i class="bi bi-flower3 fs-1 text-success"></i>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="fw-bold mb-1">Ev Dekorasyonu</h6>
                            <p class="text-muted mb-2 small">Saksı çiçekleri ve orkideler</p>
                            <a href="<?php echo e(route('categories.show', 'saksi-cicekleri')); ?>" class="btn btn-sm btn-outline-success">
                                Keşfet <i class="bi bi-arrow-right ms-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/chatappc/bilginyz.com.tr/cicekci/resources/views/categories/index.blade.php ENDPATH**/ ?>