<?php $__env->startSection('title', 'Ürünler'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="display-5 fw-bold text-primary mb-3">Tüm Ürünler</h1>
            <p class="lead text-muted">En taze çiçekler ve özel buketler</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Filtreler</h6>
                </div>
                <div class="card-body">
                    <form method="GET">
                        <!-- Category Filter -->
                        <div class="mb-3">
                            <label class="form-label">Kategori</label>
                            <select name="category" class="form-select">
                                <option value="">Tüm Kategoriler</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->slug); ?>" <?php echo e(request('category') == $category->slug ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Price Range -->
                        <div class="mb-3">
                            <label class="form-label">Fiyat Aralığı</label>
                            <div class="row">
                                <div class="col-6">
                                    <input type="number" name="min_price" class="form-control" placeholder="Min ₺" value="<?php echo e(request('min_price')); ?>">
                                </div>
                                <div class="col-6">
                                    <input type="number" name="max_price" class="form-control" placeholder="Max ₺" value="<?php echo e(request('max_price')); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Sort -->
                        <div class="mb-3">
                            <label class="form-label">Sıralama</label>
                            <select name="sort" class="form-select">
                                <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>>İsme Göre</option>
                                <option value="price_asc" <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>>Fiyat (Düşük-Yüksek)</option>
                                <option value="price_desc" <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>>Fiyat (Yüksek-Düşük)</option>
                                <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>En Yeni</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">Filtrele</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            <?php if($products->count() > 0): ?>
            <!-- Products Grid -->
            <div class="row g-4">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="position-relative">
                            <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="text-decoration-none">
                                <?php if($product->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $product->image)); ?>"
                                         alt="<?php echo e($product->name); ?>"
                                         class="card-img-top"
                                         style="height: 200px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, <?php echo e($product->category->color); ?>20, #E1F5FE); height: 200px;">
                                        <i class="<?php echo e($product->category->icon); ?> text-primary" style="font-size: 4rem; color: <?php echo e($product->category->color); ?>;"></i>
                                    </div>
                                <?php endif; ?>
                            </a>
                            <?php if($product->discount_price): ?>
                            <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                                -<?php echo e(number_format((($product->price - $product->discount_price) / $product->price) * 100, 0)); ?>%
                            </span>
                            <?php endif; ?>
                            <?php if($product->stock_quantity <= 5): ?>
                            <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son <?php echo e($product->stock_quantity); ?> adet!</span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="text-decoration-none">
                                <h6 class="card-title fw-bold text-dark"><?php echo e($product->name); ?></h6>
                            </a>
                            <p class="card-text text-muted small"><?php echo e($product->description ? Str::limit($product->description, 80) : $product->short_description); ?></p>
                            <div class="mb-2">
                                <small class="text-muted">
                                    <i class="bi bi-tag me-1"></i><?php echo e($product->category->name); ?>

                                </small>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <?php if($product->discount_price): ?>
                                    <span class="text-decoration-line-through text-muted small">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                    <span class="fw-bold text-primary ms-2">₺<?php echo e(number_format($product->discount_price, 2)); ?></span>
                                    <?php else: ?>
                                    <span class="fw-bold text-primary">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="btn btn-outline-primary btn-sm me-1">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <form action="<?php echo e(route('cart.add', $product->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="btn btn-primary btn-sm" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                                            <i class="bi bi-bag-plus"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($products->links()); ?>

            </div>
            <?php else: ?>
            <!-- No Products -->
            <div class="text-center py-5">
                <i class="bi bi-flower1 display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Ürün bulunamadı</h3>
                <p class="text-muted mb-4">Aradığınız kriterlere uygun ürün bulunmuyor. Filtrelerinizi değiştirmeyi deneyin.</p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary">
                    <i class="bi bi-arrow-left me-2"></i>Tüm Ürünleri Gör
                </a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/chatappc/bilginyz.com.tr/cicekci/resources/views/products/index.blade.php ENDPATH**/ ?>