<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="display-5 fw-bold text-primary mb-3">
                <i class="bi bi-speedometer2 me-2"></i>Admin Dashboard
            </h1>
            <p class="text-muted">Çiçek Bahçesi yönetim paneline hoş geldiniz</p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card border-0 shadow-sm bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Toplam Ürün</h6>
                            <h2 class="mb-0"><?php echo e($stats['products'] ?? 0); ?></h2>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-flower1 fs-1"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card border-0 shadow-sm bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Toplam Sipariş</h6>
                            <h2 class="mb-0"><?php echo e($stats['orders'] ?? 0); ?></h2>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-bag-check fs-1"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card border-0 shadow-sm bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Toplam Müşteri</h6>
                            <h2 class="mb-0"><?php echo e($stats['customers'] ?? 0); ?></h2>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-people fs-1"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card border-0 shadow-sm bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Aylık Ciro</h6>
                            <h2 class="mb-0">₺<?php echo e(number_format($stats['monthly_revenue'] ?? 0, 0)); ?></h2>
                        </div>
                        <div class="align-self-center">
                            <i class="bi bi-currency-exchange fs-1"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Orders -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-clock-history me-2"></i>Son Siparişler
                    </h5>
                </div>
                <div class="card-body">
                    <?php if(isset($recentOrders) && $recentOrders->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Sipariş No</th>
                                    <th>Müşteri</th>
                                    <th>Tutar</th>
                                    <th>Durum</th>
                                    <th>Tarih</th>
                                    <th>İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><strong>#<?php echo e($order->order_number); ?></strong></td>
                                    <td><?php echo e($order->user->name); ?></td>
                                    <td>₺<?php echo e(number_format($order->total_amount, 2)); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($order->status_badge); ?>">
                                            <?php echo e($order->status_text); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($order->created_at->format('d.m.Y')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>" class="btn btn-sm btn-outline-primary" title="Sipariş Detayı">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-4">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <p class="text-muted mt-2">Henüz sipariş bulunmuyor</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-lightning me-2"></i>Hızlı İşlemler
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-primary">
                            <i class="bi bi-flower1 me-2"></i>Ürün Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.categories.index')); ?>" class="btn btn-success">
                            <i class="bi bi-tags me-2"></i>Kategori Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-info">
                            <i class="bi bi-list-check me-2"></i>Sipariş Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-warning">
                            <i class="bi bi-graph-up me-2"></i>Raporlar
                        </a>
                        <a href="<?php echo e(route('admin.sliders.index')); ?>" class="btn btn-secondary">
                            <i class="bi bi-images me-2"></i>Slider Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.settings.index')); ?>" class="btn btn-info">
                            <i class="bi bi-gear me-2"></i>Site Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.stories.index')); ?>" class="btn btn-success">
                            <i class="bi bi-collection-play me-2"></i>Story Yönetimi
                        </a>
                        <a href="<?php echo e(route('admin.payment-settings')); ?>" class="btn btn-warning">
                            <i class="bi bi-credit-card-2-front me-2"></i>PayTR Ayarları
                        </a>
                    </div>
                </div>
            </div>

            <!-- System Info -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-info-circle me-2"></i>Sistem Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <strong>Laravel:</strong> <?php echo e(app()->version()); ?>

                        </li>
                        <li class="mb-2">
                            <strong>PHP:</strong> <?php echo e(PHP_VERSION); ?>

                        </li>
                        <li class="mb-2">
                            <strong>Veritabanı:</strong> MySQL
                        </li>
                        <li class="mb-0">
                            <strong>Son Güncelleme:</strong> <?php echo e(now()->format('d.m.Y H:i')); ?>

                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Low Stock Alert -->
    <?php if(isset($lowStockProducts) && $lowStockProducts->count() > 0): ?>
    <div class="row">
        <div class="col-12">
            <div class="alert alert-warning">
                <h6 class="alert-heading">
                    <i class="bi bi-exclamation-triangle me-2"></i>Düşük Stok Uyarısı
                </h6>
                <p class="mb-2">Aşağıdaki ürünlerin stokları azalmış:</p>
                <ul class="mb-0">
                    <?php $__currentLoopData = $lowStockProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($product->name); ?> - <strong><?php echo e($product->stock_quantity); ?> adet kaldı</strong></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/chatappc/bilginyz.com.tr/cicekci/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>