<?php $__env->startSection('title', 'Ürün Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-flower1 me-2"></i>Ürün Yönetimi
                    </h1>
                    <p class="text-muted mb-0">Ürünleri görüntüleyin, ekleyin ve düzenleyin</p>
                </div>
                <div>
                    <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary btn-lg">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Ürün Ekle
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('admin.products.index')); ?>">
                        <div class="row align-items-end">
                            <div class="col-md-3">
                                <label for="search" class="form-label">Ürün Ara</label>
                                <input type="text" class="form-control" id="search" name="search" 
                                       value="<?php echo e(request('search')); ?>" placeholder="Ürün adı veya kodu...">
                            </div>
                            <div class="col-md-3">
                                <label for="category" class="form-label">Kategori</label>
                                <select class="form-select" id="category" name="category">
                                    <option value="">Tüm Kategoriler</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e(request('category') == $category->id ? 'selected' : ''); ?>>
                                        <?php echo e($category->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="status" class="form-label">Durum</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="">Tümü</option>
                                    <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Aktif</option>
                                    <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Pasif</option>
                                    <option value="low_stock" <?php echo e(request('status') == 'low_stock' ? 'selected' : ''); ?>>Düşük Stok</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="sort" class="form-label">Sıralama</label>
                                <select class="form-select" id="sort" name="sort">
                                    <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>>İsim</option>
                                    <option value="price" <?php echo e(request('sort') == 'price' ? 'selected' : ''); ?>>Fiyat</option>
                                    <option value="stock" <?php echo e(request('sort') == 'stock' ? 'selected' : ''); ?>>Stok</option>
                                    <option value="created_at" <?php echo e(request('sort', 'created_at') == 'created_at' ? 'selected' : ''); ?>>Tarih</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="bi bi-search me-1"></i>Filtrele
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Products Table -->
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Ürünler (<?php echo e($products->total()); ?>)</h5>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-outline-secondary active">
                                <i class="bi bi-table"></i>
                            </button>
                            <button type="button" class="btn btn-outline-secondary">
                                <i class="bi bi-grid"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <?php if($products->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="60">
                                        <input type="checkbox" class="form-check-input" id="selectAll">
                                    </th>
                                    <th width="80">Resim</th>
                                    <th>Ürün Bilgileri</th>
                                    <th width="120">Kategori</th>
                                    <th width="100">Fiyat</th>
                                    <th width="80">Stok</th>
                                    <th width="100">Durum</th>
                                    <th width="150">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" class="form-check-input product-checkbox" 
                                               value="<?php echo e($product->id); ?>">
                                    </td>
                                    <td>
                                        <?php if($product->image): ?>
                                            <img src="<?php echo e(asset('storage/' . $product->image)); ?>"
                                                 alt="<?php echo e($product->name); ?>"
                                                 class="img-thumbnail"
                                                 style="width: 60px; height: 60px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-gradient p-2 text-center rounded"
                                                 style="background: linear-gradient(135deg, <?php echo e($product->category->color); ?>20, #E1F5FE); width: 60px; height: 60px; display: flex; align-items: center; justify-content: center;">
                                                <i class="<?php echo e($product->category->icon); ?>"
                                                   style="color: <?php echo e($product->category->color); ?>; font-size: 1.5rem;"></i>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div>
                                            <h6 class="mb-1 fw-bold"><?php echo e($product->name); ?></h6>
                                            <small class="text-muted">SKU: <?php echo e($product->sku); ?></small>
                                            <?php if($product->description): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e(Str::limit($product->description, 50)); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge" style="background-color: <?php echo e($product->category->color); ?>20; color: <?php echo e($product->category->color); ?>;">
                                            <?php echo e($product->category->name); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div>
                                            <?php if($product->discount_price): ?>
                                            <span class="fw-bold text-success">₺<?php echo e(number_format($product->discount_price, 2)); ?></span>
                                            <br>
                                            <small class="text-muted text-decoration-line-through">₺<?php echo e(number_format($product->price, 2)); ?></small>
                                            <?php else: ?>
                                            <span class="fw-bold">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($product->stock_quantity <= 5 ? 'danger' : ($product->stock_quantity <= 20 ? 'warning' : 'success')); ?>">
                                            <?php echo e($product->stock_quantity); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input status-toggle" type="checkbox" 
                                                   data-product-id="<?php echo e($product->id); ?>"
                                                   <?php echo e($product->is_active ? 'checked' : ''); ?>>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('products.show', $product->slug)); ?>" 
                                               class="btn btn-outline-info" target="_blank" title="Görüntüle">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" 
                                               class="btn btn-outline-primary" title="Düzenle">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button type="button" class="btn btn-outline-danger delete-product" 
                                                    data-product-id="<?php echo e($product->id); ?>" 
                                                    data-product-name="<?php echo e($product->name); ?>" title="Sil">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <h5 class="text-muted mt-3">Ürün Bulunamadı</h5>
                        <p class="text-muted">Arama kriterlerinize uygun ürün bulunamadı.</p>
                        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
                            <i class="bi bi-plus-circle me-2"></i>İlk Ürünü Ekle
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if($products->hasPages()): ?>
                <div class="card-footer bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-muted">
                            <?php echo e($products->firstItem()); ?>-<?php echo e($products->lastItem()); ?> / <?php echo e($products->total()); ?> ürün
                        </div>
                        <div>
                            <?php echo e($products->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Bulk Actions -->
    <div class="row mt-3">
        <div class="col-12">
            <div class="card border-0 shadow-sm" id="bulk-actions" style="display: none;">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <span class="me-3"><span id="selected-count">0</span> ürün seçildi</span>
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-success" id="bulk-activate">
                                <i class="bi bi-check-circle me-1"></i>Aktif Yap
                            </button>
                            <button type="button" class="btn btn-outline-warning" id="bulk-deactivate">
                                <i class="bi bi-x-circle me-1"></i>Pasif Yap
                            </button>
                            <button type="button" class="btn btn-outline-danger" id="bulk-delete">
                                <i class="bi bi-trash me-1"></i>Sil
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Select all checkbox
    const selectAllCheckbox = document.getElementById('selectAll');
    const productCheckboxes = document.querySelectorAll('.product-checkbox');
    const bulkActions = document.getElementById('bulk-actions');
    const selectedCount = document.getElementById('selected-count');

    selectAllCheckbox.addEventListener('change', function() {
        productCheckboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
        updateBulkActions();
    });

    productCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkActions);
    });

    function updateBulkActions() {
        const checkedBoxes = document.querySelectorAll('.product-checkbox:checked');
        const count = checkedBoxes.length;
        
        if (count > 0) {
            bulkActions.style.display = 'block';
            selectedCount.textContent = count;
        } else {
            bulkActions.style.display = 'none';
        }
        
        selectAllCheckbox.indeterminate = count > 0 && count < productCheckboxes.length;
        selectAllCheckbox.checked = count === productCheckboxes.length;
    }

    // Status toggle
    document.querySelectorAll('.status-toggle').forEach(toggle => {
        toggle.addEventListener('change', function() {
            const productId = this.dataset.productId;
            const isActive = this.checked;

            fetch(`/admin/products/${productId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !isActive; // Revert on error
                    alert('Durum güncellenirken hata oluştu!');
                }
            })
            .catch(error => {
                this.checked = !isActive; // Revert on error
                alert('Bir hata oluştu!');
            });
        });
    });

    // Delete product
    document.querySelectorAll('.delete-product').forEach(button => {
        button.addEventListener('click', function() {
            const productId = this.dataset.productId;
            const productName = this.dataset.productName;

            if (confirm(`"${productName}" ürününü silmek istediğinizden emin misiniz?\n\nBu işlem geri alınamaz!`)) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = `/admin/products/${productId}`;
                form.innerHTML = `
                    <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
                    <input type="hidden" name="_method" value="DELETE">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        });
    });

    // Bulk actions
    document.getElementById('bulk-activate')?.addEventListener('click', function() {
        const selectedIds = getSelectedProductIds();
        if (selectedIds.length === 0) {
            alert('Lütfen en az bir ürün seçin!');
            return;
        }

        if (confirm(`${selectedIds.length} ürünü aktif yapmak istediğinizden emin misiniz?`)) {
            bulkUpdateStatus(selectedIds, true);
        }
    });

    document.getElementById('bulk-deactivate')?.addEventListener('click', function() {
        const selectedIds = getSelectedProductIds();
        if (selectedIds.length === 0) {
            alert('Lütfen en az bir ürün seçin!');
            return;
        }

        if (confirm(`${selectedIds.length} ürünü pasif yapmak istediğinizden emin misiniz?`)) {
            bulkUpdateStatus(selectedIds, false);
        }
    });

    document.getElementById('bulk-delete')?.addEventListener('click', function() {
        const selectedIds = getSelectedProductIds();
        if (selectedIds.length === 0) {
            alert('Lütfen en az bir ürün seçin!');
            return;
        }

        if (confirm(`${selectedIds.length} ürünü silmek istediğinizden emin misiniz?\n\nBu işlem geri alınamaz!`)) {
            bulkDelete(selectedIds);
        }
    });

    function getSelectedProductIds() {
        return Array.from(document.querySelectorAll('.product-checkbox:checked')).map(cb => cb.value);
    }

    function bulkUpdateStatus(productIds, isActive) {
        fetch('/admin/products/bulk-update-status', {
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ product_ids: productIds, is_active: isActive })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('İşlem sırasında hata oluştu!');
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
        });
    }

    function bulkDelete(productIds) {
        fetch('/admin/products/bulk-delete', {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ product_ids: productIds })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'İşlem sırasında hata oluştu!');
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/chatappc/bilginyz.com.tr/cicekci/resources/views/admin/products/index.blade.php ENDPATH**/ ?>