<?php $__env->startSection('title', 'Sepetim'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Ana Sayfa</a></li>
                    <li class="breadcrumb-item active">Sepetim</li>
                </ol>
            </nav>
            <h1 class="display-5 fw-bold text-primary mb-3">Sepetim</h1>
        </div>
    </div>

    <?php if(empty($cart) || count($cart) == 0): ?>
    <!-- Empty Cart -->
    <div class="row">
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-bag-x display-1 text-muted mb-4"></i>
                <h3 class="text-muted mb-3">Sepetiniz Boş</h3>
                <p class="text-muted mb-4">Henüz sepetinize ürün eklemediniz. Hemen alışverişe başlayın!</p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary btn-lg">
                    <i class="bi bi-flower1 me-2"></i>Alışverişe Başla
                </a>
            </div>
        </div>
    </div>
    <?php else: ?>
    <!-- Cart Items -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Sepetinizdeki Ürünler</h5>
                </div>
                <div class="card-body p-0">
                    <!-- Table Header - Only visible on desktop -->
                    <div class="bg-light border-bottom p-3 d-none d-lg-block">
                        <div class="row align-items-center text-muted small fw-semibold">
                            <div class="col-lg-2">ÜRÜN</div>
                            <div class="col-lg-4">ÜRÜN ADI</div>
                            <div class="col-lg-2 text-center">FİYAT</div>
                            <div class="col-lg-2 text-center">MİKTAR</div>
                            <div class="col-lg-1 text-end">TOPLAM</div>
                            <div class="col-lg-1"></div>
                        </div>
                    </div>

                    <?php
                    $total = 0;
                    ?>

                    <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $itemTotal = $item['price'] * $item['quantity'];
                    $total += $itemTotal;
                    ?>
                    
                    <div class="border-bottom p-4">
                        <!-- Desktop Layout -->
                        <div class="row align-items-center g-3 d-none d-lg-flex">
                            <div class="col-lg-2">
                                <?php if(isset($item['image']) && $item['image'] && !empty(trim($item['image']))): ?>
                                    <img src="<?php echo e(asset('storage/' . $item['image'])); ?>"
                                         alt="<?php echo e($item['name']); ?>"
                                         class="img-fluid rounded"
                                         style="width: 80px; height: 80px; object-fit: cover;"
                                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                    <div class="bg-gradient p-3 text-center rounded" style="display: none; background: linear-gradient(135deg, <?php echo e($item['category_color'] ?? '#E91E63'); ?>20, #E1F5FE); width: 80px; height: 80px; align-items: center; justify-content: center;">
                                        <i class="<?php echo e($item['category_icon'] ?? 'bi bi-flower1'); ?> fs-3"
                                           style="color: <?php echo e($item['category_color'] ?? '#E91E63'); ?>;"></i>
                                    </div>
                                <?php else: ?>
                                    <div class="bg-gradient p-3 text-center rounded"
                                         style="background: linear-gradient(135deg, <?php echo e($item['category_color'] ?? '#E91E63'); ?>20, #E1F5FE); width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                                        <i class="<?php echo e($item['category_icon'] ?? 'bi bi-flower1'); ?> fs-3"
                                           style="color: <?php echo e($item['category_color'] ?? '#E91E63'); ?>;"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-3">
                                <h6 class="fw-bold mb-1"><?php echo e($item['name']); ?></h6>
                                <p class="text-muted small mb-0">Ürün Kodu: #<?php echo e($id); ?></p>
                            </div>
                            <div class="col-lg-2 text-center">
                                <span class="fw-bold text-primary">₺<?php echo e(number_format($item['price'], 2)); ?></span>
                            </div>
                            <div class="col-lg-2 d-flex justify-content-center">
                                <div class="input-group input-group-sm" style="max-width: 120px;">
                                    <form action="<?php echo e(route('cart.update', $id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="quantity" value="<?php echo e($item['quantity'] - 1); ?>">
                                        <button type="submit" class="btn btn-outline-secondary" <?php echo e($item['quantity'] <= 1 ? 'disabled' : ''); ?>>
                                            <i class="bi bi-dash"></i>
                                        </button>
                                    </form>
                                    <input type="text" class="form-control text-center fw-bold" value="<?php echo e($item['quantity']); ?>" readonly>
                                    <form action="<?php echo e(route('cart.update', $id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <input type="hidden" name="quantity" value="<?php echo e($item['quantity'] + 1); ?>">
                                        <button type="submit" class="btn btn-outline-secondary">
                                            <i class="bi bi-plus"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                            <div class="col-lg-2 text-end">
                                <div class="bg-light rounded px-2 py-1">
                                    <span class="fw-bold text-primary small text-nowrap">₺<?php echo e(number_format($itemTotal, 2)); ?></span>
                                </div>
                            </div>
                            <div class="col-lg-1 text-center">
                                <form action="<?php echo e(route('cart.remove', $id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('Bu ürünü sepetten çıkarmak istediğinizden emin misiniz?')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </div>

                        <!-- Mobile Layout -->
                        <div class="d-lg-none">
                            <div class="row g-3">
                                <div class="col-4">
                                    <?php if(isset($item['image']) && $item['image'] && !empty(trim($item['image']))): ?>
                                        <img src="<?php echo e(asset('storage/' . $item['image'])); ?>"
                                             alt="<?php echo e($item['name']); ?>"
                                             class="img-fluid rounded"
                                             style="width: 80px; height: 80px; object-fit: cover;"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <div class="bg-gradient p-3 text-center rounded" style="display: none; background: linear-gradient(135deg, <?php echo e($item['category_color'] ?? '#E91E63'); ?>20, #E1F5FE); width: 80px; height: 80px; align-items: center; justify-content: center;">
                                            <i class="<?php echo e($item['category_icon'] ?? 'bi bi-flower1'); ?> fs-3"
                                               style="color: <?php echo e($item['category_color'] ?? '#E91E63'); ?>;"></i>
                                        </div>
                                    <?php else: ?>
                                        <div class="bg-gradient p-3 text-center rounded"
                                             style="background: linear-gradient(135deg, <?php echo e($item['category_color'] ?? '#E91E63'); ?>20, #E1F5FE); width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <i class="<?php echo e($item['category_icon'] ?? 'bi bi-flower1'); ?> fs-3"
                                               style="color: <?php echo e($item['category_color'] ?? '#E91E63'); ?>;"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-8">
                                    <h6 class="fw-bold mb-1"><?php echo e($item['name']); ?></h6>
                                    <p class="text-muted small mb-2">Ürün Kodu: #<?php echo e($id); ?></p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold text-primary">₺<?php echo e(number_format($item['price'], 2)); ?></span>
                                        <form action="<?php echo e(route('cart.remove', $id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger btn-sm" onclick="return confirm('Bu ürünü sepetten çıkarmak istediğinizden emin misiniz?')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-6">
                                    <div class="text-center">
                                        <small class="text-muted d-block mb-1">Miktar</small>
                                        <div class="input-group input-group-sm">
                                            <form action="<?php echo e(route('cart.update', $id)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <input type="hidden" name="quantity" value="<?php echo e($item['quantity'] - 1); ?>">
                                                <button type="submit" class="btn btn-outline-secondary" <?php echo e($item['quantity'] <= 1 ? 'disabled' : ''); ?>>
                                                    <i class="bi bi-dash"></i>
                                                </button>
                                            </form>
                                            <input type="text" class="form-control text-center fw-bold" value="<?php echo e($item['quantity']); ?>" readonly>
                                            <form action="<?php echo e(route('cart.update', $id)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <input type="hidden" name="quantity" value="<?php echo e($item['quantity'] + 1); ?>">
                                                <button type="submit" class="btn btn-outline-secondary">
                                                    <i class="bi bi-plus"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center">
                                        <small class="text-muted d-block mb-1">Toplam</small>
                                        <div class="bg-light rounded px-3 py-2">
                                            <span class="fw-bold text-primary">₺<?php echo e(number_format($itemTotal, 2)); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Order Summary -->
            <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-header bg-gradient text-white" style="background: linear-gradient(135deg, #E91E63, #FF6B9D);">
                    <h5 class="mb-0 fw-bold">
                        <i class="bi bi-receipt me-2"></i>Sipariş Özeti
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- Sipariş Detayları -->
                    <div class="bg-light rounded-3 p-3 mb-3">
                        <!-- Ara Toplam -->
                        <div class="d-flex justify-content-between align-items-center py-2">
                            <span class="text-muted">Ara Toplam:</span>
                            <span class="fw-semibold fs-6">₺<?php echo e(number_format($total, 2)); ?></span>
                        </div>

                        <!-- Kargo -->
                        <div class="d-flex justify-content-between align-items-center py-2 border-top">
                            <span class="text-muted">Kargo:</span>
                            <span class="fw-semibold <?php echo e($total >= 200 ? 'text-success' : 'text-dark'); ?>">
                                <?php if($total >= 200): ?>
                                    <i class="bi bi-check-circle-fill me-1"></i>Ücretsiz
                                <?php else: ?>
                                    ₺15.00
                                <?php endif; ?>
                            </span>
                        </div>
                    </div>

                    <!-- Ücretsiz Kargo Uyarısı -->
                    <?php if($total < 200): ?>
                    <div class="alert alert-light border-primary mt-3 mb-3" style="background: linear-gradient(135deg, #E3F2FD, #F8F9FA);">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-truck text-primary me-2 fs-5"></i>
                            <div>
                                <small class="text-primary fw-semibold">
                                    ₺<?php echo e(number_format(200 - $total, 2)); ?> daha alışveriş yapın
                                </small>
                                <br>
                                <small class="text-muted">kargo ücretsiz olsun!</small>
                            </div>
                        </div>
                        <!-- Progress Bar -->
                        <div class="progress mt-2" style="height: 4px;">
                            <div class="progress-bar bg-primary" style="width: <?php echo e(($total / 200) * 100); ?>%"></div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-success mt-3 mb-3">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-check-circle-fill me-2"></i>
                            <small class="mb-0">Ücretsiz kargo kazandınız!</small>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Toplam -->
                    <div class="border-top pt-3 mt-3">
                        <div class="bg-primary text-white rounded-3 p-4 shadow-sm">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0 text-white-50">Toplam Tutar</h6>
                                    <small class="text-white-50">KDV Dahil</small>
                                </div>
                                <div class="text-end">
                                    <h3 class="mb-0 fw-bold text-white">₺<?php echo e(number_format($total >= 200 ? $total : $total + 15, 2)); ?></h3>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-grid gap-3 mt-4">
                        <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('checkout.index')); ?>" class="btn btn-primary btn-lg shadow-sm" style="background: linear-gradient(135deg, #E91E63, #FF6B9D); border: none;">
                            <i class="bi bi-credit-card me-2"></i>
                            <span class="fw-bold">Sipariş Ver</span>
                        </a>
                        <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="btn btn-primary btn-lg shadow-sm" style="background: linear-gradient(135deg, #E91E63, #FF6B9D); border: none;">
                            <i class="bi bi-person me-2"></i>
                            <span class="fw-bold">Giriş Yaparak Sipariş Ver</span>
                        </a>
                        <?php endif; ?>

                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-primary btn-lg">
                            <i class="bi bi-arrow-left me-2"></i>
                            <span>Alışverişe Devam Et</span>
                        </a>
                    </div>

                    <!-- Güvenlik Bilgisi -->
                    <div class="mt-4 text-center">
                        <div class="d-flex justify-content-center align-items-center text-muted small">
                            <i class="bi bi-shield-check me-2 text-success"></i>
                            <span>Güvenli ödeme</span>
                            <span class="mx-2">•</span>
                            <i class="bi bi-truck me-1 text-primary"></i>
                            <span>Hızlı teslimat</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delivery Info -->
            <div class="card border-0 shadow-sm mt-4" style="background: linear-gradient(135deg, #F8F9FA, #FFFFFF);">
                <div class="card-body p-4">
                    <h6 class="fw-bold mb-3 text-primary">
                        <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                    </h6>
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="d-flex align-items-start">
                                <div class="flex-shrink-0">
                                    <div class="bg-success rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                        <i class="bi bi-clock text-white small"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1 small fw-semibold">Aynı Gün Teslimat</h6>
                                    <p class="mb-0 text-muted small">Saat 14:00'a kadar olan siparişler</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex align-items-start">
                                <div class="flex-shrink-0">
                                    <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                        <i class="bi bi-truck text-white small"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1 small fw-semibold">Ücretsiz Kargo</h6>
                                    <p class="mb-0 text-muted small">₺200 ve üzeri siparişlerde</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex align-items-start">
                                <div class="flex-shrink-0">
                                    <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                                        <i class="bi bi-flower1 text-white small"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1 small fw-semibold">Taze Çiçek Garantisi</h6>
                                    <p class="mb-0 text-muted small">%100 taze ve kaliteli</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/chatappc/bilginyz.com.tr/cicekci/resources/views/cart/index.blade.php ENDPATH**/ ?>