@extends('layouts.app')

@section('title', $product->name)

@section('content')
<div class="container py-4">

    <!-- Product Details -->
    <div class="row mb-5">
        <div class="col-lg-6 mb-4">
            <!-- Product Image -->
            <div class="card border-0 shadow-sm">
                <div class="card-body p-0">
                    <div class="position-relative">
                        @if($product->image)
                            <img src="{{ asset('storage/' . $product->image) }}"
                                 alt="{{ $product->name }}"
                                 class="img-fluid w-100"
                                 style="height: 400px; object-fit: cover; border-radius: 0.375rem;">
                        @else
                            <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, {{ $product->category->color }}20, #E1F5FE); height: 400px; border-radius: 0.375rem;">
                                <i class="{{ $product->category->icon }}" style="font-size: 8rem; color: {{ $product->category->color }};"></i>
                            </div>
                        @endif
                        @if($product->discount_price)
                        <span class="position-absolute top-0 end-0 badge bg-danger m-3 fs-6">
                            -{{ number_format((($product->price - $product->discount_price) / $product->price) * 100, 0) }}%
                        </span>
                        @endif
                        @if($product->stock_quantity <= 5)
                        <span class="position-absolute top-0 start-0 badge bg-warning m-3">Son {{ $product->stock_quantity }} adet!</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <!-- Product Info -->
            <div class="mb-3">
                <span class="badge rounded-pill" style="background-color: {{ $product->category->color }}20; color: {{ $product->category->color }};">
                    <i class="{{ $product->category->icon }} me-1"></i>{{ $product->category->name }}
                </span>
            </div>

            <h1 class="display-6 fw-bold mb-3">{{ $product->name }}</h1>
            
            @if($product->short_description)
            <p class="lead text-muted mb-4">{{ $product->short_description }}</p>
            @endif

            <!-- Price -->
            <div class="mb-4">
                @if($product->sale_price)
                <div class="d-flex align-items-center mb-2">
                    <span class="text-decoration-line-through text-muted fs-5 me-3">₺{{ number_format($product->price, 2) }}</span>
                    <span class="display-6 fw-bold text-primary">₺{{ number_format($product->sale_price, 2) }}</span>
                </div>
                <div class="alert alert-success">
                    <i class="bi bi-tag-fill me-2"></i>
                    <strong>₺{{ number_format($product->price - $product->sale_price, 2) }} tasarruf!</strong>
                </div>
                @else
                <div class="display-6 fw-bold text-primary mb-3">₺{{ number_format($product->price, 2) }}</div>
                @endif
            </div>

            <!-- Stock Status -->
            <div class="mb-4">
                @if($product->in_stock)
                    @if($product->stock_quantity <= 5)
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        <strong>Dikkat!</strong> Sadece {{ $product->stock_quantity }} adet kaldı!
                    </div>
                    @else
                    <div class="alert alert-success">
                        <i class="bi bi-check-circle me-2"></i>
                        <strong>Stokta var</strong> - Hemen sipariş verebilirsiniz
                    </div>
                    @endif
                @else
                <div class="alert alert-danger">
                    <i class="bi bi-x-circle me-2"></i>
                    <strong>Stokta yok</strong> - Şu anda temin edilemiyor
                </div>
                @endif
            </div>

            <!-- Add to Cart -->
            @if($product->in_stock)
            <form action="{{ route('cart.add', $product->id) }}" method="POST" class="mb-4">
                @csrf
                <div class="row align-items-end">
                    <div class="col-md-4 mb-3">
                        <label for="quantity" class="form-label">Adet</label>
                        <select name="quantity" id="quantity" class="form-select">
                            @for($i = 1; $i <= min(10, $product->stock_quantity); $i++)
                            <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-8 mb-3">
                        <button type="submit" class="btn btn-primary btn-lg w-100">
                            <i class="bi bi-bag-plus me-2"></i>Sepete Ekle
                        </button>
                    </div>
                </div>
            </form>
            @endif

            <!-- Product Features -->
            <div class="row g-3 mb-4">
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-truck text-success me-2 fs-5"></i>
                        <div>
                            <small class="fw-bold">Hızlı Teslimat</small><br>
                            <small class="text-muted">{{ $product->delivery_days }} gün içinde</small>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-shield-check text-success me-2 fs-5"></i>
                        <div>
                            <small class="fw-bold">Taze Garanti</small><br>
                            <small class="text-muted">%100 taze çiçek</small>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-gift text-success me-2 fs-5"></i>
                        <div>
                            <small class="fw-bold">Özel Ambalaj</small><br>
                            <small class="text-muted">Ücretsiz hediye paketi</small>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-headset text-success me-2 fs-5"></i>
                        <div>
                            <small class="fw-bold">7/24 Destek</small><br>
                            <small class="text-muted">Müşteri hizmetleri</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Code -->
            <div class="text-muted small">
                <strong>Ürün Kodu:</strong> {{ $product->sku }}
            </div>
        </div>
    </div>

    <!-- Product Description -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="bi bi-info-circle me-2"></i>Ürün Açıklaması
                    </h5>
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $product->description }}</p>
                    
                    @if($product->care_instructions)
                    <hr>
                    <h6 class="fw-bold">
                        <i class="bi bi-heart me-2"></i>Bakım Talimatları
                    </h6>
                    <p class="mb-0 text-muted">{{ $product->care_instructions }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Related Products -->
    @if($relatedProducts->count() > 0)
    <div class="row">
        <div class="col-12">
            <h4 class="fw-bold mb-4">
                <i class="bi bi-flower1 me-2"></i>Benzer Ürünler
            </h4>
            <div class="row g-4">
                @foreach($relatedProducts as $relatedProduct)
                <div class="col-lg-3 col-md-6">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="position-relative">
                            <a href="{{ route('products.show', $relatedProduct->slug) }}" class="text-decoration-none">
                                @if($relatedProduct->image)
                                    <img src="{{ asset('storage/' . $relatedProduct->image) }}"
                                         alt="{{ $relatedProduct->name }}"
                                         class="card-img-top"
                                         style="height: 180px; object-fit: cover;">
                                @else
                                    <div class="bg-gradient p-4 text-center" style="background: linear-gradient(135deg, {{ $relatedProduct->category->color }}20, #E1F5FE); height: 180px;">
                                        <i class="{{ $relatedProduct->category->icon }}" style="font-size: 3rem; color: {{ $relatedProduct->category->color }};"></i>
                                    </div>
                                @endif
                            </a>
                            @if($relatedProduct->discount_price)
                            <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                                -{{ number_format((($relatedProduct->price - $relatedProduct->discount_price) / $relatedProduct->price) * 100, 0) }}%
                            </span>
                            @endif
                        </div>
                        <div class="card-body">
                            <a href="{{ route('products.show', $relatedProduct->slug) }}" class="text-decoration-none">
                                <h6 class="card-title fw-bold text-dark">{{ $relatedProduct->name }}</h6>
                            </a>
                            <p class="card-text text-muted small">{{ $relatedProduct->description ? Str::limit($relatedProduct->description, 60) : $relatedProduct->short_description }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    @if($relatedProduct->discount_price)
                                    <span class="text-decoration-line-through text-muted small">₺{{ number_format($relatedProduct->price, 2) }}</span>
                                    <span class="fw-bold text-primary ms-2">₺{{ number_format($relatedProduct->discount_price, 2) }}</span>
                                    @else
                                    <span class="fw-bold text-primary">₺{{ number_format($relatedProduct->price, 2) }}</span>
                                    @endif
                                </div>
                                <a href="{{ route('products.show', $relatedProduct->slug) }}" class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
