@extends('layouts.app')

@section('title', 'Arama Sonuçları')

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            @if($query)
            <h1 class="display-5 fw-bold text-primary mb-3">
                "{{ $query }}" için arama sonuçları
            </h1>
            @if($products->count() > 0)
            <p class="text-muted">{{ $products->total() }} ürün bulundu</p>
            @endif
            @else
            <h1 class="display-5 fw-bold text-primary mb-3">Arama</h1>
            <p class="text-muted">Aradığınız ürünü yazın</p>
            @endif
        </div>
    </div>

    <!-- Search Form -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <form action="{{ route('products.search') }}" method="GET">
                        <div class="input-group input-group-lg">
                            <input type="text" name="q" class="form-control" 
                                   placeholder="Çiçek, buket, orkide..." 
                                   value="{{ $query }}" autofocus>
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search me-2"></i>Ara
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @if($query)
        @if($products->count() > 0)
        <!-- Search Results -->
        <div class="row g-4">
            @foreach($products as $product)
            <div class="col-lg-3 col-md-6">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="position-relative">
                        <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, {{ $product->category->color }}20, #E1F5FE); height: 200px;">
                            <i class="{{ $product->category->icon }}" style="font-size: 4rem; color: {{ $product->category->color }};"></i>
                        </div>
                        @if($product->sale_price)
                        <span class="position-absolute top-0 end-0 badge bg-danger m-2">-{{ $product->discount_percentage }}%</span>
                        @endif
                        @if($product->stock_quantity <= 5)
                        <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son {{ $product->stock_quantity }} adet!</span>
                        @endif
                    </div>
                    <div class="card-body">
                        <h6 class="card-title fw-bold">{{ $product->name }}</h6>
                        <p class="card-text text-muted small">{{ $product->short_description }}</p>
                        <div class="mb-2">
                            <small class="text-muted">
                                <i class="bi bi-tag me-1"></i>{{ $product->category->name }}
                            </small>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                @if($product->sale_price)
                                <span class="text-decoration-line-through text-muted small">₺{{ number_format($product->price, 2) }}</span>
                                <span class="fw-bold text-primary ms-2">₺{{ number_format($product->sale_price, 2) }}</span>
                                @else
                                <span class="fw-bold text-primary">₺{{ number_format($product->price, 2) }}</span>
                                @endif
                            </div>
                            <div>
                                <a href="{{ route('products.show', $product->slug) }}" class="btn btn-outline-primary btn-sm me-1">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <form action="{{ route('cart.add', $product->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    <input type="hidden" name="quantity" value="1">
                                    <button type="submit" class="btn btn-primary btn-sm" {{ !$product->in_stock ? 'disabled' : '' }}>
                                        <i class="bi bi-bag-plus"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-center mt-4">
            {{ $products->links() }}
        </div>
        @else
        <!-- No Results -->
        <div class="text-center py-5">
            <i class="bi bi-search display-1 text-muted mb-4" style="opacity: 0.3;"></i>
            <h3 class="text-muted mb-3">Arama sonucu bulunamadı</h3>
            <p class="text-muted mb-4">"{{ $query }}" için herhangi bir ürün bulunamadı. Farklı anahtar kelimeler deneyin.</p>
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card border-0 bg-light">
                        <div class="card-body">
                            <h6 class="fw-bold mb-3">Arama önerileri:</h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">• Daha genel terimler kullanın (örn: "gül" yerine "çiçek")</li>
                                <li class="mb-2">• Yazım hatalarını kontrol edin</li>
                                <li class="mb-2">• Farklı kelimeler deneyin</li>
                                <li class="mb-2">• Kategorilere göz atın</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
    @else
    <!-- Popular Searches -->
    <div class="row">
        <div class="col-12">
            <h4 class="fw-bold mb-4">Popüler Aramalar</h4>
            <div class="d-flex flex-wrap gap-2 mb-4">
                <a href="{{ route('products.search', ['q' => 'gül']) }}" class="btn btn-outline-primary">Gül</a>
                <a href="{{ route('products.search', ['q' => 'buket']) }}" class="btn btn-outline-primary">Buket</a>
                <a href="{{ route('products.search', ['q' => 'orkide']) }}" class="btn btn-outline-primary">Orkide</a>
                <a href="{{ route('products.search', ['q' => 'sevgililer günü']) }}" class="btn btn-outline-primary">Sevgililer Günü</a>
                <a href="{{ route('products.search', ['q' => 'doğum günü']) }}" class="btn btn-outline-primary">Doğum Günü</a>
                <a href="{{ route('products.search', ['q' => 'saksı']) }}" class="btn btn-outline-primary">Saksı Çiçekleri</a>
            </div>
        </div>
    </div>

    <!-- Categories -->
    <div class="row">
        <div class="col-12">
            <h4 class="fw-bold mb-4">Kategorilere Göz Atın</h4>
            <div class="row g-3">
                <div class="col-md-3">
                    <a href="{{ route('categories.show', 'guller') }}" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower1 text-danger mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Güller</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('categories.show', 'orkideler') }}" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower2 text-purple mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Orkideler</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('categories.show', 'buketler') }}" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-gift text-warning mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Buketler</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="{{ route('categories.show', 'saksi-cicekleri') }}" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower3 text-success mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Saksı Çiçekleri</h6>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
