@extends('layouts.app')

@section('title', 'Sipariş Detayı')

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Ana Sayfa</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('orders.index') }}">Siparişlerim</a></li>
                    <li class="breadcrumb-item active">Sipariş #{{ $order->order_number }}</li>
                </ol>
            </nav>
            
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">Sipariş #{{ $order->order_number }}</h1>
                    <p class="text-muted mb-0">{{ $order->created_at->format('d.m.Y H:i') }} tarihinde verildi</p>
                </div>
                <div>
                    <span class="badge bg-{{ $order->status_badge }} fs-5">{{ $order->status_text }}</span>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Order Items -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-bag-check me-2"></i>Sipariş Detayları
                    </h5>
                </div>
                <div class="card-body">
                    @foreach($order->items as $item)
                    <div class="row align-items-center py-3 {{ !$loop->last ? 'border-bottom' : '' }}">
                        <div class="col-md-2">
                            <div class="bg-gradient p-3 text-center rounded" 
                                 style="background: linear-gradient(135deg, {{ $item->product->category->color }}20, #E1F5FE);">
                                <i class="{{ $item->product->category->icon }} fs-3" 
                                   style="color: {{ $item->product->category->color }};"></i>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <h6 class="fw-bold mb-1">{{ $item->product_name }}</h6>
                            <p class="text-muted small mb-1">Ürün Kodu: {{ $item->product_sku }}</p>
                            <small class="text-muted">{{ $item->product->category->name }}</small>
                        </div>
                        <div class="col-md-2 text-center">
                            <span class="fw-bold">{{ $item->quantity }} adet</span>
                            <br>
                            <small class="text-muted">₺{{ number_format($item->unit_price, 2) }} / adet</small>
                        </div>
                        <div class="col-md-2 text-end">
                            <span class="fw-bold text-primary fs-5">₺{{ number_format($item->total_price, 2) }}</span>
                        </div>
                        <div class="col-md-1 text-end">
                            <a href="{{ route('products.show', $item->product->slug) }}" 
                               class="btn btn-outline-primary btn-sm">
                                <i class="bi bi-eye"></i>
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Delivery Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslim Alacak Kişi:</h6>
                            <p class="mb-3">{{ $order->delivery_name }}</p>
                            
                            <h6 class="fw-bold">Telefon:</h6>
                            <p class="mb-3">{{ $order->delivery_phone }}</p>
                            
                            <h6 class="fw-bold">Teslimat Adresi:</h6>
                            <p class="mb-3">
                                {{ $order->delivery_address }}<br>
                                {{ $order->delivery_district }}, {{ $order->delivery_city }}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslimat Tarihi:</h6>
                            <p class="mb-3">
                                <i class="bi bi-calendar me-1"></i>
                                {{ $order->delivery_date->format('d.m.Y') }}
                                @if($order->delivery_time)
                                    <span class="text-muted">({{ $order->delivery_time }})</span>
                                @endif
                            </p>
                            
                            <h6 class="fw-bold">Ödeme Yöntemi:</h6>
                            <p class="mb-3">
                                @switch($order->payment_method)
                                    @case('cash')
                                        <i class="bi bi-cash me-1"></i>Kapıda Ödeme
                                        @break
                                    @case('card')
                                        <i class="bi bi-credit-card me-1"></i>Kredi Kartı
                                        @break
                                    @case('transfer')
                                        <i class="bi bi-bank me-1"></i>Havale/EFT
                                        @break
                                @endswitch
                            </p>
                            
                            @if($order->delivery_notes)
                            <h6 class="fw-bold">Teslimat Notları:</h6>
                            <p class="mb-0">{{ $order->delivery_notes }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @if($order->notes)
            <!-- Order Notes -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-chat-text me-2"></i>Sipariş Notları
                    </h5>
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $order->notes }}</p>
                </div>
            </div>
            @endif
        </div>

        <!-- Order Summary & Actions -->
        <div class="col-lg-4">
            <!-- Order Summary -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Sipariş Özeti</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span>₺{{ number_format($order->subtotal, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span class="{{ $order->shipping_cost == 0 ? 'text-success' : '' }}">
                            @if($order->shipping_cost == 0)
                                Ücretsiz
                            @else
                                ₺{{ number_format($order->shipping_cost, 2) }}
                            @endif
                        </span>
                    </div>
                    @if($order->discount_amount > 0)
                    <div class="d-flex justify-content-between mb-2">
                        <span>İndirim:</span>
                        <span class="text-success">-₺{{ number_format($order->discount_amount, 2) }}</span>
                    </div>
                    @endif
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary fs-4">₺{{ number_format($order->total_amount, 2) }}</strong>
                    </div>
                </div>
            </div>

            <!-- Order Status Timeline -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-clock-history me-2"></i>Sipariş Durumu
                    </h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item {{ in_array($order->status, ['pending', 'confirmed', 'shipped', 'delivered']) ? 'completed' : '' }}">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Sipariş Alındı</h6>
                                <small class="text-muted">{{ $order->created_at->format('d.m.Y H:i') }}</small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ in_array($order->status, ['confirmed', 'shipped', 'delivered']) ? 'completed' : '' }}">
                            <div class="timeline-marker {{ in_array($order->status, ['confirmed', 'shipped', 'delivered']) ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Sipariş Onaylandı</h6>
                                <small class="text-muted">Çiçekleriniz hazırlanıyor</small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ in_array($order->status, ['shipped', 'delivered']) ? 'completed' : '' }}">
                            <div class="timeline-marker {{ in_array($order->status, ['shipped', 'delivered']) ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Kargoya Verildi</h6>
                                <small class="text-muted">Teslimat için yola çıktı</small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker {{ $order->status === 'delivered' ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Teslim Edildi</h6>
                                <small class="text-muted">{{ $order->delivery_date->format('d.m.Y') }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($order->status === 'pending')
                        <form action="{{ route('orders.cancel', $order->id) }}" method="POST">
                            @csrf
                            @method('PATCH')
                            <button type="submit" class="btn btn-outline-danger w-100" 
                                    onclick="return confirm('Bu siparişi iptal etmek istediğinizden emin misiniz?')">
                                <i class="bi bi-x-circle me-2"></i>Siparişi İptal Et
                            </button>
                        </form>
                        @endif
                        
                        <a href="{{ route('orders.index') }}" class="btn btn-outline-primary">
                            <i class="bi bi-arrow-left me-2"></i>Siparişlerime Dön
                        </a>
                        
                        <a href="{{ route('products.index') }}" class="btn btn-primary">
                            <i class="bi bi-flower1 me-2"></i>Yeni Sipariş Ver
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 15px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -23px;
    top: 5px;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 0 0 2px #dee2e6;
}

.timeline-item.completed .timeline-marker {
    box-shadow: 0 0 0 2px #28a745;
}

.timeline-content h6 {
    margin-bottom: 5px;
}
</style>
@endsection
