<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Çiçek Bahçesi') }} - @yield('title', 'Ana Sayfa')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #E91E63;
            --secondary-color: #4CAF50;
            --accent-color: #FF9800;
            --light-bg: #F8F9FA;
            --dark-text: #333333;
        }

        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
        }

        .navbar-brand {
            font-weight: 700;
            color: var(--primary-color) !important;
            font-size: 1.5rem;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .btn-primary:hover {
            background-color: #C2185B;
            border-color: #C2185B;
        }

        .btn-success {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
        }

        .text-primary {
            color: var(--primary-color) !important;
        }

        .bg-primary {
            background-color: var(--primary-color) !important;
        }

        .navbar {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .footer {
            background-color: var(--dark-text);
            color: white;
            margin-top: auto;
        }

        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .search-box {
            border-radius: 25px;
        }

        .category-card {
            border-radius: 15px;
            overflow: hidden;
            position: relative;
        }

        .category-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(233, 30, 99, 0.8), rgba(76, 175, 80, 0.8));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .category-card:hover::before {
            opacity: 1;
        }

        .category-card .card-body {
            position: relative;
            z-index: 2;
        }

        /* Mobile Optimizations */
        @media (max-width: 768px) {
            .display-4 {
                font-size: 2rem !important;
            }

            .display-5 {
                font-size: 1.75rem !important;
            }

            .display-6 {
                font-size: 1.5rem !important;
            }

            .navbar-brand {
                font-size: 1.25rem !important;
            }

            .card {
                margin-bottom: 1rem;
            }

            .btn-lg {
                padding: 0.75rem 1.5rem;
                font-size: 1rem;
            }

            .carousel-item {
                height: 300px !important;
            }

            .carousel-item .display-4 {
                font-size: 1.5rem !important;
            }

            .carousel-item .lead {
                font-size: 1rem !important;
            }

            .search-box {
                border-radius: 20px;
            }

            .sticky-top {
                position: relative !important;
                top: auto !important;
            }
        }

        @media (max-width: 576px) {
            .container {
                padding-left: 15px;
                padding-right: 15px;
            }

            .card-body {
                padding: 1rem;
            }

            .btn {
                font-size: 0.875rem;
            }

            .carousel-item {
                height: 250px !important;
            }

            .carousel-item .container {
                padding-left: 1rem;
                padding-right: 1rem;
            }
        }
    </style>

    @stack('styles')
</head>
<body class="d-flex flex-column min-vh-100">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="{{ route('home') }}">
                <i class="bi bi-flower1 me-2 fs-3"></i>
                {{ config('app.name', 'Çiçek Bahçesi') }}
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
                <!-- Search Bar -->
                <div class="mx-auto d-none d-lg-block" style="width: 400px;">
                    <form class="d-flex" action="{{ route('products.search') }}" method="GET">
                        <div class="input-group">
                            <input class="form-control search-box" type="search" name="q" placeholder="Çiçek ara..." value="{{ request('q') }}">
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Right Side Navigation -->
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('products.index') }}">Ürünler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('categories.index') }}">Kategoriler</a>
                    </li>

                    <!-- Cart -->
                    <li class="nav-item">
                        <a class="nav-link position-relative" href="{{ route('cart.index') }}">
                            <i class="bi bi-bag fs-5"></i>
                            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" id="cart-count">
                                {{ session('cart') ? count(session('cart')) : 0 }}
                            </span>
                        </a>
                    </li>

                    @guest
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">Giriş</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">Kayıt</a>
                        </li>
                    @else
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="bi bi-person-circle me-1"></i>
                                {{ Auth::user()->name }}
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('profile.edit') }}">Profilim</a></li>
                                <li><a class="dropdown-item" href="{{ route('orders.index') }}">Siparişlerim</a></li>
                                @if(Auth::user()->isAdmin())
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="{{ route('dashboard') }}">Admin Panel</a></li>
                                @endif
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item">Çıkış</button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @endguest
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-grow-1">
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="footer py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="text-white mb-3">
                        <i class="bi bi-flower1 me-2"></i>
                        {{ \App\Models\Setting::get('site_name', config('app.name', 'Çiçek Bahçesi')) }}
                    </h5>
                    <p class="text-light">{{ \App\Models\Setting::get('footer_about_text', 'Türkiye\'nin en güvenilir çiçek satış platformu. Taze çiçekler, hızlı teslimat.') }}</p>
                    <div class="d-flex gap-3">
                        @if(\App\Models\Setting::get('social_facebook'))
                        <a href="{{ \App\Models\Setting::get('social_facebook') }}" class="text-light fs-4" target="_blank"><i class="bi bi-facebook"></i></a>
                        @endif
                        @if(\App\Models\Setting::get('social_instagram'))
                        <a href="{{ \App\Models\Setting::get('social_instagram') }}" class="text-light fs-4" target="_blank"><i class="bi bi-instagram"></i></a>
                        @endif
                        @if(\App\Models\Setting::get('social_twitter'))
                        <a href="{{ \App\Models\Setting::get('social_twitter') }}" class="text-light fs-4" target="_blank"><i class="bi bi-twitter"></i></a>
                        @endif
                        @if(\App\Models\Setting::get('social_youtube'))
                        <a href="{{ \App\Models\Setting::get('social_youtube') }}" class="text-light fs-4" target="_blank"><i class="bi bi-youtube"></i></a>
                        @endif
                    </div>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h6 class="text-white mb-3">Kategoriler</h6>
                    <ul class="list-unstyled">
                        <li><a href="#" class="text-light text-decoration-none">Güller</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Orkideler</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Buketler</a></li>
                        <li><a href="#" class="text-light text-decoration-none">Saksı Çiçekleri</a></li>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-6 mb-4">
                    <h6 class="text-white mb-3">{{ \App\Models\Setting::get('footer_links_title', 'Hızlı Linkler') }}</h6>
                    <ul class="list-unstyled">
                        @if(\App\Models\Setting::get('about_page_enabled', true))
                        <li><a href="{{ route('about') }}" class="text-light text-decoration-none">{{ \App\Models\Setting::get('footer_link_about', 'Hakkımızda') }}</a></li>
                        @endif
                        <li><a href="#" class="text-light text-decoration-none">{{ \App\Models\Setting::get('footer_link_contact', 'İletişim') }}</a></li>
                        <li><a href="#" class="text-light text-decoration-none">{{ \App\Models\Setting::get('footer_link_delivery', 'Teslimat') }}</a></li>
                        <li><a href="#" class="text-light text-decoration-none">{{ \App\Models\Setting::get('footer_link_return', 'İade') }}</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 mb-4">
                    <h6 class="text-white mb-3">{{ \App\Models\Setting::get('footer_contact_title', 'İletişim') }}</h6>
                    <p class="text-light mb-2">
                        <i class="bi bi-geo-alt me-2"></i>
                        {{ \App\Models\Setting::get('footer_contact_address', 'İstanbul, Türkiye') }}
                    </p>
                    <p class="text-light mb-2">
                        <i class="bi bi-telephone me-2"></i>
                        {{ \App\Models\Setting::get('footer_contact_phone', '+90 (212) 123 45 67') }}
                    </p>
                    <p class="text-light mb-2">
                        <i class="bi bi-envelope me-2"></i>
                        {{ \App\Models\Setting::get('footer_contact_email', 'info@cicekbahcesi.com') }}
                    </p>
                </div>
            </div>
            <hr class="my-4 text-light">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="text-light mb-0">{!! \App\Models\Setting::get('footer_copyright', '&copy; 2024 Çiçek Bahçesi. Tüm hakları saklıdır.') !!}</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="text-light mb-0">{{ \App\Models\Setting::get('footer_powered_by', 'Bilgin Yazılım') }}</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script>
        // Arama autocomplete
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.querySelector('input[name="q"]');
            if (searchInput) {
                // Popüler arama terimleri
                const popularSearches = [
                    'Kırmızı Gül', 'Beyaz Gül', 'Pembe Gül', 'Sarı Gül',
                    'Orkide', 'Beyaz Orkide', 'Mor Orkide',
                    'Buket', 'Gül Buketi', 'Karışık Buket', 'Doğum Günü Buketi',
                    'Saksı Çiçekleri', 'Karanfil', 'Lale',
                    'Sevgililer Günü', 'Doğum Günü', 'Yıldönümü'
                ];

                // Arama önerileri için datalist oluştur
                const datalist = document.createElement('datalist');
                datalist.id = 'search-suggestions';

                popularSearches.forEach(term => {
                    const option = document.createElement('option');
                    option.value = term;
                    datalist.appendChild(option);
                });

                searchInput.setAttribute('list', 'search-suggestions');
                searchInput.parentNode.appendChild(datalist);

                // Enter tuşu ile arama
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        this.closest('form').submit();
                    }
                });
            }

            // Sepet sayısını güncelle
            function updateCartCount() {
                fetch('/cart/count')
                    .then(response => response.json())
                    .then(data => {
                        const cartCount = document.getElementById('cart-count');
                        if (cartCount) {
                            cartCount.textContent = data.count;
                        }
                    })
                    .catch(error => console.log('Cart count update failed:', error));
            }

            // Sepete ekleme formları için AJAX
            document.querySelectorAll('form[action*="/cart/add/"]').forEach(form => {
                form.addEventListener('submit', function(e) {
                    e.preventDefault();

                    const formData = new FormData(this);
                    const button = this.querySelector('button[type="submit"]');
                    const originalText = button.innerHTML;

                    // Loading state
                    button.disabled = true;
                    button.innerHTML = '<i class="bi bi-hourglass-split"></i>';

                    fetch(this.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Success feedback
                            button.innerHTML = '<i class="bi bi-check"></i>';
                            button.classList.remove('btn-primary');
                            button.classList.add('btn-success');

                            // Show success message
                            showToast('Ürün sepete eklendi!', 'success');

                            // Update cart count
                            updateCartCount();

                            // Reset button after 2 seconds
                            setTimeout(() => {
                                button.innerHTML = originalText;
                                button.classList.remove('btn-success');
                                button.classList.add('btn-primary');
                                button.disabled = false;
                            }, 2000);
                        } else {
                            throw new Error(data.message || 'Bir hata oluştu');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showToast('Sepete eklenirken bir hata oluştu!', 'error');

                        // Reset button
                        button.innerHTML = originalText;
                        button.disabled = false;
                    });
                });
            });

            // Toast notification function
            function showToast(message, type = 'info') {
                const toastContainer = document.getElementById('toast-container') || createToastContainer();

                const toast = document.createElement('div');
                toast.className = `toast align-items-center text-white bg-${type === 'success' ? 'success' : 'danger'} border-0`;
                toast.setAttribute('role', 'alert');
                toast.innerHTML = `
                    <div class="d-flex">
                        <div class="toast-body">
                            <i class="bi bi-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
                            ${message}
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                    </div>
                `;

                toastContainer.appendChild(toast);

                const bsToast = new bootstrap.Toast(toast);
                bsToast.show();

                // Remove toast after it's hidden
                toast.addEventListener('hidden.bs.toast', () => {
                    toast.remove();
                });
            }

            function createToastContainer() {
                const container = document.createElement('div');
                container.id = 'toast-container';
                container.className = 'toast-container position-fixed top-0 end-0 p-3';
                container.style.zIndex = '1055';
                document.body.appendChild(container);
                return container;
            }
        });
    </script>

    @stack('scripts')
</body>
</html>
