@extends('layouts.app')

@section('title', 'Sipariş Başarılı')

@section('content')
<div class="container py-4">
    <!-- Success Message -->
    <div class="row justify-content-center mb-5">
        <div class="col-md-8 text-center">
            <div class="mb-4">
                <i class="bi bi-check-circle-fill text-success" style="font-size: 5rem;"></i>
            </div>
            <h1 class="display-5 fw-bold text-success mb-3">Siparişiniz Alındı!</h1>
            <p class="lead text-muted mb-4">
                Siparişiniz başarıyla kaydedildi. En kısa sürede hazırlanarak size ulaştırılacaktır.
            </p>
            <div class="alert alert-success">
                <h5 class="fw-bold mb-2">Sipariş Numaranız: {{ $order->order_number }}</h5>
                <p class="mb-0">Bu numarayı sipariş takibi için saklayınız.</p>
            </div>
        </div>
    </div>

    <!-- Order Details -->
    <div class="row">
        <div class="col-lg-8">
            <!-- Order Items -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-bag-check me-2"></i>Sipariş Detayları
                    </h5>
                </div>
                <div class="card-body">
                    @foreach($order->items as $item)
                    <div class="row align-items-center py-3 {{ !$loop->last ? 'border-bottom' : '' }}">
                        <div class="col-md-2">
                            <div class="bg-gradient p-3 text-center rounded" 
                                 style="background: linear-gradient(135deg, {{ $item->product->category->color }}20, #E1F5FE);">
                                <i class="{{ $item->product->category->icon }} fs-3" 
                                   style="color: {{ $item->product->category->color }};"></i>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold mb-1">{{ $item->product_name }}</h6>
                            <p class="text-muted small mb-0">Ürün Kodu: {{ $item->product_sku }}</p>
                            <small class="text-muted">{{ $item->product->category->name }}</small>
                        </div>
                        <div class="col-md-2 text-center">
                            <span class="fw-bold">{{ $item->quantity }} adet</span>
                        </div>
                        <div class="col-md-2 text-end">
                            <span class="fw-bold text-primary">₺{{ number_format($item->total_price, 2) }}</span>
                            <br>
                            <small class="text-muted">₺{{ number_format($item->unit_price, 2) }} / adet</small>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Delivery Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslim Alacak Kişi:</h6>
                            <p class="mb-3">{{ $order->delivery_name }}</p>
                            
                            <h6 class="fw-bold">Telefon:</h6>
                            <p class="mb-3">{{ $order->delivery_phone }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslimat Tarihi:</h6>
                            <p class="mb-3">{{ $order->delivery_date->format('d.m.Y') }}
                                @if($order->delivery_time)
                                    <span class="text-muted">({{ $order->delivery_time }})</span>
                                @endif
                            </p>
                            
                            <h6 class="fw-bold">Ödeme Yöntemi:</h6>
                            <p class="mb-3">
                                @switch($order->payment_method)
                                    @case('cash')
                                        <i class="bi bi-cash me-1"></i>Kapıda Ödeme
                                        @break
                                    @case('card')
                                        <i class="bi bi-credit-card me-1"></i>Kredi Kartı
                                        @break
                                    @case('transfer')
                                        <i class="bi bi-bank me-1"></i>Havale/EFT
                                        @break
                                @endswitch
                            </p>
                        </div>
                    </div>
                    
                    <h6 class="fw-bold">Teslimat Adresi:</h6>
                    <p class="mb-3">
                        {{ $order->delivery_address }}<br>
                        {{ $order->delivery_district }}, {{ $order->delivery_city }}
                    </p>
                    
                    @if($order->delivery_notes)
                    <h6 class="fw-bold">Teslimat Notları:</h6>
                    <p class="mb-0">{{ $order->delivery_notes }}</p>
                    @endif
                </div>
            </div>

            @if($order->notes)
            <!-- Order Notes -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-chat-text me-2"></i>Sipariş Notları
                    </h5>
                </div>
                <div class="card-body">
                    <p class="mb-0">{{ $order->notes }}</p>
                </div>
            </div>
            @endif
        </div>

        <!-- Order Summary -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Sipariş Özeti</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span>₺{{ number_format($order->subtotal, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span class="{{ $order->shipping_cost == 0 ? 'text-success' : '' }}">
                            @if($order->shipping_cost == 0)
                                Ücretsiz
                            @else
                                ₺{{ number_format($order->shipping_cost, 2) }}
                            @endif
                        </span>
                    </div>
                    @if($order->discount_amount > 0)
                    <div class="d-flex justify-content-between mb-2">
                        <span>İndirim:</span>
                        <span class="text-success">-₺{{ number_format($order->discount_amount, 2) }}</span>
                    </div>
                    @endif
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary fs-5">₺{{ number_format($order->total_amount, 2) }}</strong>
                    </div>
                    
                    <!-- Order Status -->
                    <div class="alert alert-info">
                        <h6 class="fw-bold mb-2">
                            <i class="bi bi-info-circle me-2"></i>Sipariş Durumu
                        </h6>
                        <span class="badge bg-warning fs-6">{{ $order->status_text }}</span>
                        <p class="small mb-0 mt-2">
                            Siparişiniz hazırlanmaya başlandı. Kargo takip numaranız SMS ile bildirilecektir.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Next Steps -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-list-check me-2"></i>Sonraki Adımlar
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-3">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            <strong>Sipariş Alındı</strong>
                            <br>
                            <small class="text-muted">{{ $order->created_at->format('d.m.Y H:i') }}</small>
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-hourglass-split text-warning me-2"></i>
                            <strong>Hazırlanıyor</strong>
                            <br>
                            <small class="text-muted">Çiçekleriniz özenle hazırlanıyor</small>
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-truck text-muted me-2"></i>
                            <strong>Kargoya Verilecek</strong>
                            <br>
                            <small class="text-muted">Teslimat için yola çıkacak</small>
                        </li>
                        <li class="mb-0">
                            <i class="bi bi-house text-muted me-2"></i>
                            <strong>Teslim Edilecek</strong>
                            <br>
                            <small class="text-muted">{{ $order->delivery_date->format('d.m.Y') }} tarihinde</small>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="row mt-4">
        <div class="col-12 text-center">
            <a href="{{ route('orders.show', $order->id) }}" class="btn btn-primary me-3">
                <i class="bi bi-eye me-2"></i>Siparişi Takip Et
            </a>
            <a href="{{ route('home') }}" class="btn btn-outline-primary me-3">
                <i class="bi bi-house me-2"></i>Ana Sayfaya Dön
            </a>
            <a href="{{ route('products.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-flower1 me-2"></i>Alışverişe Devam Et
            </a>
        </div>
    </div>
</div>
@endsection
