@extends('layouts.app')

@section('title', 'Slider Yönetimi')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-images me-2"></i>Slider Yönetimi
                    </h1>
                    <p class="text-muted mb-0">Ana sayfa slider'larını yönetin</p>
                </div>
                <div>
                    <a href="{{ route('admin.sliders.create') }}" class="btn btn-primary btn-lg">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Slider Ekle
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Sliders Grid -->
    <div class="row g-4">
        @forelse($sliders as $slider)
        <div class="col-xl-6 col-lg-12">
            <div class="card border-0 shadow-sm h-100">
                <div class="position-relative">
                    <img src="{{ asset('storage/' . $slider->image) }}" 
                         alt="{{ $slider->title }}" 
                         class="card-img-top" 
                         style="height: 200px; object-fit: cover;">
                    
                    <!-- Status Toggle -->
                    <div class="position-absolute top-0 end-0 m-3">
                        <div class="form-check form-switch">
                            <input class="form-check-input slider-toggle bg-white shadow" type="checkbox" 
                                   data-slider-id="{{ $slider->id }}"
                                   {{ $slider->is_active ? 'checked' : '' }}>
                        </div>
                    </div>
                    
                    <!-- Sort Order Badge -->
                    <div class="position-absolute top-0 start-0 m-3">
                        <span class="badge bg-dark bg-opacity-75">Sıra: {{ $slider->sort_order }}</span>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="flex-grow-1">
                            <h5 class="card-title mb-2">{{ $slider->title }}</h5>
                            @if($slider->description)
                            <p class="text-muted small mb-2">{{ Str::limit($slider->description, 100) }}</p>
                            @endif
                        </div>
                        <div class="flex-shrink-0 ms-3">
                            <span class="badge {{ $slider->is_active ? 'bg-success' : 'bg-secondary' }}">
                                {{ $slider->is_active ? 'Aktif' : 'Pasif' }}
                            </span>
                        </div>
                    </div>
                    
                    @if($slider->button_text && $slider->button_link)
                    <div class="mb-3">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-link-45deg text-primary me-2"></i>
                            <div>
                                <strong>{{ $slider->button_text }}</strong>
                                <br>
                                <small class="text-muted">{{ Str::limit($slider->button_link, 50) }}</small>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="row text-center mb-3">
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-primary mb-1">{{ $slider->sort_order }}</h6>
                                <small class="text-muted">Sıra</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-success mb-1">
                                    <i class="bi bi-{{ $slider->is_active ? 'check-circle' : 'x-circle' }}"></i>
                                </h6>
                                <small class="text-muted">Durum</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <h6 class="text-info mb-1">
                                {{ $slider->created_at->format('d.m.Y') }}
                            </h6>
                            <small class="text-muted">Tarih</small>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <small class="text-muted">
                            Son güncelleme: {{ $slider->updated_at->format('d.m.Y H:i') }}
                        </small>
                        <div class="btn-group btn-group-sm">
                            @if($slider->button_link)
                            <a href="{{ $slider->button_link }}" 
                               class="btn btn-outline-info" target="_blank" title="Linki Aç">
                                <i class="bi bi-box-arrow-up-right"></i>
                            </a>
                            @endif
                            <a href="{{ route('admin.sliders.edit', $slider->id) }}" 
                               class="btn btn-outline-primary" title="Düzenle">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <button type="button" class="btn btn-outline-danger delete-slider" 
                                    data-slider-id="{{ $slider->id }}" 
                                    data-slider-title="{{ $slider->title }}" title="Sil">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @empty
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-images display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Henüz Slider Yok</h3>
                <p class="text-muted mb-4">İlk slider'ınızı oluşturarak başlayın!</p>
                <a href="{{ route('admin.sliders.create') }}" class="btn btn-primary btn-lg">
                    <i class="bi bi-plus-circle me-2"></i>İlk Slider'ı Ekle
                </a>
            </div>
        </div>
        @endforelse
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Slider'ı Sil</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Dikkat!</strong> Bu işlem geri alınamaz.
                </div>
                <p id="delete-message"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <form id="delete-form" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Evet, Sil</button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Slider status toggle
    document.querySelectorAll('.slider-toggle').forEach(toggle => {
        toggle.addEventListener('change', function() {
            const sliderId = this.dataset.sliderId;
            const isActive = this.checked;
            
            fetch(`/admin/sliders/${sliderId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !isActive; // Revert on error
                    alert('Durum güncellenirken hata oluştu!');
                }
            })
            .catch(error => {
                this.checked = !isActive; // Revert on error
                alert('Bir hata oluştu!');
            });
        });
    });

    // Delete slider
    document.querySelectorAll('.delete-slider').forEach(button => {
        button.addEventListener('click', function() {
            const sliderId = this.dataset.sliderId;
            const sliderTitle = this.dataset.sliderTitle;
            
            const deleteForm = document.getElementById('delete-form');
            const deleteMessage = document.getElementById('delete-message');
            
            deleteForm.action = `/admin/sliders/${sliderId}`;
            deleteMessage.innerHTML = `<strong>${sliderTitle}</strong> slider'ını silmek istediğinizden emin misiniz?`;
            
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        });
    });
});
</script>
@endpush
@endsection
