@extends('layouts.app')

@section('title', 'Sipariş Detayı')

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.orders.index') }}">Sipariş Yönetimi</a></li>
                    <li class="breadcrumb-item active">Sipariş #{{ $order->order_number }}</li>
                </ol>
            </nav>
            
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">Sipariş #{{ $order->order_number }}</h1>
                    <p class="text-muted mb-0">{{ $order->created_at->format('d.m.Y H:i') }} tarihinde verildi</p>
                </div>
                <div>
                    <div class="btn-group">
                        <button type="button" class="btn btn-outline-primary print-order" data-order-id="{{ $order->id }}">
                            <i class="bi bi-printer me-2"></i>Yazdır
                        </button>
                        <button type="button" class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#trackingModal">
                            <i class="bi bi-truck me-2"></i>Kargo Takip
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Order Details -->
        <div class="col-lg-8">
            <!-- Order Status -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Sipariş Durumu
                        </h5>
                        <span class="badge bg-{{ $order->status_badge }} fs-6">{{ $order->status_text }}</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label for="order_status" class="form-label">Durum Değiştir</label>
                            <select class="form-select" id="order_status" data-order-id="{{ $order->id }}">
                                <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>Beklemede</option>
                                <option value="confirmed" {{ $order->status == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                                <option value="shipped" {{ $order->status == 'shipped' ? 'selected' : '' }}>Kargoda</option>
                                <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Teslim Edildi</option>
                                <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>İptal Edildi</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="tracking_number" class="form-label">Kargo Takip No</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="tracking_number" 
                                       value="{{ $order->tracking_number ?? '' }}" placeholder="Takip numarası girin">
                                <button class="btn btn-outline-primary" type="button" id="save_tracking">
                                    <i class="bi bi-check"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    @if($order->notes)
                    <div class="mt-3">
                        <label class="form-label">Sipariş Notları</label>
                        <div class="alert alert-info">
                            <i class="bi bi-chat-text me-2"></i>{{ $order->notes }}
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Order Items -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-bag-check me-2"></i>Sipariş Ürünleri
                    </h5>
                </div>
                <div class="card-body">
                    @foreach($order->items as $item)
                    <div class="row align-items-center py-3 {{ !$loop->last ? 'border-bottom' : '' }}">
                        <div class="col-md-2">
                            <div class="bg-gradient p-3 text-center rounded" 
                                 style="background: linear-gradient(135deg, {{ $item->product->category->color }}20, #E1F5FE);">
                                <i class="{{ $item->product->category->icon }} fs-3" 
                                   style="color: {{ $item->product->category->color }};"></i>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <h6 class="fw-bold mb-1">{{ $item->product_name }}</h6>
                            <p class="text-muted small mb-1">SKU: {{ $item->product_sku }}</p>
                            <small class="text-muted">{{ $item->product->category->name }}</small>
                            @if($item->product->stock_quantity <= 5)
                            <br>
                            <small class="text-warning">
                                <i class="bi bi-exclamation-triangle me-1"></i>Düşük stok: {{ $item->product->stock_quantity }} adet
                            </small>
                            @endif
                        </div>
                        <div class="col-md-2 text-center">
                            <span class="fw-bold">{{ $item->quantity }} adet</span>
                            <br>
                            <small class="text-muted">₺{{ number_format($item->unit_price, 2) }} / adet</small>
                        </div>
                        <div class="col-md-2 text-end">
                            <span class="fw-bold text-primary fs-5">₺{{ number_format($item->total_price, 2) }}</span>
                        </div>
                        <div class="col-md-1 text-end">
                            <a href="{{ route('admin.products.edit', $item->product->id) }}" 
                               class="btn btn-outline-primary btn-sm" title="Ürünü Düzenle">
                                <i class="bi bi-pencil"></i>
                            </a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Delivery Information -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslim Alacak Kişi:</h6>
                            <p class="mb-3">{{ $order->delivery_name }}</p>
                            
                            <h6 class="fw-bold">Telefon:</h6>
                            <p class="mb-3">
                                <a href="tel:{{ $order->delivery_phone }}" class="text-decoration-none">
                                    <i class="bi bi-telephone me-1"></i>{{ $order->delivery_phone }}
                                </a>
                            </p>
                            
                            <h6 class="fw-bold">Teslimat Adresi:</h6>
                            <p class="mb-3">
                                {{ $order->delivery_address }}<br>
                                {{ $order->delivery_district }}, {{ $order->delivery_city }}
                                <br>
                                <a href="https://maps.google.com/?q={{ urlencode($order->delivery_address . ', ' . $order->delivery_district . ', ' . $order->delivery_city) }}" 
                                   target="_blank" class="btn btn-outline-info btn-sm mt-2">
                                    <i class="bi bi-geo-alt me-1"></i>Haritada Göster
                                </a>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslimat Tarihi:</h6>
                            <p class="mb-3">
                                <i class="bi bi-calendar me-1"></i>
                                {{ $order->delivery_date->format('d.m.Y') }}
                                @if($order->delivery_time)
                                    <span class="text-muted">({{ $order->delivery_time }})</span>
                                @endif
                                @if($order->delivery_date->isPast() && $order->status !== 'delivered')
                                    <br><small class="text-danger">
                                        <i class="bi bi-exclamation-triangle me-1"></i>Teslimat tarihi geçti!
                                    </small>
                                @endif
                            </p>
                            
                            <h6 class="fw-bold">Ödeme Yöntemi:</h6>
                            <p class="mb-3">
                                @switch($order->payment_method)
                                    @case('cash')
                                        <span class="badge bg-warning">
                                            <i class="bi bi-cash me-1"></i>Kapıda Ödeme
                                        </span>
                                        @break
                                    @case('card')
                                        <span class="badge bg-primary">
                                            <i class="bi bi-credit-card me-1"></i>Kredi Kartı
                                        </span>
                                        @break
                                    @case('transfer')
                                        <span class="badge bg-info">
                                            <i class="bi bi-bank me-1"></i>Havale/EFT
                                        </span>
                                        @break
                                @endswitch
                            </p>
                            
                            @if($order->delivery_notes)
                            <h6 class="fw-bold">Teslimat Notları:</h6>
                            <div class="alert alert-light">
                                <i class="bi bi-chat-text me-2"></i>{{ $order->delivery_notes }}
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Customer Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-person me-2"></i>Müşteri Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" 
                             style="width: 50px; height: 50px;">
                            <i class="bi bi-person fs-4"></i>
                        </div>
                        <div>
                            <h6 class="mb-1">{{ $order->user->name }}</h6>
                            <small class="text-muted">{{ $order->user->email }}</small>
                        </div>
                    </div>
                    
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-primary mb-1">{{ $order->user->orders->count() }}</h4>
                                <small class="text-muted">Toplam Sipariş</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-success mb-1">₺{{ number_format($order->user->orders->sum('total_amount'), 0) }}</h4>
                            <small class="text-muted">Toplam Harcama</small>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="d-grid">
                        <a href="mailto:{{ $order->user->email }}" class="btn btn-outline-primary btn-sm">
                            <i class="bi bi-envelope me-2"></i>E-posta Gönder
                        </a>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Sipariş Özeti</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span>₺{{ number_format($order->subtotal, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span class="{{ $order->shipping_cost == 0 ? 'text-success' : '' }}">
                            @if($order->shipping_cost == 0)
                                Ücretsiz
                            @else
                                ₺{{ number_format($order->shipping_cost, 2) }}
                            @endif
                        </span>
                    </div>
                    @if($order->discount_amount > 0)
                    <div class="d-flex justify-content-between mb-2">
                        <span>İndirim:</span>
                        <span class="text-success">-₺{{ number_format($order->discount_amount, 2) }}</span>
                    </div>
                    @endif
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary fs-4">₺{{ number_format($order->total_amount, 2) }}</strong>
                    </div>
                </div>
            </div>

            <!-- Order Timeline -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-clock-history me-2"></i>Sipariş Geçmişi
                    </h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item completed">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Sipariş Alındı</h6>
                                <small class="text-muted">{{ $order->created_at->format('d.m.Y H:i') }}</small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ in_array($order->status, ['confirmed', 'shipped', 'delivered']) ? 'completed' : '' }}">
                            <div class="timeline-marker {{ in_array($order->status, ['confirmed', 'shipped', 'delivered']) ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Sipariş Onaylandı</h6>
                                <small class="text-muted">Hazırlanıyor</small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ in_array($order->status, ['shipped', 'delivered']) ? 'completed' : '' }}">
                            <div class="timeline-marker {{ in_array($order->status, ['shipped', 'delivered']) ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Kargoya Verildi</h6>
                                <small class="text-muted">
                                    @if($order->tracking_number)
                                        Takip No: {{ $order->tracking_number }}
                                    @else
                                        Kargo bilgisi bekleniyor
                                    @endif
                                </small>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $order->status === 'delivered' ? 'completed' : '' }}">
                            <div class="timeline-marker {{ $order->status === 'delivered' ? 'bg-success' : 'bg-secondary' }}"></div>
                            <div class="timeline-content">
                                <h6 class="fw-bold">Teslim Edildi</h6>
                                <small class="text-muted">{{ $order->delivery_date->format('d.m.Y') }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Order status update
    document.getElementById('order_status').addEventListener('change', function() {
        const orderId = this.dataset.orderId;
        const status = this.value;
        const statusText = this.options[this.selectedIndex].text;
        
        if (confirm(`Sipariş durumunu "${statusText}" olarak değiştirmek istediğinizden emin misiniz?`)) {
            updateOrderStatus(orderId, status);
        } else {
            // Revert selection
            this.value = '{{ $order->status }}';
        }
    });

    // Save tracking number
    document.getElementById('save_tracking').addEventListener('click', function() {
        const orderId = {{ $order->id }};
        const trackingNumber = document.getElementById('tracking_number').value;
        
        fetch(`/admin/orders/${orderId}/update-tracking`, {
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ tracking_number: trackingNumber })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Kargo takip numarası güncellendi!');
            } else {
                alert('Güncelleme sırasında hata oluştu!');
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
        });
    });

    function updateOrderStatus(orderId, status) {
        fetch(`/admin/orders/${orderId}/update-status`, {
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Durum güncellenirken hata oluştu!');
                document.getElementById('order_status').value = '{{ $order->status }}';
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
            document.getElementById('order_status').value = '{{ $order->status }}';
        });
    }
});
</script>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 15px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -23px;
    top: 5px;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 0 0 2px #dee2e6;
}

.timeline-item.completed .timeline-marker {
    box-shadow: 0 0 0 2px #28a745;
}

.timeline-content h6 {
    margin-bottom: 5px;
}
</style>
@endpush
@endsection
