<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Admin kullanıcı oluştur
        User::create([
            'name' => 'Admin',
            'email' => 'admin@cicekbahcesi.com',
            'password' => bcrypt('password'),
            'role' => 'admin',
            'phone' => '+90 212 123 45 67',
            'city' => 'İstanbul',
        ]);

        // Test müşteri oluştur
        User::create([
            'name' => 'Test Müşteri',
            'email' => 'musteri@test.com',
            'password' => bcrypt('password'),
            'role' => 'customer',
            'phone' => '+90 532 123 45 67',
            'city' => 'İstanbul',
        ]);

        // Kategorileri, ürünleri ve slider'ları oluştur
        $this->call([
            CategorySeeder::class,
            ProductSeeder::class,
            SliderSeeder::class,
        ]);
    }
}
