<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id'); // Sipariş ID
            $table->unsignedBigInteger('product_id'); // Ürün ID
            $table->string('product_name'); // Ürün adı (sipariş anındaki)
            $table->string('product_sku'); // Ürün kodu (sipariş anındaki)
            $table->decimal('unit_price', 10, 2); // Birim fiyat (sipariş anındaki)
            $table->integer('quantity'); // Miktar
            $table->decimal('total_price', 10, 2); // Toplam fiyat (unit_price * quantity)
            $table->json('product_attributes')->nullable(); // Ürün özellikleri (sipariş anındaki)
            $table->timestamps();

            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->index(['order_id', 'product_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_items');
    }
};
