<?php $__env->startSection('title', 'Sipariş Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-bag-check me-2"></i>Sipariş Yönetimi
                    </h1>
                    <p class="text-muted mb-0">Siparişleri görüntüleyin ve yönetin</p>
                </div>
                <div>
                    <div class="btn-group">
                        <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="bi bi-download me-2"></i>Dışa Aktar
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#"><i class="bi bi-file-excel me-2"></i>Excel</a></li>
                            <li><a class="dropdown-item" href="#"><i class="bi bi-file-pdf me-2"></i>PDF</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Bekleyen</h6>
                            <h3 class="mb-0"><?php echo e($stats['pending'] ?? 0); ?></h3>
                        </div>
                        <i class="bi bi-hourglass-split fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Onaylanan</h6>
                            <h3 class="mb-0"><?php echo e($stats['confirmed'] ?? 0); ?></h3>
                        </div>
                        <i class="bi bi-check-circle fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Kargoda</h6>
                            <h3 class="mb-0"><?php echo e($stats['shipped'] ?? 0); ?></h3>
                        </div>
                        <i class="bi bi-truck fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Teslim Edildi</h6>
                            <h3 class="mb-0"><?php echo e($stats['delivered'] ?? 0); ?></h3>
                        </div>
                        <i class="bi bi-house-check fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('admin.orders.index')); ?>">
                        <div class="row align-items-end">
                            <div class="col-md-2">
                                <label for="search" class="form-label">Sipariş Ara</label>
                                <input type="text" class="form-control" id="search" name="search" 
                                       value="<?php echo e(request('search')); ?>" placeholder="Sipariş no, müşteri...">
                            </div>
                            <div class="col-md-2">
                                <label for="status" class="form-label">Durum</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="">Tüm Durumlar</option>
                                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Beklemede</option>
                                    <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>>Onaylandı</option>
                                    <option value="shipped" <?php echo e(request('status') == 'shipped' ? 'selected' : ''); ?>>Kargoda</option>
                                    <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Teslim Edildi</option>
                                    <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>İptal Edildi</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="payment_method" class="form-label">Ödeme</label>
                                <select class="form-select" id="payment_method" name="payment_method">
                                    <option value="">Tümü</option>
                                    <option value="cash" <?php echo e(request('payment_method') == 'cash' ? 'selected' : ''); ?>>Kapıda Ödeme</option>
                                    <option value="card" <?php echo e(request('payment_method') == 'card' ? 'selected' : ''); ?>>Kredi Kartı</option>
                                    <option value="transfer" <?php echo e(request('payment_method') == 'transfer' ? 'selected' : ''); ?>>Havale/EFT</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="date_from" class="form-label">Başlangıç</label>
                                <input type="date" class="form-control" id="date_from" name="date_from" 
                                       value="<?php echo e(request('date_from')); ?>">
                            </div>
                            <div class="col-md-2">
                                <label for="date_to" class="form-label">Bitiş</label>
                                <input type="date" class="form-control" id="date_to" name="date_to" 
                                       value="<?php echo e(request('date_to')); ?>">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="bi bi-search me-1"></i>Filtrele
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Siparişler (<?php echo e($orders->total()); ?>)</h5>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-outline-secondary active">
                                <i class="bi bi-table"></i>
                            </button>
                            <button type="button" class="btn btn-outline-secondary">
                                <i class="bi bi-kanban"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <?php if($orders->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="60">
                                        <input type="checkbox" class="form-check-input" id="selectAll">
                                    </th>
                                    <th>Sipariş Bilgileri</th>
                                    <th width="150">Müşteri</th>
                                    <th width="120">Tutar</th>
                                    <th width="120">Durum</th>
                                    <th width="100">Ödeme</th>
                                    <th width="120">Teslimat</th>
                                    <th width="150">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" class="form-check-input order-checkbox" 
                                               value="<?php echo e($order->id); ?>">
                                    </td>
                                    <td>
                                        <div>
                                            <h6 class="mb-1 fw-bold">#<?php echo e($order->order_number); ?></h6>
                                            <small class="text-muted"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></small>
                                            <br>
                                            <small class="text-muted"><?php echo e($order->items->count()); ?> ürün</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <h6 class="mb-1"><?php echo e($order->user->name); ?></h6>
                                            <small class="text-muted"><?php echo e($order->delivery_phone); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="fw-bold text-success">₺<?php echo e(number_format($order->total_amount, 2)); ?></span>
                                        <?php if($order->shipping_cost > 0): ?>
                                        <br>
                                        <small class="text-muted">+₺<?php echo e(number_format($order->shipping_cost, 2)); ?> kargo</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-outline-<?php echo e($order->status_badge); ?> dropdown-toggle" 
                                                    type="button" data-bs-toggle="dropdown">
                                                <?php echo e($order->status_text); ?>

                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item status-update" href="#" 
                                                       data-order-id="<?php echo e($order->id); ?>" data-status="pending">
                                                    <i class="bi bi-hourglass-split me-2"></i>Beklemede
                                                </a></li>
                                                <li><a class="dropdown-item status-update" href="#" 
                                                       data-order-id="<?php echo e($order->id); ?>" data-status="confirmed">
                                                    <i class="bi bi-check-circle me-2"></i>Onaylandı
                                                </a></li>
                                                <li><a class="dropdown-item status-update" href="#" 
                                                       data-order-id="<?php echo e($order->id); ?>" data-status="shipped">
                                                    <i class="bi bi-truck me-2"></i>Kargoda
                                                </a></li>
                                                <li><a class="dropdown-item status-update" href="#" 
                                                       data-order-id="<?php echo e($order->id); ?>" data-status="delivered">
                                                    <i class="bi bi-house-check me-2"></i>Teslim Edildi
                                                </a></li>
                                                <li><hr class="dropdown-divider"></li>
                                                <li><a class="dropdown-item status-update text-danger" href="#" 
                                                       data-order-id="<?php echo e($order->id); ?>" data-status="cancelled">
                                                    <i class="bi bi-x-circle me-2"></i>İptal Et
                                                </a></li>
                                            </ul>
                                        </div>
                                    </td>
                                    <td>
                                        <?php switch($order->payment_method):
                                            case ('cash'): ?>
                                                <span class="badge bg-warning">
                                                    <i class="bi bi-cash me-1"></i>Kapıda
                                                </span>
                                                <?php break; ?>
                                            <?php case ('card'): ?>
                                                <span class="badge bg-primary">
                                                    <i class="bi bi-credit-card me-1"></i>Kart
                                                </span>
                                                <?php break; ?>
                                            <?php case ('transfer'): ?>
                                                <span class="badge bg-info">
                                                    <i class="bi bi-bank me-1"></i>Havale
                                                </span>
                                                <?php break; ?>
                                        <?php endswitch; ?>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="fw-bold"><?php echo e($order->delivery_date->format('d.m.Y')); ?></small>
                                            <?php if($order->delivery_time): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e($order->delivery_time); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>" 
                                               class="btn btn-outline-info" title="Detay">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <button type="button" class="btn btn-outline-primary" 
                                                    data-bs-toggle="modal" data-bs-target="#trackingModal<?php echo e($order->id); ?>" title="Kargo">
                                                <i class="bi bi-truck"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-success print-order" 
                                                    data-order-id="<?php echo e($order->id); ?>" title="Yazdır">
                                                <i class="bi bi-printer"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <h5 class="text-muted mt-3">Sipariş Bulunamadı</h5>
                        <p class="text-muted">Arama kriterlerinize uygun sipariş bulunamadı.</p>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if($orders->hasPages()): ?>
                <div class="card-footer bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-muted">
                            <?php echo e($orders->firstItem()); ?>-<?php echo e($orders->lastItem()); ?> / <?php echo e($orders->total()); ?> sipariş
                        </div>
                        <div>
                            <?php echo e($orders->appends(request()->query())->links()); ?>

                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Bulk Actions -->
    <div class="row mt-3">
        <div class="col-12">
            <div class="card border-0 shadow-sm" id="bulk-actions" style="display: none;">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <span class="me-3"><span id="selected-count">0</span> sipariş seçildi</span>
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-info" id="bulk-confirm">
                                <i class="bi bi-check-circle me-1"></i>Onayla
                            </button>
                            <button type="button" class="btn btn-outline-primary" id="bulk-ship">
                                <i class="bi bi-truck me-1"></i>Kargola
                            </button>
                            <button type="button" class="btn btn-outline-success" id="bulk-deliver">
                                <i class="bi bi-house-check me-1"></i>Teslim Et
                            </button>
                            <button type="button" class="btn btn-outline-warning" id="bulk-print">
                                <i class="bi bi-printer me-1"></i>Yazdır
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Select all functionality
    const selectAllCheckbox = document.getElementById('selectAll');
    const orderCheckboxes = document.querySelectorAll('.order-checkbox');
    const bulkActions = document.getElementById('bulk-actions');
    const selectedCount = document.getElementById('selected-count');

    selectAllCheckbox.addEventListener('change', function() {
        orderCheckboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
        updateBulkActions();
    });

    orderCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkActions);
    });

    function updateBulkActions() {
        const checkedBoxes = document.querySelectorAll('.order-checkbox:checked');
        const count = checkedBoxes.length;
        
        if (count > 0) {
            bulkActions.style.display = 'block';
            selectedCount.textContent = count;
        } else {
            bulkActions.style.display = 'none';
        }
        
        selectAllCheckbox.indeterminate = count > 0 && count < orderCheckboxes.length;
        selectAllCheckbox.checked = count === orderCheckboxes.length;
    }

    // Status update
    document.querySelectorAll('.status-update').forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const orderId = this.dataset.orderId;
            const status = this.dataset.status;
            const statusText = this.textContent.trim();
            
            if (confirm(`Sipariş durumunu "${statusText}" olarak değiştirmek istediğinizden emin misiniz?`)) {
                updateOrderStatus(orderId, status);
            }
        });
    });

    function updateOrderStatus(orderId, status) {
        fetch(`/admin/orders/${orderId}/update-status`, {
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Durum güncellenirken hata oluştu!');
            }
        })
        .catch(error => {
            alert('Bir hata oluştu!');
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>