<?php $__env->startSection('title', $story->title . ' - Story'); ?>

<?php $__env->startSection('content'); ?>
<div class="story-viewer position-fixed top-0 start-0 w-100 h-100" style="z-index: 9999; background: #000;">
    <!-- Story Header -->
    <div class="story-header position-absolute top-0 start-0 w-100 p-3" style="z-index: 10; background: linear-gradient(180deg, rgba(0,0,0,0.8) 0%, transparent 100%);">
        <div class="d-flex align-items-center justify-content-between">
            <!-- Back Button -->
            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-link text-white p-0">
                <i class="bi bi-arrow-left fs-4"></i>
            </a>
            
            <!-- Story Progress -->
            <div class="story-progress flex-grow-1 mx-3">
                <div class="d-flex gap-1">
                    <?php $__currentLoopData = $allStories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $storyItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="progress-bar flex-grow-1" style="height: 3px; background: rgba(255,255,255,0.3); border-radius: 2px;">
                        <div class="progress-fill" style="height: 100%; background: white; border-radius: 2px; width: <?php echo e($index < $currentIndex ? '100%' : ($index == $currentIndex ? '100%' : '0%')); ?>;"></div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            
            <!-- Close Button -->
            <a href="<?php echo e(route('home')); ?>" class="btn btn-link text-white p-0">
                <i class="bi bi-x-lg fs-4"></i>
            </a>
        </div>
        
        <!-- Story Info -->
        <div class="story-info mt-3">
            <div class="d-flex align-items-center">
                <div class="story-avatar me-2">
                    <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                        <i class="bi bi-flower1 text-white"></i>
                    </div>
                </div>
                <div>
                    <h6 class="text-white mb-0 fw-bold"><?php echo e(config('app.name', 'Çiçek Bahçesi')); ?></h6>
                    <small class="text-white-50"><?php echo e($story->created_at->diffForHumans()); ?></small>
                </div>
            </div>
        </div>
    </div>

    <!-- Story Content -->
    <div class="story-content position-relative w-100 h-100 d-flex align-items-center justify-content-center">
        <!-- Background -->
        <div class="story-background position-absolute w-100 h-100" 
             style="background: linear-gradient(135deg, <?php echo e($story->background_color); ?>, <?php echo e($story->background_color); ?>cc);">
        </div>
        
        <!-- Story Image -->
        <?php if($story->image): ?>
        <div class="story-image position-absolute w-100 h-100">
            <img src="<?php echo e($story->image_url); ?>" 
                 alt="<?php echo e($story->title); ?>" 
                 class="w-100 h-100" 
                 style="object-fit: cover;">
        </div>
        <?php endif; ?>
        
        <!-- Story Overlay -->
        <div class="story-overlay position-absolute w-100 h-100 d-flex flex-column justify-content-end p-4" 
             style="background: linear-gradient(0deg, rgba(0,0,0,0.7) 0%, transparent 50%);">
            <div class="story-text text-center">
                <h2 class="text-white fw-bold mb-3" style="color: <?php echo e($story->text_color); ?> !important;">
                    <?php echo e($story->title); ?>

                </h2>
                <?php if($story->description): ?>
                <p class="text-white mb-4" style="color: <?php echo e($story->text_color); ?> !important; font-size: 1.1rem;">
                    <?php echo e($story->description); ?>

                </p>
                <?php endif; ?>
                
                <!-- Action Button -->
                <?php if($story->type !== 'custom' || $story->custom_link): ?>
                <div class="story-action">
                    <a href="<?php echo e($story->link); ?>" class="btn btn-light btn-lg px-4 py-2 rounded-pill">
                        <?php if($story->type === 'product'): ?>
                            <i class="bi bi-bag me-2"></i>Ürünü Gör
                        <?php elseif($story->type === 'category'): ?>
                            <i class="bi bi-grid me-2"></i>Kategoriyi Gör
                        <?php else: ?>
                            <i class="bi bi-arrow-right me-2"></i>Devam Et
                        <?php endif; ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Navigation Areas -->
        <?php if($previousStory): ?>
        <a href="<?php echo e(route('story.show', $previousStory)); ?>" 
           class="story-nav story-nav-prev position-absolute start-0 top-0 h-100 d-flex align-items-center justify-content-start ps-3"
           style="width: 30%; z-index: 5;">
            <div class="nav-icon text-white opacity-0 transition-opacity">
                <i class="bi bi-chevron-left fs-1"></i>
            </div>
        </a>
        <?php endif; ?>
        
        <?php if($nextStory): ?>
        <a href="<?php echo e(route('story.show', $nextStory)); ?>" 
           class="story-nav story-nav-next position-absolute end-0 top-0 h-100 d-flex align-items-center justify-content-end pe-3"
           style="width: 30%; z-index: 5;">
            <div class="nav-icon text-white opacity-0 transition-opacity">
                <i class="bi bi-chevron-right fs-1"></i>
            </div>
        </a>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.story-viewer {
    background: #000;
}

.story-nav {
    text-decoration: none;
    transition: all 0.3s ease;
}

.story-nav:hover .nav-icon {
    opacity: 0.8 !important;
}

.story-nav:hover {
    background: rgba(255,255,255,0.1);
}

.transition-opacity {
    transition: opacity 0.3s ease;
}

.progress-fill {
    transition: width 0.3s ease;
}

.story-content {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .story-header {
        padding: 1rem !important;
    }
    
    .story-overlay {
        padding: 2rem 1rem !important;
    }
    
    .story-text h2 {
        font-size: 1.5rem !important;
    }
    
    .story-text p {
        font-size: 1rem !important;
    }
    
    .story-nav {
        width: 25% !important;
    }
}

/* Auto Progress Animation */
.story-progress-active .progress-fill {
    animation: progressFill 5s linear forwards;
}

@keyframes progressFill {
    from { width: 0%; }
    to { width: 100%; }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto progress to next story
    const currentProgressBar = document.querySelector('.story-progress .progress-bar:nth-child(<?php echo e($currentIndex + 1); ?>) .progress-fill');
    if (currentProgressBar) {
        currentProgressBar.parentElement.classList.add('story-progress-active');
        
        // Auto navigate to next story after 5 seconds
        <?php if($nextStory): ?>
        setTimeout(() => {
            window.location.href = '<?php echo e(route("story.show", $nextStory)); ?>';
        }, 5000);
        <?php else: ?>
        setTimeout(() => {
            window.location.href = '<?php echo e(route("home")); ?>';
        }, 5000);
        <?php endif; ?>
    }
    
    // Keyboard navigation
    document.addEventListener('keydown', function(e) {
        if (e.key === 'ArrowLeft' && <?php echo e($previousStory ? 'true' : 'false'); ?>) {
            window.location.href = '<?php echo e($previousStory ? route("story.show", $previousStory) : "#"); ?>';
        } else if (e.key === 'ArrowRight' && <?php echo e($nextStory ? 'true' : 'false'); ?>) {
            window.location.href = '<?php echo e($nextStory ? route("story.show", $nextStory) : "#"); ?>';
        } else if (e.key === 'Escape') {
            window.location.href = '<?php echo e(route("home")); ?>';
        }
    });
    
    // Touch/Click navigation
    let touchStartX = 0;
    let touchEndX = 0;
    
    document.addEventListener('touchstart', function(e) {
        touchStartX = e.changedTouches[0].screenX;
    });
    
    document.addEventListener('touchend', function(e) {
        touchEndX = e.changedTouches[0].screenX;
        handleSwipe();
    });
    
    function handleSwipe() {
        const swipeThreshold = 50;
        const diff = touchStartX - touchEndX;
        
        if (Math.abs(diff) > swipeThreshold) {
            if (diff > 0 && <?php echo e($nextStory ? 'true' : 'false'); ?>) {
                // Swipe left - next story
                window.location.href = '<?php echo e($nextStory ? route("story.show", $nextStory) : "#"); ?>';
            } else if (diff < 0 && <?php echo e($previousStory ? 'true' : 'false'); ?>) {
                // Swipe right - previous story
                window.location.href = '<?php echo e($previousStory ? route("story.show", $previousStory) : "#"); ?>';
            }
        }
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/story/show.blade.php ENDPATH**/ ?>