<?php $__env->startSection('title', 'Ödeme Başarılı'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card border-0 shadow-lg">
                <div class="card-body text-center py-5">
                    <!-- Success Icon -->
                    <div class="mb-4">
                        <div class="bg-success rounded-circle d-inline-flex align-items-center justify-content-center" 
                             style="width: 80px; height: 80px;">
                            <i class="bi bi-check-lg text-white fs-1"></i>
                        </div>
                    </div>

                    <!-- Success Message -->
                    <h2 class="text-success mb-3">Ödeme Başarılı!</h2>
                    <p class="text-muted mb-4">
                        Kredi kartı ödemesi başarıyla tamamlandı. Siparişiniz onaylandı ve işleme alındı.
                    </p>

                    <!-- Loading Animation -->
                    <div class="mb-4">
                        <div class="spinner-border text-primary me-2" role="status">
                            <span class="visually-hidden">Yükleniyor...</span>
                        </div>
                        <span class="text-muted">Sipariş sayfasına yönlendiriliyorsunuz...</span>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-grid gap-2 d-md-block">
                        <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-primary">
                            <i class="bi bi-list-check me-2"></i>Siparişlerim
                        </a>
                        <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-house me-2"></i>Ana Sayfa
                        </a>
                    </div>
                </div>
            </div>

            <!-- Additional Info -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body">
                    <h6 class="text-primary mb-3">
                        <i class="bi bi-info-circle me-2"></i>Sonraki Adımlar
                    </h6>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <i class="bi bi-check text-success me-2"></i>
                            Ödeme onayı e-posta adresinize gönderildi
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check text-success me-2"></i>
                            Siparişiniz hazırlanmaya başlandı
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-clock text-warning me-2"></i>
                            Kargo takip numarası SMS ile bildirilecek
                        </li>
                        <li>
                            <i class="bi bi-truck text-info me-2"></i>
                            Teslimat tarihinizde siparişiniz adresinize ulaşacak
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // 3 saniye sonra siparişler sayfasına yönlendir
    setTimeout(function() {
        window.location.href = '<?php echo e(route("orders.index")); ?>';
    }, 3000);
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/payment/success.blade.php ENDPATH**/ ?>