<?php $__env->startSection('title', 'Arama Sonuçları'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <?php if($query): ?>
            <h1 class="display-5 fw-bold text-primary mb-3">
                "<?php echo e($query); ?>" için arama sonuçları
            </h1>
            <?php if($products->count() > 0): ?>
            <p class="text-muted"><?php echo e($products->total()); ?> ürün bulundu</p>
            <?php endif; ?>
            <?php else: ?>
            <h1 class="display-5 fw-bold text-primary mb-3">Arama</h1>
            <p class="text-muted">Aradığınız ürünü yazın</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Search Form -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <form action="<?php echo e(route('products.search')); ?>" method="GET">
                        <div class="input-group input-group-lg">
                            <input type="text" name="q" class="form-control" 
                                   placeholder="Çiçek, buket, orkide..." 
                                   value="<?php echo e($query); ?>" autofocus>
                            <button class="btn btn-primary" type="submit">
                                <i class="bi bi-search me-2"></i>Ara
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php if($query): ?>
        <?php if($products->count() > 0): ?>
        <!-- Search Results -->
        <div class="row g-4">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="position-relative">
                        <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, <?php echo e($product->category->color); ?>20, #E1F5FE); height: 200px;">
                            <i class="<?php echo e($product->category->icon); ?>" style="font-size: 4rem; color: <?php echo e($product->category->color); ?>;"></i>
                        </div>
                        <?php if($product->sale_price): ?>
                        <span class="position-absolute top-0 end-0 badge bg-danger m-2">-<?php echo e($product->discount_percentage); ?>%</span>
                        <?php endif; ?>
                        <?php if($product->stock_quantity <= 5): ?>
                        <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son <?php echo e($product->stock_quantity); ?> adet!</span>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <h6 class="card-title fw-bold"><?php echo e($product->name); ?></h6>
                        <p class="card-text text-muted small"><?php echo e($product->short_description); ?></p>
                        <div class="mb-2">
                            <small class="text-muted">
                                <i class="bi bi-tag me-1"></i><?php echo e($product->category->name); ?>

                            </small>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <?php if($product->sale_price): ?>
                                <span class="text-decoration-line-through text-muted small">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                <span class="fw-bold text-primary ms-2">₺<?php echo e(number_format($product->sale_price, 2)); ?></span>
                                <?php else: ?>
                                <span class="fw-bold text-primary">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                <?php endif; ?>
                            </div>
                            <div>
                                <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="btn btn-outline-primary btn-sm me-1">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <form action="<?php echo e(route('cart.add', $product->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="quantity" value="1">
                                    <button type="submit" class="btn btn-primary btn-sm" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                                        <i class="bi bi-bag-plus"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($products->links()); ?>

        </div>
        <?php else: ?>
        <!-- No Results -->
        <div class="text-center py-5">
            <i class="bi bi-search display-1 text-muted mb-4" style="opacity: 0.3;"></i>
            <h3 class="text-muted mb-3">Arama sonucu bulunamadı</h3>
            <p class="text-muted mb-4">"<?php echo e($query); ?>" için herhangi bir ürün bulunamadı. Farklı anahtar kelimeler deneyin.</p>
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card border-0 bg-light">
                        <div class="card-body">
                            <h6 class="fw-bold mb-3">Arama önerileri:</h6>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-2">• Daha genel terimler kullanın (örn: "gül" yerine "çiçek")</li>
                                <li class="mb-2">• Yazım hatalarını kontrol edin</li>
                                <li class="mb-2">• Farklı kelimeler deneyin</li>
                                <li class="mb-2">• Kategorilere göz atın</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    <?php else: ?>
    <!-- Popular Searches -->
    <div class="row">
        <div class="col-12">
            <h4 class="fw-bold mb-4">Popüler Aramalar</h4>
            <div class="d-flex flex-wrap gap-2 mb-4">
                <a href="<?php echo e(route('products.search', ['q' => 'gül'])); ?>" class="btn btn-outline-primary">Gül</a>
                <a href="<?php echo e(route('products.search', ['q' => 'buket'])); ?>" class="btn btn-outline-primary">Buket</a>
                <a href="<?php echo e(route('products.search', ['q' => 'orkide'])); ?>" class="btn btn-outline-primary">Orkide</a>
                <a href="<?php echo e(route('products.search', ['q' => 'sevgililer günü'])); ?>" class="btn btn-outline-primary">Sevgililer Günü</a>
                <a href="<?php echo e(route('products.search', ['q' => 'doğum günü'])); ?>" class="btn btn-outline-primary">Doğum Günü</a>
                <a href="<?php echo e(route('products.search', ['q' => 'saksı'])); ?>" class="btn btn-outline-primary">Saksı Çiçekleri</a>
            </div>
        </div>
    </div>

    <!-- Categories -->
    <div class="row">
        <div class="col-12">
            <h4 class="fw-bold mb-4">Kategorilere Göz Atın</h4>
            <div class="row g-3">
                <div class="col-md-3">
                    <a href="<?php echo e(route('categories.show', 'guller')); ?>" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower1 text-danger mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Güller</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="<?php echo e(route('categories.show', 'orkideler')); ?>" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower2 text-purple mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Orkideler</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="<?php echo e(route('categories.show', 'buketler')); ?>" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-gift text-warning mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Buketler</h6>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="<?php echo e(route('categories.show', 'saksi-cicekleri')); ?>" class="text-decoration-none">
                        <div class="card border-0 bg-light h-100">
                            <div class="card-body text-center">
                                <i class="bi bi-flower3 text-success mb-2" style="font-size: 2rem;"></i>
                                <h6 class="fw-bold">Saksı Çiçekleri</h6>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/products/search.blade.php ENDPATH**/ ?>