<?php $__env->startSection('title', 'Sipariş Ver'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Ana Sayfa</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('cart.index')); ?>">Sepetim</a></li>
                    <li class="breadcrumb-item active">Sipariş Ver</li>
                </ol>
            </nav>
            <h1 class="display-5 fw-bold text-primary mb-3">Sipariş Ver</h1>
        </div>
    </div>

    <?php if(empty($cart) || count($cart) == 0): ?>
    <!-- Empty Cart -->
    <div class="row">
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-bag-x display-1 text-muted mb-4"></i>
                <h3 class="text-muted mb-3">Sepetiniz Boş</h3>
                <p class="text-muted mb-4">Sipariş verebilmek için sepetinizde ürün bulunmalıdır.</p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary btn-lg">
                    <i class="bi bi-flower1 me-2"></i>Alışverişe Başla
                </a>
            </div>
        </div>
    </div>
    <?php else: ?>
    <form action="<?php echo e(route('checkout.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <!-- Checkout Form -->
            <div class="col-lg-8">
                <!-- Delivery Information -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_name" class="form-label">Teslim Alacak Kişi *</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['delivery_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="delivery_name" name="delivery_name" 
                                       value="<?php echo e(old('delivery_name', Auth::user()->name ?? '')); ?>" required>
                                <?php $__errorArgs = ['delivery_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_phone" class="form-label">Telefon Numarası *</label>
                                <input type="tel" class="form-control <?php $__errorArgs = ['delivery_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="delivery_phone" name="delivery_phone" 
                                       value="<?php echo e(old('delivery_phone', Auth::user()->phone ?? '')); ?>" required>
                                <?php $__errorArgs = ['delivery_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="delivery_address" class="form-label">Teslimat Adresi *</label>
                            <textarea class="form-control <?php $__errorArgs = ['delivery_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="delivery_address" name="delivery_address" rows="3" required><?php echo e(old('delivery_address', Auth::user()->address ?? '')); ?></textarea>
                            <?php $__errorArgs = ['delivery_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_city" class="form-label">Şehir *</label>
                                <select class="form-select <?php $__errorArgs = ['delivery_city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="delivery_city" name="delivery_city" required>
                                    <option value="">Şehir Seçin</option>
                                    <option value="İstanbul" <?php echo e(old('delivery_city', Auth::user()->city ?? '') == 'İstanbul' ? 'selected' : ''); ?>>İstanbul</option>
                                    <option value="Ankara" <?php echo e(old('delivery_city') == 'Ankara' ? 'selected' : ''); ?>>Ankara</option>
                                    <option value="İzmir" <?php echo e(old('delivery_city') == 'İzmir' ? 'selected' : ''); ?>>İzmir</option>
                                    <option value="Bursa" <?php echo e(old('delivery_city') == 'Bursa' ? 'selected' : ''); ?>>Bursa</option>
                                    <option value="Antalya" <?php echo e(old('delivery_city') == 'Antalya' ? 'selected' : ''); ?>>Antalya</option>
                                </select>
                                <?php $__errorArgs = ['delivery_city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_district" class="form-label">İlçe *</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['delivery_district'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="delivery_district" name="delivery_district" 
                                       value="<?php echo e(old('delivery_district', Auth::user()->district ?? '')); ?>" required>
                                <?php $__errorArgs = ['delivery_district'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_date" class="form-label">Teslimat Tarihi *</label>
                                <input type="date" class="form-control <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="delivery_date" name="delivery_date" 
                                       value="<?php echo e(old('delivery_date', date('Y-m-d', strtotime('+1 day')))); ?>" 
                                       min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>" required>
                                <?php $__errorArgs = ['delivery_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_time" class="form-label">Teslimat Saati</label>
                                <select class="form-select" id="delivery_time" name="delivery_time">
                                    <option value="">Saat Seçin (İsteğe Bağlı)</option>
                                    <option value="09:00-12:00" <?php echo e(old('delivery_time') == '09:00-12:00' ? 'selected' : ''); ?>>09:00 - 12:00</option>
                                    <option value="12:00-15:00" <?php echo e(old('delivery_time') == '12:00-15:00' ? 'selected' : ''); ?>>12:00 - 15:00</option>
                                    <option value="15:00-18:00" <?php echo e(old('delivery_time') == '15:00-18:00' ? 'selected' : ''); ?>>15:00 - 18:00</option>
                                    <option value="18:00-21:00" <?php echo e(old('delivery_time') == '18:00-21:00' ? 'selected' : ''); ?>>18:00 - 21:00</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="delivery_notes" class="form-label">Teslimat Notları</label>
                            <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="2" 
                                      placeholder="Özel talimatlar, adres tarifi vb."><?php echo e(old('delivery_notes')); ?></textarea>
                        </div>
                    </div>
                </div>

                <!-- Payment Method -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-credit-card me-2"></i>Ödeme Yöntemi
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="cash" value="cash"
                                           <?php echo e(old('payment_method', 'cash') == 'cash' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="cash">
                                        <i class="bi bi-cash me-2"></i>Kapıda Ödeme
                                    </label>
                                </div>
                            </div>
                            <?php if($paytrEnabled): ?>
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="card" value="card"
                                           <?php echo e(old('payment_method') == 'card' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="card">
                                        <i class="bi bi-credit-card me-2"></i>Kredi Kartı
                                        <span class="badge bg-success ms-2">Güvenli</span>
                                    </label>
                                    <small class="text-muted d-block mt-1">PayTR ile güvenli ödeme</small>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="transfer" value="transfer"
                                           <?php echo e(old('payment_method') == 'transfer' ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="transfer">
                                        <i class="bi bi-bank me-2"></i>Havale/EFT
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <div class="mb-2">
                                <strong>Kapıda Ödeme:</strong> Siparişiniz teslim edilirken nakit olarak ödeme yapabilirsiniz.
                            </div>
                            <?php if($paytrEnabled): ?>
                            <div class="mb-2">
                                <strong>Kredi Kartı:</strong> PayTR güvenli ödeme sistemi ile anında ödeme yapabilirsiniz. Tüm kredi kartları kabul edilir.
                            </div>
                            <?php endif; ?>
                            <div>
                                <strong>Havale/EFT:</strong> Banka hesabımıza havale veya EFT ile ödeme yapabilirsiniz.
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Notes -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-chat-text me-2"></i>Sipariş Notları
                        </h5>
                    </div>
                    <div class="card-body">
                        <textarea class="form-control" name="notes" rows="3" 
                                  placeholder="Siparişinizle ilgili özel notlarınız..."><?php echo e(old('notes')); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm sticky-top" style="top: 100px;">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Sipariş Özeti</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $subtotal = 0;
                        ?>
                        
                        <!-- Cart Items -->
                        <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $itemTotal = $item['price'] * $item['quantity'];
                        $subtotal += $itemTotal;
                        ?>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div class="flex-grow-1">
                                <h6 class="mb-0 small"><?php echo e($item['name']); ?></h6>
                                <small class="text-muted"><?php echo e($item['quantity']); ?> x ₺<?php echo e(number_format($item['price'], 2)); ?></small>
                            </div>
                            <span class="fw-bold">₺<?php echo e(number_format($itemTotal, 2)); ?></span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <hr>
                        
                        <!-- Pricing -->
                        <div class="d-flex justify-content-between mb-2">
                            <span>Ara Toplam:</span>
                            <span>₺<?php echo e(number_format($subtotal, 2)); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Kargo:</span>
                            <span class="text-success">
                                <?php if($subtotal >= 200): ?>
                                    Ücretsiz
                                <?php else: ?>
                                    ₺15.00
                                <?php endif; ?>
                            </span>
                        </div>
                        <?php if($subtotal < 200): ?>
                        <div class="alert alert-info small">
                            <i class="bi bi-info-circle me-1"></i>
                            ₺<?php echo e(number_format(200 - $subtotal, 2)); ?> daha alışveriş yapın, kargo ücretsiz olsun!
                        </div>
                        <?php endif; ?>
                        <hr>
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Toplam:</strong>
                            <strong class="text-primary fs-5">₺<?php echo e(number_format($subtotal >= 200 ? $subtotal : $subtotal + 15, 2)); ?></strong>
                        </div>
                        
                        <!-- Submit Button -->
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i>Siparişi Tamamla
                            </button>
                            <a href="<?php echo e(route('cart.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Sepete Dön
                            </a>
                        </div>
                        
                        <!-- Security Info -->
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="bi bi-shield-check me-1"></i>
                                Güvenli alışveriş garantisi
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/checkout/index.blade.php ENDPATH**/ ?>