<?php $__env->startSection('title', 'PayTR Ödeme Ayarları'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="bi bi-credit-card-2-front me-2"></i>PayTR Ödeme Ayarları
            </h1>
            <p class="text-muted mb-0">Kredi kartı ödemelerini yönetin</p>
        </div>
    </div>

    <!-- Success Message -->
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- Error Messages -->
    <?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i>
        <strong>Hata!</strong> Lütfen aşağıdaki hataları düzeltin:
        <ul class="mb-0 mt-2">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <!-- PayTR Settings Card -->
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="card-title mb-0">
                <i class="bi bi-gear me-2"></i>PayTR Konfigürasyonu
            </h5>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.payment-settings.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <!-- PayTR Aktif/Pasif -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="paytr_enabled" name="paytr_enabled" value="1"
                                   <?php echo e($settings->get('paytr_enabled')?->value ? 'checked' : ''); ?>>
                            <label class="form-check-label fw-bold" for="paytr_enabled">
                                PayTR Ödeme Sistemini Aktif Et
                            </label>
                        </div>
                        <small class="text-muted">Bu seçenek aktif edildiğinde müşteriler kredi kartı ile ödeme yapabilir.</small>
                    </div>
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="paytr_test_mode" name="paytr_test_mode" value="1"
                                   <?php echo e($settings->get('paytr_test_mode')?->value ? 'checked' : ''); ?>>
                            <label class="form-check-label fw-bold" for="paytr_test_mode">
                                Test Modu
                            </label>
                        </div>
                        <small class="text-muted">Test modunda gerçek para çekilmez, sadece test işlemleri yapılır.</small>
                    </div>
                </div>

                <hr>

                <!-- PayTR API Bilgileri -->
                <div class="row">
                    <div class="col-md-12 mb-4">
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-key me-2"></i>API Bilgileri
                        </h6>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgi:</strong> Bu bilgileri PayTR hesabınızdan alabilirsiniz. 
                            <a href="https://www.paytr.com" target="_blank" class="alert-link">PayTR Paneli</a>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Merchant ID -->
                    <div class="col-md-4 mb-3">
                        <label for="paytr_merchant_id" class="form-label fw-bold">
                            <i class="bi bi-person-badge me-1"></i>Merchant ID
                        </label>
                        <input type="text" class="form-control" id="paytr_merchant_id" name="paytr_merchant_id"
                               value="<?php echo e($settings->get('paytr_merchant_id')?->value); ?>"
                               placeholder="Merchant ID'nizi girin">
                        <small class="text-muted">PayTR'den aldığınız Merchant ID</small>
                    </div>

                    <!-- Merchant Key -->
                    <div class="col-md-4 mb-3">
                        <label for="paytr_merchant_key" class="form-label fw-bold">
                            <i class="bi bi-key me-1"></i>Merchant Key
                        </label>
                        <input type="password" class="form-control" id="paytr_merchant_key" name="paytr_merchant_key"
                               value="<?php echo e($settings->get('paytr_merchant_key')?->value); ?>"
                               placeholder="Merchant Key'inizi girin">
                        <small class="text-muted">PayTR'den aldığınız Merchant Key (gizli)</small>
                    </div>

                    <!-- Merchant Salt -->
                    <div class="col-md-4 mb-3">
                        <label for="paytr_merchant_salt" class="form-label fw-bold">
                            <i class="bi bi-shield-lock me-1"></i>Merchant Salt
                        </label>
                        <input type="password" class="form-control" id="paytr_merchant_salt" name="paytr_merchant_salt"
                               value="<?php echo e($settings->get('paytr_merchant_salt')?->value); ?>"
                               placeholder="Merchant Salt'ınızı girin">
                        <small class="text-muted">PayTR'den aldığınız Merchant Salt (gizli)</small>
                    </div>
                </div>

                <!-- Test Bilgileri -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="alert alert-warning">
                            <h6 class="alert-heading">
                                <i class="bi bi-exclamation-triangle me-2"></i>Test Kartları
                            </h6>
                            <p class="mb-2">Test modunda aşağıdaki kart bilgilerini kullanabilirsiniz:</p>
                            <ul class="mb-0">
                                <li><strong>Başarılı Test:</strong> 4355 0841 0000 0001 - CVV: 123 - Son Kullanma: 12/26</li>
                                <li><strong>Başarısız Test:</strong> 4355 0841 0000 0002 - CVV: 123 - Son Kullanma: 12/26</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="row mt-4">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-check-lg me-2"></i>Ayarları Kaydet
                        </button>
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary btn-lg ms-2">
                            <i class="bi bi-arrow-left me-2"></i>Geri Dön
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- PayTR Status Card -->
    <div class="card shadow-sm mt-4">
        <div class="card-header bg-info text-white">
            <h5 class="card-title mb-0">
                <i class="bi bi-info-circle me-2"></i>PayTR Durumu
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="badge <?php echo e($settings->get('paytr_enabled')?->value ? 'bg-success' : 'bg-danger'); ?> fs-6 p-2">
                            <?php echo e($settings->get('paytr_enabled')?->value ? 'AKTİF' : 'PASİF'); ?>

                        </div>
                        <p class="text-muted mt-2 mb-0">PayTR Durumu</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="badge <?php echo e($settings->get('paytr_test_mode')?->value ? 'bg-warning' : 'bg-success'); ?> fs-6 p-2">
                            <?php echo e($settings->get('paytr_test_mode')?->value ? 'TEST' : 'CANLI'); ?>

                        </div>
                        <p class="text-muted mt-2 mb-0">Çalışma Modu</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="badge <?php echo e($settings->get('paytr_merchant_id')?->value ? 'bg-success' : 'bg-danger'); ?> fs-6 p-2">
                            <?php echo e($settings->get('paytr_merchant_id')?->value ? 'TAMAMLANDI' : 'EKSİK'); ?>

                        </div>
                        <p class="text-muted mt-2 mb-0">API Konfigürasyonu</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="badge bg-primary fs-6 p-2">
                            v3.0
                        </div>
                        <p class="text-muted mt-2 mb-0">PayTR API Versiyonu</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // PayTR aktif/pasif durumuna göre form alanlarını kontrol et
    const paytrEnabled = document.getElementById('paytr_enabled');
    const apiFields = document.querySelectorAll('#paytr_merchant_id, #paytr_merchant_key, #paytr_merchant_salt');
    
    function toggleApiFields() {
        apiFields.forEach(field => {
            if (paytrEnabled.checked) {
                field.removeAttribute('disabled');
                field.closest('.col-md-4').style.opacity = '1';
            } else {
                field.setAttribute('disabled', 'disabled');
                field.closest('.col-md-4').style.opacity = '0.5';
            }
        });
    }
    
    // Sayfa yüklendiğinde kontrol et
    toggleApiFields();
    
    // PayTR checkbox değiştiğinde kontrol et
    paytrEnabled.addEventListener('change', toggleApiFields);
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/payment-settings.blade.php ENDPATH**/ ?>