<?php $__env->startSection('title', 'Siparişlerim'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Ana Sayfa</a></li>
                    <li class="breadcrumb-item active">Siparişlerim</li>
                </ol>
            </nav>
            <h1 class="display-5 fw-bold text-primary mb-3">Siparişlerim</h1>
            <p class="text-muted">Geçmiş siparişlerinizi görüntüleyebilir ve takip edebilirsiniz.</p>
        </div>
    </div>

    <?php if($orders->count() > 0): ?>
    <!-- Orders List -->
    <div class="row">
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <h6 class="fw-bold mb-1">Sipariş #<?php echo e($order->order_number); ?></h6>
                            <small class="text-muted"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></small>
                        </div>
                        <div class="col-md-3">
                            <span class="badge bg-<?php echo e($order->status_badge); ?> fs-6"><?php echo e($order->status_text); ?></span>
                        </div>
                        <div class="col-md-3">
                            <strong class="text-primary">₺<?php echo e(number_format($order->total_amount, 2)); ?></strong>
                            <br>
                            <small class="text-muted"><?php echo e($order->items->count()); ?> ürün</small>
                        </div>
                        <div class="col-md-3 text-end">
                            <a href="<?php echo e(route('orders.show', $order->id)); ?>" class="btn btn-outline-primary btn-sm">
                                <i class="bi bi-eye me-1"></i>Detay
                            </a>
                            <?php if($order->status === 'pending'): ?>
                            <form action="<?php echo e(route('orders.cancel', $order->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <button type="submit" class="btn btn-outline-danger btn-sm" 
                                        onclick="return confirm('Bu siparişi iptal etmek istediğinizden emin misiniz?')">
                                    <i class="bi bi-x-circle me-1"></i>İptal
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <!-- Order Items Preview -->
                            <div class="d-flex flex-wrap gap-2">
                                <?php $__currentLoopData = $order->items->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex align-items-center bg-light rounded p-2">
                                    <div class="me-2">
                                        <i class="<?php echo e($item->product->category->icon); ?>" 
                                           style="color: <?php echo e($item->product->category->color); ?>; font-size: 1.5rem;"></i>
                                    </div>
                                    <div>
                                        <small class="fw-bold"><?php echo e($item->product_name); ?></small>
                                        <br>
                                        <small class="text-muted"><?php echo e($item->quantity); ?> adet</small>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($order->items->count() > 3): ?>
                                <div class="d-flex align-items-center">
                                    <small class="text-muted">+<?php echo e($order->items->count() - 3); ?> ürün daha</small>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <!-- Delivery Info -->
                            <div class="text-end">
                                <small class="text-muted">
                                    <i class="bi bi-truck me-1"></i>
                                    Teslimat: <?php echo e($order->delivery_date->format('d.m.Y')); ?>

                                    <?php if($order->delivery_time): ?>
                                        (<?php echo e($order->delivery_time); ?>)
                                    <?php endif; ?>
                                </small>
                                <br>
                                <small class="text-muted">
                                    <i class="bi bi-geo-alt me-1"></i>
                                    <?php echo e($order->delivery_city); ?>, <?php echo e($order->delivery_district); ?>

                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-center">
        <?php echo e($orders->links()); ?>

    </div>
    <?php else: ?>
    <!-- No Orders -->
    <div class="row">
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-bag-x display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Henüz Siparişiniz Yok</h3>
                <p class="text-muted mb-4">İlk siparişinizi vererek güzel çiçeklerimizi keşfedin!</p>
                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary btn-lg">
                    <i class="bi bi-flower1 me-2"></i>Alışverişe Başla
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Order Status Info -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card border-0 bg-light">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">
                        <i class="bi bi-info-circle me-2"></i>Sipariş Durumları
                    </h6>
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <span class="badge bg-warning me-2">Beklemede</span>
                            <small>Sipariş alındı, hazırlanıyor</small>
                        </div>
                        <div class="col-md-3 mb-2">
                            <span class="badge bg-info me-2">Onaylandı</span>
                            <small>Sipariş onaylandı</small>
                        </div>
                        <div class="col-md-3 mb-2">
                            <span class="badge bg-primary me-2">Kargoda</span>
                            <small>Kargoya verildi</small>
                        </div>
                        <div class="col-md-3 mb-2">
                            <span class="badge bg-success me-2">Teslim Edildi</span>
                            <small>Başarıyla teslim edildi</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/orders/index.blade.php ENDPATH**/ ?>