<form method="post" action="{{ route('profile.update') }}">
    @csrf
    @method('patch')

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="name" class="form-label">Ad Soyad</label>
            <input type="text" class="form-control @error('name') is-invalid @enderror"
                   id="name" name="name" value="{{ old('name', $user->name) }}" required autofocus>
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-3">
            <label for="email" class="form-label">E-posta Adresi</label>
            <input type="email" class="form-control @error('email') is-invalid @enderror"
                   id="email" name="email" value="{{ old('email', $user->email) }}" required>
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror

            @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                <div class="alert alert-warning mt-2">
                    <small>
                        E-posta adresiniz doğrulanmamış.
                        <button form="send-verification" class="btn btn-link btn-sm p-0">
                            Doğrulama e-postası gönder
                        </button>
                    </small>
                </div>

                @if (session('status') === 'verification-link-sent')
                    <div class="alert alert-success mt-2">
                        <small>Yeni doğrulama bağlantısı e-posta adresinize gönderildi.</small>
                    </div>
                @endif
            @endif
        </div>
    </div>

    <div class="d-flex align-items-center">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-check-circle me-2"></i>Kaydet
        </button>

        @if (session('status') === 'profile-updated')
            <div class="alert alert-success ms-3 mb-0 py-2 px-3">
                <small><i class="bi bi-check-circle me-1"></i>Kaydedildi!</small>
            </div>
        @endif
    </div>
</form>

<form id="send-verification" method="post" action="{{ route('verification.send') }}" style="display: none;">
    @csrf
</form>
