@extends('layouts.app')

@section('title', 'Ürünler')

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="display-5 fw-bold text-primary mb-3">Tüm Ürünler</h1>
            <p class="lead text-muted">En taze çiçekler ve özel buketler</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Filtreler</h6>
                </div>
                <div class="card-body">
                    <form method="GET">
                        <!-- Category Filter -->
                        <div class="mb-3">
                            <label class="form-label">Kategori</label>
                            <select name="category" class="form-select">
                                <option value="">Tüm Kategoriler</option>
                                @foreach($categories as $category)
                                <option value="{{ $category->slug }}" {{ request('category') == $category->slug ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Price Range -->
                        <div class="mb-3">
                            <label class="form-label">Fiyat Aralığı</label>
                            <div class="row">
                                <div class="col-6">
                                    <input type="number" name="min_price" class="form-control" placeholder="Min ₺" value="{{ request('min_price') }}">
                                </div>
                                <div class="col-6">
                                    <input type="number" name="max_price" class="form-control" placeholder="Max ₺" value="{{ request('max_price') }}">
                                </div>
                            </div>
                        </div>

                        <!-- Sort -->
                        <div class="mb-3">
                            <label class="form-label">Sıralama</label>
                            <select name="sort" class="form-select">
                                <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>İsme Göre</option>
                                <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Fiyat (Düşük-Yüksek)</option>
                                <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Fiyat (Yüksek-Düşük)</option>
                                <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>En Yeni</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">Filtrele</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            @if($products->count() > 0)
            <!-- Products Grid -->
            <div class="row g-4">
                @foreach($products as $product)
                <div class="col-lg-4 col-md-6">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="position-relative">
                            <a href="{{ route('products.show', $product->slug) }}" class="text-decoration-none">
                                @if($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}"
                                         alt="{{ $product->name }}"
                                         class="card-img-top"
                                         style="height: 200px; object-fit: cover;">
                                @else
                                    <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, {{ $product->category->color }}20, #E1F5FE); height: 200px;">
                                        <i class="{{ $product->category->icon }} text-primary" style="font-size: 4rem; color: {{ $product->category->color }};"></i>
                                    </div>
                                @endif
                            </a>
                            @if($product->discount_price)
                            <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                                -{{ number_format((($product->price - $product->discount_price) / $product->price) * 100, 0) }}%
                            </span>
                            @endif
                            @if($product->stock_quantity <= 5)
                            <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son {{ $product->stock_quantity }} adet!</span>
                            @endif
                        </div>
                        <div class="card-body">
                            <a href="{{ route('products.show', $product->slug) }}" class="text-decoration-none">
                                <h6 class="card-title fw-bold text-dark">{{ $product->name }}</h6>
                            </a>
                            <p class="card-text text-muted small">{{ $product->description ? Str::limit($product->description, 80) : $product->short_description }}</p>
                            <div class="mb-2">
                                <small class="text-muted">
                                    <i class="bi bi-tag me-1"></i>{{ $product->category->name }}
                                </small>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    @if($product->discount_price)
                                    <span class="text-decoration-line-through text-muted small">₺{{ number_format($product->price, 2) }}</span>
                                    <span class="fw-bold text-primary ms-2">₺{{ number_format($product->discount_price, 2) }}</span>
                                    @else
                                    <span class="fw-bold text-primary">₺{{ number_format($product->price, 2) }}</span>
                                    @endif
                                </div>
                                <div>
                                    <a href="{{ route('products.show', $product->slug) }}" class="btn btn-outline-primary btn-sm me-1">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <form action="{{ route('cart.add', $product->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="btn btn-primary btn-sm" {{ !$product->in_stock ? 'disabled' : '' }}>
                                            <i class="bi bi-bag-plus"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $products->links() }}
            </div>
            @else
            <!-- No Products -->
            <div class="text-center py-5">
                <i class="bi bi-flower1 display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Ürün bulunamadı</h3>
                <p class="text-muted mb-4">Aradığınız kriterlere uygun ürün bulunmuyor. Filtrelerinizi değiştirmeyi deneyin.</p>
                <a href="{{ route('products.index') }}" class="btn btn-primary">
                    <i class="bi bi-arrow-left me-2"></i>Tüm Ürünleri Gör
                </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
