@extends('layouts.app')

@section('title', 'Kredi Kartı Ödemesi')

@section('content')
<div class="container py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Ana Sayfa</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('cart.index') }}">Sepet</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('checkout.index') }}">Sipariş</a></li>
                    <li class="breadcrumb-item active">Kredi Kartı Ödemesi</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-3">
                <i class="bi bi-credit-card-2-front me-2"></i>Güvenli Ödeme
            </h1>
            <p class="text-muted">PayTR güvenli ödeme sistemi ile kredi kartınızla ödeme yapın</p>
        </div>
    </div>

    <div class="row">
        <!-- Payment Form -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="bi bi-shield-check me-2"></i>PayTR Güvenli Ödeme
                    </h5>
                </div>
                <div class="card-body">
                    <!-- PayTR iframe will be loaded here -->
                    <div id="payment-loading" class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Yükleniyor...</span>
                        </div>
                        <p class="mt-3 text-muted">Ödeme sayfası yükleniyor...</p>
                    </div>
                    
                    <iframe id="payment-iframe" 
                            src="{{ $paymentData['iframe_url'] }}" 
                            width="100%" 
                            height="600" 
                            frameborder="0" 
                            style="display: none;"
                            onload="document.getElementById('payment-loading').style.display='none'; this.style.display='block';">
                    </iframe>
                </div>
            </div>

            <!-- Security Info -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <i class="bi bi-shield-lock text-success fs-2"></i>
                            <h6 class="mt-2">SSL Güvenlik</h6>
                            <small class="text-muted">256-bit şifreleme</small>
                        </div>
                        <div class="col-md-3">
                            <i class="bi bi-credit-card text-primary fs-2"></i>
                            <h6 class="mt-2">Tüm Kartlar</h6>
                            <small class="text-muted">Visa, MasterCard, Troy</small>
                        </div>
                        <div class="col-md-3">
                            <i class="bi bi-clock text-warning fs-2"></i>
                            <h6 class="mt-2">Hızlı İşlem</h6>
                            <small class="text-muted">Anında onay</small>
                        </div>
                        <div class="col-md-3">
                            <i class="bi bi-telephone text-info fs-2"></i>
                            <h6 class="mt-2">7/24 Destek</h6>
                            <small class="text-muted">Müşteri hizmetleri</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Summary -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0">
                        <i class="bi bi-receipt me-2"></i>Sipariş Özeti
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Sipariş No:</span>
                        <strong>#{{ $order->order_number }}</strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Teslimat Tarihi:</span>
                        <span>{{ $order->delivery_date->format('d.m.Y') }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Teslimat Adresi:</span>
                        <span class="text-end">{{ $order->delivery_address }}</span>
                    </div>
                    <hr>
                    
                    <!-- Order Items -->
                    <h6 class="mb-3">Sipariş İçeriği</h6>
                    @foreach($order->items as $item)
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <small class="fw-bold">{{ $item->product_name }}</small>
                            <br>
                            <small class="text-muted">{{ $item->quantity }} adet × ₺{{ number_format($item->unit_price, 2) }}</small>
                        </div>
                        <span class="fw-bold">₺{{ number_format($item->total_price, 2) }}</span>
                    </div>
                    @endforeach
                    
                    <hr>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span>₺{{ number_format($order->subtotal, 2) }}</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span>₺{{ number_format($order->shipping_cost, 2) }}</span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <strong>Toplam:</strong>
                        <strong class="text-primary fs-5">₺{{ number_format($order->total_amount, 2) }}</strong>
                    </div>
                </div>
            </div>

            <!-- Payment Status -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body text-center">
                    <div id="payment-status">
                        <div class="spinner-border spinner-border-sm text-primary me-2" role="status"></div>
                        <span class="text-muted">Ödeme durumu kontrol ediliyor...</span>
                    </div>
                </div>
            </div>

            <!-- Help -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body">
                    <h6 class="text-primary">
                        <i class="bi bi-question-circle me-2"></i>Yardıma mı ihtiyacınız var?
                    </h6>
                    <p class="small text-muted mb-2">
                        Ödeme işlemi sırasında sorun yaşıyorsanız bizimle iletişime geçin.
                    </p>
                    <div class="d-grid">
                        <a href="tel:+905551234567" class="btn btn-outline-primary btn-sm">
                            <i class="bi bi-telephone me-2"></i>Bizi Arayın
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    let paymentCheckInterval;
    let checkCount = 0;
    const maxChecks = 60; // 5 dakika (5 saniyede bir kontrol)
    
    // Ödeme durumunu kontrol et
    function checkPaymentStatus() {
        if (checkCount >= maxChecks) {
            clearInterval(paymentCheckInterval);
            document.getElementById('payment-status').innerHTML = 
                '<i class="bi bi-exclamation-triangle text-warning me-2"></i>Ödeme durumu kontrol edilemiyor';
            return;
        }
        
        fetch('{{ route("payment.status") }}?order_id={{ $order->id }}')
            .then(response => response.json())
            .then(data => {
                if (data.payment_status === 'paid') {
                    clearInterval(paymentCheckInterval);
                    document.getElementById('payment-status').innerHTML = 
                        '<i class="bi bi-check-circle text-success me-2"></i>Ödeme başarılı! Yönlendiriliyorsunuz...';
                    
                    setTimeout(() => {
                        window.location.href = '{{ route("checkout.success", $order->order_number) }}';
                    }, 2000);
                } else if (data.payment_status === 'failed') {
                    clearInterval(paymentCheckInterval);
                    document.getElementById('payment-status').innerHTML = 
                        '<i class="bi bi-x-circle text-danger me-2"></i>Ödeme başarısız';
                }
                checkCount++;
            })
            .catch(error => {
                console.error('Payment status check error:', error);
                checkCount++;
            });
    }
    
    // 5 saniyede bir ödeme durumunu kontrol et
    paymentCheckInterval = setInterval(checkPaymentStatus, 5000);
    
    // Sayfa kapatılırken interval'ı temizle
    window.addEventListener('beforeunload', function() {
        if (paymentCheckInterval) {
            clearInterval(paymentCheckInterval);
        }
    });
});
</script>
@endpush
@endsection
