@extends('layouts.app')

@section('title', 'Sipariş Ver')

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Ana Sayfa</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('cart.index') }}">Sepetim</a></li>
                    <li class="breadcrumb-item active">Sipariş Ver</li>
                </ol>
            </nav>
            <h1 class="display-5 fw-bold text-primary mb-3">Sipariş Ver</h1>
        </div>
    </div>

    @if(empty($cart) || count($cart) == 0)
    <!-- Empty Cart -->
    <div class="row">
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-bag-x display-1 text-muted mb-4"></i>
                <h3 class="text-muted mb-3">Sepetiniz Boş</h3>
                <p class="text-muted mb-4">Sipariş verebilmek için sepetinizde ürün bulunmalıdır.</p>
                <a href="{{ route('products.index') }}" class="btn btn-primary btn-lg">
                    <i class="bi bi-flower1 me-2"></i>Alışverişe Başla
                </a>
            </div>
        </div>
    </div>
    @else
    <form action="{{ route('checkout.store') }}" method="POST">
        @csrf
        <div class="row">
            <!-- Checkout Form -->
            <div class="col-lg-8">
                <!-- Delivery Information -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_name" class="form-label">Teslim Alacak Kişi *</label>
                                <input type="text" class="form-control @error('delivery_name') is-invalid @enderror" 
                                       id="delivery_name" name="delivery_name" 
                                       value="{{ old('delivery_name', Auth::user()->name ?? '') }}" required>
                                @error('delivery_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_phone" class="form-label">Telefon Numarası *</label>
                                <input type="tel" class="form-control @error('delivery_phone') is-invalid @enderror" 
                                       id="delivery_phone" name="delivery_phone" 
                                       value="{{ old('delivery_phone', Auth::user()->phone ?? '') }}" required>
                                @error('delivery_phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="delivery_address" class="form-label">Teslimat Adresi *</label>
                            <textarea class="form-control @error('delivery_address') is-invalid @enderror" 
                                      id="delivery_address" name="delivery_address" rows="3" required>{{ old('delivery_address', Auth::user()->address ?? '') }}</textarea>
                            @error('delivery_address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_city" class="form-label">Şehir *</label>
                                <select class="form-select @error('delivery_city') is-invalid @enderror" 
                                        id="delivery_city" name="delivery_city" required>
                                    <option value="">Şehir Seçin</option>
                                    <option value="İstanbul" {{ old('delivery_city', Auth::user()->city ?? '') == 'İstanbul' ? 'selected' : '' }}>İstanbul</option>
                                    <option value="Ankara" {{ old('delivery_city') == 'Ankara' ? 'selected' : '' }}>Ankara</option>
                                    <option value="İzmir" {{ old('delivery_city') == 'İzmir' ? 'selected' : '' }}>İzmir</option>
                                    <option value="Bursa" {{ old('delivery_city') == 'Bursa' ? 'selected' : '' }}>Bursa</option>
                                    <option value="Antalya" {{ old('delivery_city') == 'Antalya' ? 'selected' : '' }}>Antalya</option>
                                </select>
                                @error('delivery_city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_district" class="form-label">İlçe *</label>
                                <input type="text" class="form-control @error('delivery_district') is-invalid @enderror" 
                                       id="delivery_district" name="delivery_district" 
                                       value="{{ old('delivery_district', Auth::user()->district ?? '') }}" required>
                                @error('delivery_district')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="delivery_date" class="form-label">Teslimat Tarihi *</label>
                                <input type="date" class="form-control @error('delivery_date') is-invalid @enderror" 
                                       id="delivery_date" name="delivery_date" 
                                       value="{{ old('delivery_date', date('Y-m-d', strtotime('+1 day'))) }}" 
                                       min="{{ date('Y-m-d', strtotime('+1 day')) }}" required>
                                @error('delivery_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="delivery_time" class="form-label">Teslimat Saati</label>
                                <select class="form-select" id="delivery_time" name="delivery_time">
                                    <option value="">Saat Seçin (İsteğe Bağlı)</option>
                                    <option value="09:00-12:00" {{ old('delivery_time') == '09:00-12:00' ? 'selected' : '' }}>09:00 - 12:00</option>
                                    <option value="12:00-15:00" {{ old('delivery_time') == '12:00-15:00' ? 'selected' : '' }}>12:00 - 15:00</option>
                                    <option value="15:00-18:00" {{ old('delivery_time') == '15:00-18:00' ? 'selected' : '' }}>15:00 - 18:00</option>
                                    <option value="18:00-21:00" {{ old('delivery_time') == '18:00-21:00' ? 'selected' : '' }}>18:00 - 21:00</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="delivery_notes" class="form-label">Teslimat Notları</label>
                            <textarea class="form-control" id="delivery_notes" name="delivery_notes" rows="2" 
                                      placeholder="Özel talimatlar, adres tarifi vb.">{{ old('delivery_notes') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Payment Method -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-credit-card me-2"></i>Ödeme Yöntemi
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="cash" value="cash"
                                           {{ old('payment_method', 'cash') == 'cash' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="cash">
                                        <i class="bi bi-cash me-2"></i>Kapıda Ödeme
                                    </label>
                                </div>
                            </div>
                            @if($paytrEnabled)
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="card" value="card"
                                           {{ old('payment_method') == 'card' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="card">
                                        <i class="bi bi-credit-card me-2"></i>Kredi Kartı
                                        <span class="badge bg-success ms-2">Güvenli</span>
                                    </label>
                                    <small class="text-muted d-block mt-1">PayTR ile güvenli ödeme</small>
                                </div>
                            </div>
                            @endif
                            <div class="col-md-4 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="transfer" value="transfer"
                                           {{ old('payment_method') == 'transfer' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="transfer">
                                        <i class="bi bi-bank me-2"></i>Havale/EFT
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <div class="mb-2">
                                <strong>Kapıda Ödeme:</strong> Siparişiniz teslim edilirken nakit olarak ödeme yapabilirsiniz.
                            </div>
                            @if($paytrEnabled)
                            <div class="mb-2">
                                <strong>Kredi Kartı:</strong> PayTR güvenli ödeme sistemi ile anında ödeme yapabilirsiniz. Tüm kredi kartları kabul edilir.
                            </div>
                            @endif
                            <div>
                                <strong>Havale/EFT:</strong> Banka hesabımıza havale veya EFT ile ödeme yapabilirsiniz.
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Notes -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-chat-text me-2"></i>Sipariş Notları
                        </h5>
                    </div>
                    <div class="card-body">
                        <textarea class="form-control" name="notes" rows="3" 
                                  placeholder="Siparişinizle ilgili özel notlarınız...">{{ old('notes') }}</textarea>
                    </div>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm sticky-top" style="top: 100px;">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Sipariş Özeti</h5>
                    </div>
                    <div class="card-body">
                        @php
                        $subtotal = 0;
                        @endphp
                        
                        <!-- Cart Items -->
                        @foreach($cart as $id => $item)
                        @php
                        $itemTotal = $item['price'] * $item['quantity'];
                        $subtotal += $itemTotal;
                        @endphp
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div class="flex-grow-1">
                                <h6 class="mb-0 small">{{ $item['name'] }}</h6>
                                <small class="text-muted">{{ $item['quantity'] }} x ₺{{ number_format($item['price'], 2) }}</small>
                            </div>
                            <span class="fw-bold">₺{{ number_format($itemTotal, 2) }}</span>
                        </div>
                        @endforeach
                        
                        <hr>
                        
                        <!-- Pricing -->
                        <div class="d-flex justify-content-between mb-2">
                            <span>Ara Toplam:</span>
                            <span>₺{{ number_format($subtotal, 2) }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Kargo:</span>
                            <span class="text-success">
                                @if($subtotal >= 200)
                                    Ücretsiz
                                @else
                                    ₺15.00
                                @endif
                            </span>
                        </div>
                        @if($subtotal < 200)
                        <div class="alert alert-info small">
                            <i class="bi bi-info-circle me-1"></i>
                            ₺{{ number_format(200 - $subtotal, 2) }} daha alışveriş yapın, kargo ücretsiz olsun!
                        </div>
                        @endif
                        <hr>
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Toplam:</strong>
                            <strong class="text-primary fs-5">₺{{ number_format($subtotal >= 200 ? $subtotal : $subtotal + 15, 2) }}</strong>
                        </div>
                        
                        <!-- Submit Button -->
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i>Siparişi Tamamla
                            </button>
                            <a href="{{ route('cart.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Sepete Dön
                            </a>
                        </div>
                        
                        <!-- Security Info -->
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="bi bi-shield-check me-1"></i>
                                Güvenli alışveriş garantisi
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    @endif
</div>
@endsection
