@extends('layouts.app')

@section('title', $category->name)

@section('content')
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <!-- Category Header -->
            <div class="row align-items-center mb-4">
                <div class="col-md-8">
                    <div class="d-flex align-items-center mb-3">
                        <i class="{{ $category->icon }} me-3" style="font-size: 3rem; color: {{ $category->color }};"></i>
                        <div>
                            <h1 class="display-5 fw-bold mb-1" style="color: {{ $category->color }};">{{ $category->name }}</h1>
                            <p class="text-muted mb-0">{{ $products->total() }} ürün bulundu</p>
                        </div>
                    </div>
                    @if($category->description)
                    <p class="lead text-muted">{{ $category->description }}</p>
                    @endif
                </div>
                <div class="col-md-4 text-md-end">
                    <div class="p-4 rounded" style="background: linear-gradient(135deg, {{ $category->color }}20, #FFF);">
                        <i class="{{ $category->icon }}" style="font-size: 5rem; color: {{ $category->color }}; opacity: 0.3;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Filters Sidebar -->
        <div class="col-md-3 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header" style="background-color: {{ $category->color }}; color: white;">
                    <h6 class="mb-0">
                        <i class="bi bi-funnel me-2"></i>Filtreler
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET">
                        <!-- Price Range -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">Fiyat Aralığı</label>
                            <div class="row">
                                <div class="col-6">
                                    <input type="number" name="min_price" class="form-control" 
                                           placeholder="Min ₺" value="{{ request('min_price') }}">
                                </div>
                                <div class="col-6">
                                    <input type="number" name="max_price" class="form-control" 
                                           placeholder="Max ₺" value="{{ request('max_price') }}">
                                </div>
                            </div>
                        </div>

                        <!-- Sort -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">Sıralama</label>
                            <select name="sort" class="form-select">
                                <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>İsme Göre</option>
                                <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Fiyat (Düşük-Yüksek)</option>
                                <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Fiyat (Yüksek-Düşük)</option>
                                <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>En Yeni</option>
                            </select>
                        </div>

                        <button type="submit" class="btn w-100" style="background-color: {{ $category->color }}; color: white;">
                            <i class="bi bi-search me-2"></i>Filtrele
                        </button>
                        
                        @if(request()->hasAny(['min_price', 'max_price', 'sort']))
                        <a href="{{ route('categories.show', $category->slug) }}" class="btn btn-outline-secondary w-100 mt-2">
                            <i class="bi bi-x-circle me-2"></i>Filtreleri Temizle
                        </a>
                        @endif
                    </form>
                </div>
            </div>

            <!-- Category Info -->
            <div class="card border-0 shadow-sm mt-3">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">
                        <i class="bi bi-info-circle me-2" style="color: {{ $category->color }};"></i>
                        Kategori Bilgileri
                    </h6>
                    <ul class="list-unstyled small">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Taze çiçek garantisi
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Aynı gün teslimat
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Özel ambalaj
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            Ücretsiz kargo (200₺+)
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="col-md-9">
            @if($products->count() > 0)
            <div class="row g-4">
                @foreach($products as $product)
                <div class="col-lg-4 col-md-6">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="position-relative">
                            <a href="{{ route('products.show', $product->slug) }}" class="text-decoration-none">
                                @if($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}"
                                         alt="{{ $product->name }}"
                                         class="card-img-top"
                                         style="height: 200px; object-fit: cover;">
                                @else
                                    <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, {{ $category->color }}20, #E1F5FE); height: 200px;">
                                        <i class="{{ $category->icon }}" style="font-size: 4rem; color: {{ $category->color }};"></i>
                                    </div>
                                @endif
                            </a>
                            @if($product->discount_price)
                            <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                                -{{ number_format((($product->price - $product->discount_price) / $product->price) * 100, 0) }}%
                            </span>
                            @endif
                            @if($product->stock_quantity <= 5)
                            <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son {{ $product->stock_quantity }} adet!</span>
                            @endif
                        </div>
                        <div class="card-body">
                            <a href="{{ route('products.show', $product->slug) }}" class="text-decoration-none">
                                <h6 class="card-title fw-bold text-dark">{{ $product->name }}</h6>
                            </a>
                            <p class="card-text text-muted small">{{ $product->description ? Str::limit($product->description, 80) : $product->short_description }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    @if($product->sale_price)
                                    <span class="text-decoration-line-through text-muted small">₺{{ number_format($product->price, 2) }}</span>
                                    <span class="fw-bold ms-2" style="color: {{ $category->color }};">₺{{ number_format($product->sale_price, 2) }}</span>
                                    @else
                                    <span class="fw-bold" style="color: {{ $category->color }};">₺{{ number_format($product->price, 2) }}</span>
                                    @endif
                                </div>
                                <div>
                                    <a href="{{ route('products.show', $product->slug) }}" class="btn btn-outline-primary btn-sm me-1">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <form action="{{ route('cart.add', $product->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="btn btn-sm" 
                                                style="background-color: {{ $category->color }}; color: white;"
                                                {{ !$product->in_stock ? 'disabled' : '' }}>
                                            <i class="bi bi-bag-plus"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                {{ $products->links() }}
            </div>
            @else
            <!-- No Products -->
            <div class="text-center py-5">
                <i class="{{ $category->icon }} display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Bu kategoride ürün bulunamadı</h3>
                <p class="text-muted mb-4">Aradığınız kriterlere uygun ürün bulunmuyor. Filtrelerinizi değiştirmeyi deneyin.</p>
                <a href="{{ route('categories.show', $category->slug) }}" class="btn btn-primary">
                    <i class="bi bi-arrow-left me-2"></i>Filtreleri Temizle
                </a>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
