@extends('layouts.app')

@section('title', 'Story Düzenle')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.stories.index') }}">Story Yönetimi</a></li>
                    <li class="breadcrumb-item active">{{ $story->title }} - Düzenle</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-2">
                <i class="bi bi-pencil me-2"></i>Story Düzenle
            </h1>
            <p class="text-muted mb-0">{{ $story->title }} story'sini düzenleyin</p>
        </div>
    </div>

    <form action="{{ route('admin.stories.update', $story->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
            <!-- Main Story Info -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Temel Bilgiler
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Story Başlığı *</label>
                            <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                   id="title" name="title" value="{{ old('title', $story->title) }}" required>
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="3">{{ old('description', $story->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="type" class="form-label">Story Tipi *</label>
                                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                                    <option value="">Tip Seçin</option>
                                    <option value="product" {{ old('type', $story->type) === 'product' ? 'selected' : '' }}>Ürün</option>
                                    <option value="category" {{ old('type', $story->type) === 'category' ? 'selected' : '' }}>Kategori</option>
                                    <option value="custom" {{ old('type', $story->type) === 'custom' ? 'selected' : '' }}>Özel</option>
                                    <option value="link" {{ old('type', $story->type) === 'link' ? 'selected' : '' }}>Link</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="sort_order" class="form-label">Sıralama</label>
                                <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" name="sort_order" value="{{ old('sort_order', $story->sort_order) }}" min="0">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Type Specific Fields -->
                <div class="card border-0 shadow-sm mb-4" id="type-fields">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-link-45deg me-2"></i>Bağlantı Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Product Selection -->
                        <div id="product-field" style="display: none;">
                            <div class="mb-3">
                                <label for="product_id" class="form-label">Ürün Seçin *</label>
                                <select class="form-select @error('product_id') is-invalid @enderror" id="product_id" name="product_id">
                                    <option value="">Ürün Seçin</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}" {{ old('product_id', $story->product_id) == $product->id ? 'selected' : '' }}>
                                            {{ $product->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('product_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Category Selection -->
                        <div id="category-field" style="display: none;">
                            <div class="mb-3">
                                <label for="category_id" class="form-label">Kategori Seçin *</label>
                                <select class="form-select @error('category_id') is-invalid @enderror" id="category_id" name="category_id">
                                    <option value="">Kategori Seçin</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $story->category_id) == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Custom Link -->
                        <div id="link-field" style="display: none;">
                            <div class="mb-3">
                                <label for="custom_link" class="form-label">Özel Link *</label>
                                <input type="url" class="form-control @error('custom_link') is-invalid @enderror" 
                                       id="custom_link" name="custom_link" value="{{ old('custom_link', $story->custom_link) }}" 
                                       placeholder="https://example.com">
                                @error('custom_link')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Story Image -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-image me-2"></i>Story Resmi
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Current Image -->
                        @if($story->image)
                        <div class="mb-3">
                            <label class="form-label">Mevcut Resim</label>
                            <div class="text-center">
                                <img src="{{ asset('storage/' . $story->image) }}" 
                                     alt="{{ $story->title }}" 
                                     class="img-thumbnail" 
                                     style="max-width: 200px; max-height: 300px;">
                            </div>
                        </div>
                        @endif
                        
                        <div class="mb-3">
                            <label for="image" class="form-label">
                                {{ $story->image ? 'Yeni Resim Yükle (İsteğe Bağlı)' : 'Story Resmi *' }}
                            </label>
                            <input type="file" class="form-control @error('image') is-invalid @enderror" 
                                   id="image" name="image" accept="image/*" {{ !$story->image ? 'required' : '' }}>
                            @error('image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">
                                JPG, PNG veya WebP formatında, maksimum 2MB. Önerilen boyut: 400x600px (9:16 oran)
                                @if($story->image)
                                    <br><strong>Not:</strong> Yeni resim yüklerseniz mevcut resim silinecektir.
                                @endif
                            </div>
                        </div>
                        
                        <!-- New Image Preview -->
                        <div id="image_preview" class="text-center" style="display: none;">
                            <label class="form-label">Yeni Resim Önizlemesi</label>
                            <br>
                            <img id="preview_img" src="" alt="Önizleme" class="img-thumbnail" style="max-width: 200px; max-height: 300px;">
                            <br>
                            <button type="button" class="btn btn-outline-danger btn-sm mt-2" id="remove_image">
                                <i class="bi bi-trash me-1"></i>Yeni Resmi Kaldır
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Design Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-palette me-2"></i>Tasarım Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="background_color" class="form-label">Arkaplan Rengi</label>
                                <input type="color" class="form-control form-control-color @error('background_color') is-invalid @enderror" 
                                       id="background_color" name="background_color" value="{{ old('background_color', $story->background_color) }}">
                                @error('background_color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="text_color" class="form-label">Metin Rengi</label>
                                <input type="color" class="form-control form-control-color @error('text_color') is-invalid @enderror" 
                                       id="text_color" name="text_color" value="{{ old('text_color', $story->text_color) }}">
                                @error('text_color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Expiry Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-clock me-2"></i>Süre Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="expires_at" class="form-label">Son Geçerlilik Tarihi</label>
                            <input type="datetime-local" class="form-control @error('expires_at') is-invalid @enderror" 
                                   id="expires_at" name="expires_at" 
                                   value="{{ old('expires_at', $story->expires_at ? $story->expires_at->format('Y-m-d\TH:i') : '') }}">
                            @error('expires_at')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">Boş bırakırsanız story süresiz olur</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Preview -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-eye me-2"></i>Story Önizleme
                        </h5>
                    </div>
                    <div class="card-body">
                        <div id="story_preview" class="position-relative rounded overflow-hidden mx-auto" 
                             style="width: 200px; height: 300px; background: linear-gradient(135deg, {{ $story->background_color }} 0%, {{ $story->background_color }}dd 100%);">
                            
                            <div id="preview_image_container" class="position-absolute w-100 h-100">
                                <img id="preview_story_img" 
                                     src="{{ $story->image ? asset('storage/' . $story->image) : '' }}" 
                                     alt="Story Resmi" 
                                     class="w-100 h-100" 
                                     style="object-fit: cover; {{ !$story->image ? 'display: none;' : '' }}">
                            </div>
                            
                            <div class="position-absolute w-100 h-100 d-flex flex-column justify-content-center align-items-center text-center p-3"
                                 id="story_overlay" style="background: linear-gradient(135deg, {{ $story->background_color }}66, {{ $story->background_color }}99);">
                                <h6 id="preview_title" class="fw-bold mb-2" style="color: {{ $story->text_color }};">{{ $story->title }}</h6>
                                <p id="preview_description" class="small mb-0" style="color: {{ $story->text_color }};">{{ $story->description ?: 'Story açıklaması burada görünecek' }}</p>
                            </div>
                        </div>
                        <small class="text-muted d-block mt-2 text-center">Bu story ana sayfada böyle görünecek</small>
                    </div>
                </div>

                <!-- Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-gear me-2"></i>Ayarlar
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" 
                                   {{ old('is_active', $story->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Story Aktif
                            </label>
                            <div class="form-text">Pasif story'ler ana sayfada gösterilmez</div>
                        </div>
                    </div>
                </div>

                <!-- Story Info -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Story Bilgileri
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6">
                                <div class="border-end">
                                    <h6 class="text-primary mb-1">{{ $story->sort_order }}</h6>
                                    <small class="text-muted">Sıra</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <h6 class="text-{{ $story->status_badge }} mb-1">
                                    <i class="bi bi-{{ $story->is_active ? 'check-circle' : 'x-circle' }}"></i>
                                </h6>
                                <small class="text-muted">{{ $story->status_text }}</small>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center">
                            <small class="text-muted">
                                <strong>Oluşturulma:</strong> {{ $story->created_at->format('d.m.Y H:i') }}<br>
                                <strong>Son Güncelleme:</strong> {{ $story->updated_at->format('d.m.Y H:i') }}
                                @if($story->expires_at)
                                    <br><strong>Bitiş:</strong> {{ $story->expires_at->format('d.m.Y H:i') }}
                                @endif
                            </small>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i>Değişiklikleri Kaydet
                            </button>
                            <a href="{{ route('admin.stories.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Geri Dön
                            </a>
                            @if($story->link !== '#')
                            <a href="{{ $story->link }}" target="_blank" class="btn btn-outline-info">
                                <i class="bi bi-box-arrow-up-right me-2"></i>Story Linkini Aç
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const typeFields = document.getElementById('type-fields');
    const productField = document.getElementById('product-field');
    const categoryField = document.getElementById('category-field');
    const linkField = document.getElementById('link-field');
    
    const titleInput = document.getElementById('title');
    const descriptionInput = document.getElementById('description');
    const backgroundColorInput = document.getElementById('background_color');
    const textColorInput = document.getElementById('text_color');
    
    const previewTitle = document.getElementById('preview_title');
    const previewDescription = document.getElementById('preview_description');
    const storyPreview = document.getElementById('story_preview');
    const storyOverlay = document.getElementById('story_overlay');

    // Type change handler
    typeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        
        // Hide all fields first
        productField.style.display = 'none';
        categoryField.style.display = 'none';
        linkField.style.display = 'none';
        
        if (selectedType) {
            switch(selectedType) {
                case 'product':
                    productField.style.display = 'block';
                    break;
                case 'category':
                    categoryField.style.display = 'block';
                    break;
                case 'custom':
                case 'link':
                    linkField.style.display = 'block';
                    break;
            }
        }
    });

    // Preview update function
    function updatePreview() {
        const title = titleInput.value || 'Story Başlığı';
        const description = descriptionInput.value || 'Story açıklaması burada görünecek';
        const backgroundColor = backgroundColorInput.value;
        const textColor = textColorInput.value;

        previewTitle.textContent = title;
        previewDescription.textContent = description;
        previewTitle.style.color = textColor;
        previewDescription.style.color = textColor;
        
        storyPreview.style.background = `linear-gradient(135deg, ${backgroundColor} 0%, ${backgroundColor}dd 100%)`;
        storyOverlay.style.background = `linear-gradient(135deg, ${backgroundColor}66, ${backgroundColor}99)`;
    }

    // Event listeners
    titleInput.addEventListener('input', updatePreview);
    descriptionInput.addEventListener('input', updatePreview);
    backgroundColorInput.addEventListener('change', updatePreview);
    textColorInput.addEventListener('change', updatePreview);

    // Image preview
    const imageInput = document.getElementById('image');
    const imagePreview = document.getElementById('image_preview');
    const previewImg = document.getElementById('preview_img');
    const removeImageBtn = document.getElementById('remove_image');
    const previewStoryImg = document.getElementById('preview_story_img');

    imageInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            // File size check (2MB)
            if (file.size > 2 * 1024 * 1024) {
                alert('Dosya boyutu 2MB\'dan büyük olamaz!');
                this.value = '';
                return;
            }

            // File type check
            if (!file.type.startsWith('image/')) {
                alert('Lütfen geçerli bir resim dosyası seçin!');
                this.value = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
                
                // Update story preview
                previewStoryImg.src = e.target.result;
                previewStoryImg.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
            // Reset to original image if exists
            @if($story->image)
            previewStoryImg.src = "{{ asset('storage/' . $story->image) }}";
            previewStoryImg.style.display = 'block';
            @else
            previewStoryImg.style.display = 'none';
            @endif
        }
    });

    removeImageBtn.addEventListener('click', function() {
        imageInput.value = '';
        imagePreview.style.display = 'none';
        // Reset to original image if exists
        @if($story->image)
        previewStoryImg.src = "{{ asset('storage/' . $story->image) }}";
        previewStoryImg.style.display = 'block';
        @else
        previewStoryImg.style.display = 'none';
        @endif
    });

    // Initialize
    typeSelect.dispatchEvent(new Event('change'));
});
</script>
@endpush
@endsection
