@extends('layouts.app')

@section('title', 'Site Yönetimi')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">Site Yönetimi</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-2">
                <i class="bi bi-gear me-2"></i>Site Yönetimi
            </h1>
            <p class="text-muted mb-0">Site ayarlarını, meta tagları ve işletme bilgilerini yönetin</p>
        </div>
    </div>

    <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <div class="row">
            <!-- Settings Tabs -->
            <div class="col-lg-3">
                <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-list me-2"></i>Ayar Kategorileri
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="nav nav-pills flex-column" id="settings-tabs" role="tablist">
                            @foreach($settingGroups as $group => $title)
                            <button class="nav-link text-start {{ $loop->first ? 'active' : '' }}" 
                                    id="{{ $group }}-tab" 
                                    data-bs-toggle="pill" 
                                    data-bs-target="#{{ $group }}" 
                                    type="button" 
                                    role="tab">
                                <i class="bi bi-{{ $group === 'general' ? 'gear' : ($group === 'seo' ? 'search' : ($group === 'business' ? 'building' : ($group === 'social' ? 'share' : ($group === 'footer' ? 'layout-text-window-reverse' : ($group === 'pages' ? 'file-text' : 'cart'))))) }} me-2"></i>
                                {{ $title }}
                                <span class="badge bg-secondary ms-auto">{{ $settings[$group]['settings']->count() }}</span>
                            </button>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Content -->
            <div class="col-lg-9">
                <div class="tab-content" id="settings-content">
                    @foreach($settings as $group => $groupData)
                    <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" 
                         id="{{ $group }}" 
                         role="tabpanel">
                        
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white">
                                <h5 class="mb-0">
                                    <i class="bi bi-{{ $group === 'general' ? 'gear' : ($group === 'seo' ? 'search' : ($group === 'business' ? 'building' : ($group === 'social' ? 'share' : ($group === 'footer' ? 'layout-text-window-reverse' : ($group === 'pages' ? 'file-text' : 'cart'))))) }} me-2"></i>
                                    {{ $groupData['title'] }}
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    @foreach($groupData['settings'] as $setting)
                                    <div class="col-md-{{ in_array($setting->type, ['textarea', 'image']) ? '12' : '6' }} mb-4">
                                        <label for="setting_{{ $setting->key }}" class="form-label">
                                            {{ $setting->label }}
                                            @if(in_array($setting->key, ['site_name', 'meta_title', 'meta_description', 'business_name']))
                                                <span class="text-danger">*</span>
                                            @endif
                                        </label>
                                        
                                        @if($setting->type === 'text')
                                            <input type="text" 
                                                   class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                   id="setting_{{ $setting->key }}" 
                                                   name="settings[{{ $setting->key }}]" 
                                                   value="{{ old('settings.'.$setting->key, $setting->value) }}">
                                        
                                        @elseif($setting->type === 'textarea')
                                            <textarea class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                      id="setting_{{ $setting->key }}" 
                                                      name="settings[{{ $setting->key }}]" 
                                                      rows="{{ $setting->key === 'meta_description' ? '3' : (str_contains($setting->key, 'about_story_content') ? '8' : '4') }}">{{ old('settings.'.$setting->key, $setting->value) }}</textarea>
                                        
                                        @elseif($setting->type === 'email')
                                            <input type="email" 
                                                   class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                   id="setting_{{ $setting->key }}" 
                                                   name="settings[{{ $setting->key }}]" 
                                                   value="{{ old('settings.'.$setting->key, $setting->value) }}">
                                        
                                        @elseif($setting->type === 'url')
                                            <input type="url" 
                                                   class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                   id="setting_{{ $setting->key }}" 
                                                   name="settings[{{ $setting->key }}]" 
                                                   value="{{ old('settings.'.$setting->key, $setting->value) }}" 
                                                   placeholder="https://example.com">
                                        
                                        @elseif($setting->type === 'number')
                                            <input type="number" 
                                                   class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                   id="setting_{{ $setting->key }}" 
                                                   name="settings[{{ $setting->key }}]" 
                                                   value="{{ old('settings.'.$setting->key, $setting->value) }}" 
                                                   min="0" step="0.01">
                                        
                                        @elseif($setting->type === 'boolean')
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       id="setting_{{ $setting->key }}" 
                                                       name="settings[{{ $setting->key }}]" 
                                                       value="1" 
                                                       {{ old('settings.'.$setting->key, $setting->value) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="setting_{{ $setting->key }}">
                                                    Aktif
                                                </label>
                                            </div>
                                        
                                        @elseif($setting->type === 'image')
                                            @if($setting->value)
                                            <div class="mb-2">
                                                <img src="{{ asset('storage/' . $setting->value) }}" 
                                                     alt="{{ $setting->label }}" 
                                                     class="img-thumbnail" 
                                                     style="max-width: 200px; max-height: 100px;">
                                            </div>
                                            @endif
                                            <input type="file" 
                                                   class="form-control @error('settings.'.$setting->key) is-invalid @enderror" 
                                                   id="setting_{{ $setting->key }}" 
                                                   name="settings[{{ $setting->key }}]" 
                                                   accept="image/*">
                                        @endif
                                        
                                        @if($setting->description)
                                        <div class="form-text">{{ $setting->description }}</div>
                                        @endif
                                        
                                        @error('settings.'.$setting->key)
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>

                <!-- Save Button -->
                <div class="card border-0 shadow-sm mt-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Değişiklikleri Kaydet</h6>
                                <small class="text-muted">Tüm ayarlar otomatik olarak kaydedilecektir</small>
                            </div>
                            <div>
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-check-circle me-2"></i>Ayarları Kaydet
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Character counter for meta description
    const metaDescInput = document.getElementById('setting_meta_description');
    if (metaDescInput) {
        const counter = document.createElement('div');
        counter.className = 'form-text text-end';
        counter.style.marginTop = '5px';
        metaDescInput.parentNode.appendChild(counter);
        
        function updateCounter() {
            const length = metaDescInput.value.length;
            counter.innerHTML = `<span class="${length > 160 ? 'text-danger' : 'text-muted'}">${length}/160 karakter</span>`;
        }
        
        metaDescInput.addEventListener('input', updateCounter);
        updateCounter();
    }
    
    // Image preview
    document.querySelectorAll('input[type="file"]').forEach(input => {
        input.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                // File size check (2MB)
                if (file.size > 2 * 1024 * 1024) {
                    alert('Dosya boyutu 2MB\'dan büyük olamaz!');
                    this.value = '';
                    return;
                }
                
                // File type check
                if (!file.type.startsWith('image/')) {
                    alert('Lütfen geçerli bir resim dosyası seçin!');
                    this.value = '';
                    return;
                }
            }
        });
    });
    
    // Auto-save warning
    let hasChanges = false;
    document.querySelectorAll('input, textarea, select').forEach(element => {
        element.addEventListener('change', function() {
            hasChanges = true;
        });
    });
    
    window.addEventListener('beforeunload', function(e) {
        if (hasChanges) {
            e.preventDefault();
            e.returnValue = 'Kaydedilmemiş değişiklikleriniz var. Sayfadan ayrılmak istediğinizden emin misiniz?';
        }
    });
    
    // Reset hasChanges on form submit
    document.querySelector('form').addEventListener('submit', function() {
        hasChanges = false;
    });
});
</script>
@endpush
@endsection
