<?php
// Geçici bakım betiği: migrate/seed
$secret = getenv('APP_KEY') ?: '';
if (!isset($_GET['key']) || !$secret || $_GET['key'] !== $secret) {
    http_response_code(403);
    echo "Forbidden";
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: text/plain; charset=UTF-8');

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

use Illuminate\Support\Facades\Artisan;

$cmds = [
    ['migrate', ['--force' => true]],
    // ['db:seed', ['--force' => true]], // ihtiyaç varsa açın
];

foreach ($cmds as [$name, $opts]) {
    $code = Artisan::call($name, $opts);
    echo $name . " => exit: " . $code . "\n";
    echo Artisan::output() . "\n";
}

echo "Done\n";
