<?php
// Geçici bakım betiği: cache temizleme
// Güvenlik: url'e ?key=SECRET ekleyin. SECRET'i .env'den aliyoruz.
$secret = getenv('APP_KEY') ?: '';
if (!isset($_GET['key']) || !$secret || $_GET['key'] !== $secret) {
    http_response_code(403);
    echo "Forbidden";
    exit;
}

error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: text/plain; charset=UTF-8');

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

use Illuminate\Support\Facades\Artisan;

$commands = [
    ['config:clear'],
    ['cache:clear'],
    ['route:clear'],
    ['view:clear'],
    ['config:cache'],
    ['route:cache'],
    ['view:cache'],
];

foreach ($commands as $cmd) {
    $code = Artisan::call($cmd[0]);
    echo $cmd[0] . " => exit: " . $code . "\n";
    echo Artisan::output() . "\n";
}

echo "Done\n";
