# Docker ile Web Hosting Deployment Rehberi

## Hazırlanan Dosyalar

Bu proje artık Docker ile web hosting'e deploy edilmeye hazır. Aşağıdaki dosyalar oluşturuldu:

- `Dockerfile` - PHP 8.2 ortamı için container konfigürasyonu
- `docker-compose.yml` - Local development için
- `docker-compose.prod.yml` - Production ortamı için
- `docker/nginx/default.conf` - Nginx web server konfigürasyonu
- `.dockerignore` - Docker build sürecinde hariç tutulacak dosyalar
- `.env.production` - Production ortamı için environment değişkenleri

## Web Hosting'e Deploy Etmek İçin Adımlar

### 1. Dosyaları Sunucuya Yükleyin
Tüm proje dosyalarını web hosting sunucunuza yükleyin.

### 2. Environment Dosyasını Yapılandırın
`.env.production` dosyasını `.env` olarak kopyalayın ve aşağıdaki değerleri güncelleyin:

```bash
cp .env.production .env
```

Düzenlenmesi gereken değerler:
- `APP_URL` - Gerçek domain adresiniz
- `DB_PASSWORD` - Güçlü veritabanı şifresi
- `DB_ROOT_PASSWORD` - MySQL root şifresi
- `MAIL_*` - Email ayarları (isteğe bağlı)

### 3. Docker Container'larını Başlatın

Production ortamında çalıştırmak için:

```bash
docker-compose -f docker-compose.prod.yml up -d --build
```

### 4. Veritabanı Migration'larını Çalıştırın

```bash
docker-compose -f docker-compose.prod.yml exec app php artisan migrate --force
```

### 5. Storage Klasöründe Symbolic Link Oluşturun

```bash
docker-compose -f docker-compose.prod.yml exec app php artisan storage:link
```

### 6. Cache'leri Temizleyin ve Optimize Edin

```bash
docker-compose -f docker-compose.prod.yml exec app php artisan config:cache
docker-compose -f docker-compose.prod.yml exec app php artisan route:cache
docker-compose -f docker-compose.prod.yml exec app php artisan view:cache
```

## SSL Sertifikası (Önerilen)

Production ortamında HTTPS kullanmak için SSL sertifikası kurmanız önerilir. Let's Encrypt ile ücretsiz SSL alabilirsiniz.

## Backup

Veritabanı backup'ı almak için:

```bash
docker-compose -f docker-compose.prod.yml exec db mysqldump -u laravel_user -p cicek_bahcesi > backup.sql
```

## Container'ları Durdurma

```bash
docker-compose -f docker-compose.prod.yml down
```

## Local Development

Local'de development yapmak için:

```bash
docker-compose up -d
```

Site http://localhost:8080 adresinden erişilebilir olacak.

## Notlar

- Proje PHP 8.2 ile çalışacak şekilde yapılandırıldı
- MySQL 8.0 veritabanı kullanılıyor
- Nginx web server ile gelen istekler işleniyor
- Tüm dosyalar Docker container'ları içinde izole çalışıyor
- Storage ve public/storage klasörleri volume olarak bağlandı
