<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Genel Ayarlar
            [
                'key' => 'site_name',
                'value' => 'Çiçek Bahçesi',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Adı',
                'description' => 'Web sitenizin adı',
                'sort_order' => 1
            ],
            [
                'key' => 'site_tagline',
                'value' => 'En Taze Çiçekler, En Güzel Anlar',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Sloganı',
                'description' => 'Site başlığının altında görünecek slogan',
                'sort_order' => 2
            ],
            [
                'key' => 'site_logo',
                'value' => '',
                'type' => 'image',
                'group' => 'general',
                'label' => 'Site Logosu',
                'description' => 'Site logosu (PNG, JPG formatında)',
                'sort_order' => 3
            ],
            [
                'key' => 'site_favicon',
                'value' => '',
                'type' => 'image',
                'group' => 'general',
                'label' => 'Site Favicon',
                'description' => 'Tarayıcı sekmesinde görünecek küçük ikon',
                'sort_order' => 4
            ],

            // SEO Ayarları
            [
                'key' => 'meta_title',
                'value' => 'Çiçek Bahçesi - En Taze Çiçekler Online',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Meta Başlık',
                'description' => 'Arama motorlarında görünecek sayfa başlığı',
                'sort_order' => 1
            ],
            [
                'key' => 'meta_description',
                'value' => 'Türkiye\'nin en kaliteli çiçek satış sitesi. Taze çiçekler, özel aranjmanlar ve hızlı teslimat. Sevdiklerinizi mutlu etmenin en güzel yolu.',
                'type' => 'textarea',
                'group' => 'seo',
                'label' => 'Meta Açıklama',
                'description' => 'Arama motorlarında görünecek sayfa açıklaması (160 karakter)',
                'sort_order' => 2
            ],
            [
                'key' => 'meta_keywords',
                'value' => 'çiçek, çiçekçi, online çiçek, çiçek siparişi, çiçek gönder, taze çiçek, çiçek aranjmanı',
                'type' => 'textarea',
                'group' => 'seo',
                'label' => 'Meta Anahtar Kelimeler',
                'description' => 'Virgülle ayrılmış anahtar kelimeler',
                'sort_order' => 3
            ],
            [
                'key' => 'google_analytics',
                'value' => '',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Google Analytics ID',
                'description' => 'Google Analytics takip kodu (GA-XXXXXXXXX)',
                'sort_order' => 4
            ],
            [
                'key' => 'google_search_console',
                'value' => '',
                'type' => 'text',
                'group' => 'seo',
                'label' => 'Google Search Console',
                'description' => 'Google Search Console doğrulama kodu',
                'sort_order' => 5
            ],

            // İşletme Bilgileri
            [
                'key' => 'business_name',
                'value' => 'Çiçek Bahçesi Çiçekçilik',
                'type' => 'text',
                'group' => 'business',
                'label' => 'İşletme Adı',
                'description' => 'Resmi işletme adınız',
                'sort_order' => 1
            ],
            [
                'key' => 'business_address',
                'value' => 'Atatürk Caddesi No:123, Çankaya/Ankara',
                'type' => 'textarea',
                'group' => 'business',
                'label' => 'İşletme Adresi',
                'description' => 'Tam işletme adresiniz',
                'sort_order' => 2
            ],
            [
                'key' => 'business_phone',
                'value' => '+90 312 123 45 67',
                'type' => 'text',
                'group' => 'business',
                'label' => 'Telefon Numarası',
                'description' => 'Ana iletişim telefon numarası',
                'sort_order' => 3
            ],
            [
                'key' => 'business_mobile',
                'value' => '+90 555 123 45 67',
                'type' => 'text',
                'group' => 'business',
                'label' => 'Mobil Telefon',
                'description' => 'Mobil telefon numarası',
                'sort_order' => 4
            ],
            [
                'key' => 'business_email',
                'value' => 'info@cicekbahcesi.com',
                'type' => 'email',
                'group' => 'business',
                'label' => 'E-posta Adresi',
                'description' => 'İletişim e-posta adresi',
                'sort_order' => 5
            ],
            [
                'key' => 'business_website',
                'value' => 'https://www.cicekbahcesi.com',
                'type' => 'url',
                'group' => 'business',
                'label' => 'Web Sitesi',
                'description' => 'İşletme web sitesi URL\'si',
                'sort_order' => 6
            ],
            [
                'key' => 'business_latitude',
                'value' => '39.9334',
                'type' => 'text',
                'group' => 'business',
                'label' => 'Enlem (Latitude)',
                'description' => 'Harita konumu için enlem değeri',
                'sort_order' => 7
            ],
            [
                'key' => 'business_longitude',
                'value' => '32.8597',
                'type' => 'text',
                'group' => 'business',
                'label' => 'Boylam (Longitude)',
                'description' => 'Harita konumu için boylam değeri',
                'sort_order' => 8
            ],
            [
                'key' => 'business_hours',
                'value' => 'Pazartesi-Cumartesi: 09:00-19:00\nPazar: 10:00-17:00',
                'type' => 'textarea',
                'group' => 'business',
                'label' => 'Çalışma Saatleri',
                'description' => 'İşletme çalışma saatleri',
                'sort_order' => 9
            ],

            // Sosyal Medya
            [
                'key' => 'social_facebook',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Facebook',
                'description' => 'Facebook sayfa URL\'si',
                'sort_order' => 1
            ],
            [
                'key' => 'social_instagram',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Instagram',
                'description' => 'Instagram profil URL\'si',
                'sort_order' => 2
            ],
            [
                'key' => 'social_twitter',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'label' => 'Twitter',
                'description' => 'Twitter profil URL\'si',
                'sort_order' => 3
            ],
            [
                'key' => 'social_youtube',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'label' => 'YouTube',
                'description' => 'YouTube kanal URL\'si',
                'sort_order' => 4
            ],
            [
                'key' => 'social_linkedin',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'label' => 'LinkedIn',
                'description' => 'LinkedIn profil URL\'si',
                'sort_order' => 5
            ],

            // E-ticaret Ayarları
            [
                'key' => 'currency',
                'value' => 'TL',
                'type' => 'text',
                'group' => 'ecommerce',
                'label' => 'Para Birimi',
                'description' => 'Site para birimi',
                'sort_order' => 1
            ],
            [
                'key' => 'tax_rate',
                'value' => '20',
                'type' => 'number',
                'group' => 'ecommerce',
                'label' => 'KDV Oranı (%)',
                'description' => 'Varsayılan KDV oranı',
                'sort_order' => 2
            ],
            [
                'key' => 'free_shipping_limit',
                'value' => '500',
                'type' => 'number',
                'group' => 'ecommerce',
                'label' => 'Ücretsiz Kargo Limiti',
                'description' => 'Bu tutarın üzerinde ücretsiz kargo',
                'sort_order' => 3
            ],
            [
                'key' => 'shipping_cost',
                'value' => '25',
                'type' => 'number',
                'group' => 'ecommerce',
                'label' => 'Kargo Ücreti',
                'description' => 'Standart kargo ücreti',
                'sort_order' => 4
            ],

            // Footer Ayarları
            [
                'key' => 'footer_about_title',
                'value' => 'Hakkımızda',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Hakkımızda Başlığı',
                'description' => 'Footer\'da görünecek hakkımızda başlığı',
                'sort_order' => 1
            ],
            [
                'key' => 'footer_about_text',
                'value' => 'Türkiye\'nin en güvenilir çiçek satış platformu. Taze çiçekler, hızlı teslimat.',
                'type' => 'textarea',
                'group' => 'footer',
                'label' => 'Hakkımızda Metni',
                'description' => 'Footer\'da görünecek hakkımızda açıklaması',
                'sort_order' => 2
            ],
            [
                'key' => 'footer_contact_title',
                'value' => 'İletişim',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'İletişim Başlığı',
                'description' => 'Footer\'da görünecek iletişim başlığı',
                'sort_order' => 3
            ],
            [
                'key' => 'footer_contact_address',
                'value' => 'İstanbul, Türkiye',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'İletişim Adresi',
                'description' => 'Footer\'da görünecek adres',
                'sort_order' => 4
            ],
            [
                'key' => 'footer_contact_phone',
                'value' => '+90 (212) 123 45 67',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'İletişim Telefonu',
                'description' => 'Footer\'da görünecek telefon numarası',
                'sort_order' => 5
            ],
            [
                'key' => 'footer_contact_email',
                'value' => 'info@cicekbahcesi.com',
                'type' => 'email',
                'group' => 'footer',
                'label' => 'İletişim E-postası',
                'description' => 'Footer\'da görünecek e-posta adresi',
                'sort_order' => 6
            ],
            [
                'key' => 'footer_links_title',
                'value' => 'Hızlı Linkler',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Linkler Başlığı',
                'description' => 'Footer\'da görünecek linkler başlığı',
                'sort_order' => 7
            ],
            [
                'key' => 'footer_link_about',
                'value' => 'Hakkımızda',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Hakkımızda Link Metni',
                'description' => 'Hakkımızda linkinin görünecek metni',
                'sort_order' => 8
            ],
            [
                'key' => 'footer_link_contact',
                'value' => 'İletişim',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'İletişim Link Metni',
                'description' => 'İletişim linkinin görünecek metni',
                'sort_order' => 9
            ],
            [
                'key' => 'footer_link_delivery',
                'value' => 'Teslimat',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Teslimat Link Metni',
                'description' => 'Teslimat linkinin görünecek metni',
                'sort_order' => 10
            ],
            [
                'key' => 'footer_link_return',
                'value' => 'İade',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'İade Link Metni',
                'description' => 'İade linkinin görünecek metni',
                'sort_order' => 11
            ],
            [
                'key' => 'footer_copyright',
                'value' => '&copy; 2024 Çiçek Bahçesi. Tüm hakları saklıdır.',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Telif Hakkı Metni',
                'description' => 'Footer\'da görünecek telif hakkı metni',
                'sort_order' => 12
            ],
            [
                'key' => 'footer_powered_by',
                'value' => 'Bilgin Yazılım',
                'type' => 'text',
                'group' => 'footer',
                'label' => 'Yapımcı Metni',
                'description' => 'Footer\'da görünecek yapımcı metni',
                'sort_order' => 13
            ],

            // Sayfa Ayarları
            [
                'key' => 'about_page_enabled',
                'value' => '1',
                'type' => 'boolean',
                'group' => 'pages',
                'label' => 'Hakkımızda Sayfası Aktif',
                'description' => 'Hakkımızda sayfasını aktif/pasif yapın',
                'sort_order' => 1
            ],
            [
                'key' => 'about_page_title',
                'value' => 'Hakkımızda',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Hakkımızda Sayfa Başlığı',
                'description' => 'Hakkımızda sayfasının başlığı',
                'sort_order' => 2
            ],
            [
                'key' => 'about_page_subtitle',
                'value' => 'Çiçek Bahçesi olarak hikayemizi keşfedin',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Hakkımızda Alt Başlık',
                'description' => 'Hakkımızda sayfasının alt başlığı',
                'sort_order' => 3
            ],
            [
                'key' => 'about_story_title',
                'value' => 'Hikayemiz',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Hikaye Bölümü Başlığı',
                'description' => 'Hikaye bölümünün başlığı',
                'sort_order' => 4
            ],
            [
                'key' => 'about_story_content',
                'value' => 'Çiçek Bahçesi, 2024 yılında çiçek severlerin ihtiyaçlarını karşılamak amacıyla kurulmuştur. Türkiye\'nin dört bir yanından en taze ve kaliteli çiçekleri sizlere ulaştırma misyonuyla yola çıktık.\n\nDeneyimli ekibimiz ve güvenilir tedarikçilerimizle, özel günlerinizi daha anlamlı kılmak için buradayız. Her çiçeğimiz özenle seçilir ve sevdiklerinize ulaştırılır.\n\nMüşteri memnuniyeti bizim için en önemli değerdir. Kaliteli hizmet anlayışımızla çiçek alışverişinizi keyifli bir deneyime dönüştürüyoruz.',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => 'Hikaye İçeriği',
                'description' => 'Hakkımızda sayfasındaki hikaye metni',
                'sort_order' => 5
            ],
            [
                'key' => 'about_values_title',
                'value' => 'Değerlerimiz',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Değerler Bölümü Başlığı',
                'description' => 'Değerler bölümünün başlığı',
                'sort_order' => 6
            ],
            [
                'key' => 'about_value1_title',
                'value' => 'Kalite',
                'type' => 'text',
                'group' => 'pages',
                'label' => '1. Değer Başlığı',
                'description' => 'Birinci değerin başlığı',
                'sort_order' => 7
            ],
            [
                'key' => 'about_value1_content',
                'value' => 'En taze ve kaliteli çiçekleri özenle seçiyor, sizlere sunuyoruz.',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => '1. Değer İçeriği',
                'description' => 'Birinci değerin açıklaması',
                'sort_order' => 8
            ],
            [
                'key' => 'about_value2_title',
                'value' => 'Hızlı Teslimat',
                'type' => 'text',
                'group' => 'pages',
                'label' => '2. Değer Başlığı',
                'description' => 'İkinci değerin başlığı',
                'sort_order' => 9
            ],
            [
                'key' => 'about_value2_content',
                'value' => 'Siparişlerinizi aynı gün veya ertesi gün güvenle teslim ediyoruz.',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => '2. Değer İçeriği',
                'description' => 'İkinci değerin açıklaması',
                'sort_order' => 10
            ],
            [
                'key' => 'about_value3_title',
                'value' => 'Müşteri Memnuniyeti',
                'type' => 'text',
                'group' => 'pages',
                'label' => '3. Değer Başlığı',
                'description' => 'Üçüncü değerin başlığı',
                'sort_order' => 11
            ],
            [
                'key' => 'about_value3_content',
                'value' => 'Müşterilerimizin memnuniyeti bizim için en önemli önceliktir.',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => '3. Değer İçeriği',
                'description' => 'Üçüncü değerin açıklaması',
                'sort_order' => 12
            ],
            [
                'key' => 'about_team_title',
                'value' => 'Ekibimiz',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'Ekip Bölümü Başlığı',
                'description' => 'Ekip bölümünün başlığı',
                'sort_order' => 13
            ],
            [
                'key' => 'about_contact_title',
                'value' => 'Bizimle İletişime Geçin',
                'type' => 'text',
                'group' => 'pages',
                'label' => 'İletişim Bölümü Başlığı',
                'description' => 'İletişim bölümünün başlığı',
                'sort_order' => 14
            ],
            [
                'key' => 'about_contact_content',
                'value' => 'Sorularınız için her zaman buradayız. Çiçek siparişleriniz için bize ulaşın!',
                'type' => 'textarea',
                'group' => 'pages',
                'label' => 'İletişim Bölümü İçeriği',
                'description' => 'İletişim bölümünün açıklaması',
                'sort_order' => 15
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
