<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('payment_token')->nullable()->after('payment_status'); // PayTR token
            $table->string('paytr_merchant_oid')->nullable()->after('payment_token'); // PayTR merchant order id
            $table->text('payment_response')->nullable()->after('paytr_merchant_oid'); // PayTR yanıt verisi
            $table->timestamp('payment_attempted_at')->nullable()->after('payment_response'); // Ödeme deneme zamanı
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['payment_token', 'paytr_merchant_oid', 'payment_response', 'payment_attempted_at']);
        });
    }
};
