<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique(); // Ayar anahtarı
            $table->text('value')->nullable(); // Ayar değeri
            $table->string('type')->default('text'); // text, password, boolean, number
            $table->string('group')->default('general'); // Ayar grubu
            $table->string('label'); // Görünen isim
            $table->text('description')->nullable(); // Açıklama
            $table->boolean('is_encrypted')->default(false); // Şifrelenmiş mi?
            $table->timestamps();
        });

        // PayTR varsayılan ayarlarını ekle
        DB::table('payment_settings')->insert([
            [
                'key' => 'paytr_enabled',
                'value' => '0',
                'type' => 'boolean',
                'group' => 'paytr',
                'label' => 'PayTR Aktif',
                'description' => 'PayTR ödeme sistemini aktif/pasif yapar',
                'is_encrypted' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'paytr_test_mode',
                'value' => '1',
                'type' => 'boolean',
                'group' => 'paytr',
                'label' => 'Test Modu',
                'description' => 'PayTR test modunu aktif/pasif yapar',
                'is_encrypted' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'paytr_merchant_id',
                'value' => '',
                'type' => 'text',
                'group' => 'paytr',
                'label' => 'Merchant ID',
                'description' => 'PayTR\'den aldığınız Merchant ID',
                'is_encrypted' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'paytr_merchant_key',
                'value' => '',
                'type' => 'password',
                'group' => 'paytr',
                'label' => 'Merchant Key',
                'description' => 'PayTR\'den aldığınız Merchant Key',
                'is_encrypted' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'paytr_merchant_salt',
                'value' => '',
                'type' => 'password',
                'group' => 'paytr',
                'label' => 'Merchant Salt',
                'description' => 'PayTR\'den aldığınız Merchant Salt',
                'is_encrypted' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_settings');
    }
};
