<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Kategori adı (Güller, Orkideler, vb.)
            $table->string('slug')->unique(); // URL dostu isim (guller, orkideler)
            $table->text('description')->nullable(); // Kategori açıklaması
            $table->string('image')->nullable(); // Kategori resmi
            $table->string('icon')->nullable(); // Bootstrap icon sınıfı
            $table->string('color', 7)->default('#E91E63'); // Kategori rengi (hex)
            $table->boolean('is_active')->default(true); // Aktif/pasif durumu
            $table->integer('sort_order')->default(0); // Sıralama
            $table->unsignedBigInteger('parent_id')->nullable(); // Alt kategori için
            $table->timestamps();

            $table->foreign('parent_id')->references('id')->on('categories')->onDelete('cascade');
            $table->index(['is_active', 'sort_order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
