<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    /**
     * Kullanıcının sipariş listesi
     */
    public function index()
    {
        $orders = Order::where('user_id', Auth::id())
                      ->with('items.product.category')
                      ->orderBy('created_at', 'desc')
                      ->paginate(10);

        return view('orders.index', compact('orders'));
    }

    /**
     * Sipariş detayı
     */
    public function show($orderId)
    {
        $order = Order::where('id', $orderId)
                     ->where('user_id', Auth::id())
                     ->with('items.product.category')
                     ->firstOrFail();

        return view('orders.show', compact('order'));
    }

    /**
     * Sipariş iptal etme
     */
    public function cancel($orderId)
    {
        $order = Order::where('id', $orderId)
                     ->where('user_id', Auth::id())
                     ->firstOrFail();

        // Sadece beklemede olan siparişler iptal edilebilir
        if ($order->status !== 'pending') {
            return back()->with('error', 'Bu sipariş iptal edilemez!');
        }

        // Stokları geri ekle
        foreach ($order->items as $item) {
            $item->product->increment('stock_quantity', $item->quantity);
        }

        // Sipariş durumunu güncelle
        $order->update(['status' => 'cancelled']);

        return back()->with('success', 'Siparişiniz iptal edildi. Stoklar geri eklendi.');
    }
}
