<?php $__env->startSection('title', 'Site Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item active">Site Yönetimi</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-2">
                <i class="bi bi-gear me-2"></i>Site Yönetimi
            </h1>
            <p class="text-muted mb-0">Site ayarlarını, meta tagları ve işletme bilgilerini yönetin</p>
        </div>
    </div>

    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="row">
            <!-- Settings Tabs -->
            <div class="col-lg-3">
                <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-list me-2"></i>Ayar Kategorileri
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="nav nav-pills flex-column" id="settings-tabs" role="tablist">
                            <?php $__currentLoopData = $settingGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button class="nav-link text-start <?php echo e($loop->first ? 'active' : ''); ?>" 
                                    id="<?php echo e($group); ?>-tab" 
                                    data-bs-toggle="pill" 
                                    data-bs-target="#<?php echo e($group); ?>" 
                                    type="button" 
                                    role="tab">
                                <i class="bi bi-<?php echo e($group === 'general' ? 'gear' : ($group === 'seo' ? 'search' : ($group === 'business' ? 'building' : ($group === 'social' ? 'share' : ($group === 'footer' ? 'layout-text-window-reverse' : ($group === 'pages' ? 'file-text' : 'cart')))))); ?> me-2"></i>
                                <?php echo e($title); ?>

                                <span class="badge bg-secondary ms-auto"><?php echo e($settings[$group]['settings']->count()); ?></span>
                            </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Content -->
            <div class="col-lg-9">
                <div class="tab-content" id="settings-content">
                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" 
                         id="<?php echo e($group); ?>" 
                         role="tabpanel">
                        
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white">
                                <h5 class="mb-0">
                                    <i class="bi bi-<?php echo e($group === 'general' ? 'gear' : ($group === 'seo' ? 'search' : ($group === 'business' ? 'building' : ($group === 'social' ? 'share' : ($group === 'footer' ? 'layout-text-window-reverse' : ($group === 'pages' ? 'file-text' : 'cart')))))); ?> me-2"></i>
                                    <?php echo e($groupData['title']); ?>

                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php $__currentLoopData = $groupData['settings']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-<?php echo e(in_array($setting->type, ['textarea', 'image']) ? '12' : '6'); ?> mb-4">
                                        <label for="setting_<?php echo e($setting->key); ?>" class="form-label">
                                            <?php echo e($setting->label); ?>

                                            <?php if(in_array($setting->key, ['site_name', 'meta_title', 'meta_description', 'business_name'])): ?>
                                                <span class="text-danger">*</span>
                                            <?php endif; ?>
                                        </label>
                                        
                                        <?php if($setting->type === 'text'): ?>
                                            <input type="text" 
                                                   class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="setting_<?php echo e($setting->key); ?>" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   value="<?php echo e(old('settings.'.$setting->key, $setting->value)); ?>">
                                        
                                        <?php elseif($setting->type === 'textarea'): ?>
                                            <textarea class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                      id="setting_<?php echo e($setting->key); ?>" 
                                                      name="settings[<?php echo e($setting->key); ?>]" 
                                                      rows="<?php echo e($setting->key === 'meta_description' ? '3' : (str_contains($setting->key, 'about_story_content') ? '8' : '4')); ?>"><?php echo e(old('settings.'.$setting->key, $setting->value)); ?></textarea>
                                        
                                        <?php elseif($setting->type === 'email'): ?>
                                            <input type="email" 
                                                   class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="setting_<?php echo e($setting->key); ?>" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   value="<?php echo e(old('settings.'.$setting->key, $setting->value)); ?>">
                                        
                                        <?php elseif($setting->type === 'url'): ?>
                                            <input type="url" 
                                                   class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="setting_<?php echo e($setting->key); ?>" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   value="<?php echo e(old('settings.'.$setting->key, $setting->value)); ?>" 
                                                   placeholder="https://example.com">
                                        
                                        <?php elseif($setting->type === 'number'): ?>
                                            <input type="number" 
                                                   class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="setting_<?php echo e($setting->key); ?>" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   value="<?php echo e(old('settings.'.$setting->key, $setting->value)); ?>" 
                                                   min="0" step="0.01">
                                        
                                        <?php elseif($setting->type === 'boolean'): ?>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       id="setting_<?php echo e($setting->key); ?>" 
                                                       name="settings[<?php echo e($setting->key); ?>]" 
                                                       value="1" 
                                                       <?php echo e(old('settings.'.$setting->key, $setting->value) ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="setting_<?php echo e($setting->key); ?>">
                                                    Aktif
                                                </label>
                                            </div>
                                        
                                        <?php elseif($setting->type === 'image'): ?>
                                            <?php if($setting->value): ?>
                                            <div class="mb-2">
                                                <img src="<?php echo e(asset('storage/' . $setting->value)); ?>" 
                                                     alt="<?php echo e($setting->label); ?>" 
                                                     class="img-thumbnail" 
                                                     style="max-width: 200px; max-height: 100px;">
                                            </div>
                                            <?php endif; ?>
                                            <input type="file" 
                                                   class="form-control <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="setting_<?php echo e($setting->key); ?>" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   accept="image/*">
                                        <?php endif; ?>
                                        
                                        <?php if($setting->description): ?>
                                        <div class="form-text"><?php echo e($setting->description); ?></div>
                                        <?php endif; ?>
                                        
                                        <?php $__errorArgs = ['settings.'.$setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Save Button -->
                <div class="card border-0 shadow-sm mt-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-1">Değişiklikleri Kaydet</h6>
                                <small class="text-muted">Tüm ayarlar otomatik olarak kaydedilecektir</small>
                            </div>
                            <div>
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="bi bi-check-circle me-2"></i>Ayarları Kaydet
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Character counter for meta description
    const metaDescInput = document.getElementById('setting_meta_description');
    if (metaDescInput) {
        const counter = document.createElement('div');
        counter.className = 'form-text text-end';
        counter.style.marginTop = '5px';
        metaDescInput.parentNode.appendChild(counter);
        
        function updateCounter() {
            const length = metaDescInput.value.length;
            counter.innerHTML = `<span class="${length > 160 ? 'text-danger' : 'text-muted'}">${length}/160 karakter</span>`;
        }
        
        metaDescInput.addEventListener('input', updateCounter);
        updateCounter();
    }
    
    // Image preview
    document.querySelectorAll('input[type="file"]').forEach(input => {
        input.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                // File size check (2MB)
                if (file.size > 2 * 1024 * 1024) {
                    alert('Dosya boyutu 2MB\'dan büyük olamaz!');
                    this.value = '';
                    return;
                }
                
                // File type check
                if (!file.type.startsWith('image/')) {
                    alert('Lütfen geçerli bir resim dosyası seçin!');
                    this.value = '';
                    return;
                }
            }
        });
    });
    
    // Auto-save warning
    let hasChanges = false;
    document.querySelectorAll('input, textarea, select').forEach(element => {
        element.addEventListener('change', function() {
            hasChanges = true;
        });
    });
    
    window.addEventListener('beforeunload', function(e) {
        if (hasChanges) {
            e.preventDefault();
            e.returnValue = 'Kaydedilmemiş değişiklikleriniz var. Sayfadan ayrılmak istediğinizden emin misiniz?';
        }
    });
    
    // Reset hasChanges on form submit
    document.querySelector('form').addEventListener('submit', function() {
        hasChanges = false;
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>