<?php $__env->startSection('title', 'Kategori Yönetimi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-tags me-2"></i>Kategori Yönetimi
                    </h1>
                    <p class="text-muted mb-0">Kategorileri görüntüleyin, ekleyin ve düzenleyin</p>
                </div>
                <div>
                    <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-primary btn-lg">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Kategori Ekle
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Categories Grid -->
    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-xl-4 col-lg-6">
            <div class="card border-0 shadow-sm h-100">
                <?php if($category->image): ?>
                <div class="position-relative">
                    <img src="<?php echo e(asset('storage/' . $category->image)); ?>" 
                         alt="<?php echo e($category->name); ?>" 
                         class="card-img-top" 
                         style="height: 150px; object-fit: cover;">
                    <div class="position-absolute top-0 end-0 m-2">
                        <div class="form-check form-switch">
                            <input class="form-check-input category-toggle bg-white" type="checkbox" 
                                   data-category-id="<?php echo e($category->id); ?>"
                                   <?php echo e($category->is_active ? 'checked' : ''); ?>>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="card-header bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <?php if(!$category->image): ?>
                            <div class="me-3 p-2 rounded" style="background-color: <?php echo e($category->color); ?>20;">
                                <i class="<?php echo e($category->icon); ?>" style="color: <?php echo e($category->color); ?>; font-size: 1.5rem;"></i>
                            </div>
                            <?php endif; ?>
                            <div>
                                <h5 class="mb-1 fw-bold"><?php echo e($category->name); ?></h5>
                                <small class="text-muted"><?php echo e($category->products_count); ?> ürün</small>
                            </div>
                        </div>
                        <?php if(!$category->image): ?>
                        <div class="form-check form-switch">
                            <input class="form-check-input category-toggle" type="checkbox" 
                                   data-category-id="<?php echo e($category->id); ?>"
                                   <?php echo e($category->is_active ? 'checked' : ''); ?>>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <?php if($category->description): ?>
                    <p class="text-muted small mb-3"><?php echo e(Str::limit($category->description, 100)); ?></p>
                    <?php endif; ?>
                    
                    <div class="row text-center mb-3">
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-primary mb-1"><?php echo e($category->products_count); ?></h6>
                                <small class="text-muted">Ürün</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-success mb-1"><?php echo e($category->sort_order); ?></h6>
                                <small class="text-muted">Sıra</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <h6 class="text-info mb-1">
                                <span class="badge" style="background-color: <?php echo e($category->color); ?>;"><?php echo e($category->color); ?></span>
                            </h6>
                            <small class="text-muted">Renk</small>
                        </div>
                    </div>
                    
                    <?php if($category->meta_title || $category->meta_description): ?>
                    <div class="mb-3">
                        <small class="text-muted">
                            <i class="bi bi-search me-1"></i>SEO: 
                            <?php echo e($category->meta_title ? 'Başlık ✓' : ''); ?>

                            <?php echo e($category->meta_description ? 'Açıklama ✓' : ''); ?>

                        </small>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="card-footer bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <small class="text-muted">
                            <?php echo e($category->created_at->format('d.m.Y')); ?>

                        </small>
                        <div class="btn-group btn-group-sm">
                            <a href="<?php echo e(route('categories.show', $category->slug)); ?>" 
                               class="btn btn-outline-info" target="_blank" title="Görüntüle">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.categories.edit', $category->id)); ?>" 
                               class="btn btn-outline-primary" title="Düzenle">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <button type="button" class="btn btn-outline-danger delete-category" 
                                    data-category-id="<?php echo e($category->id); ?>" 
                                    data-category-name="<?php echo e($category->name); ?>" 
                                    data-products-count="<?php echo e($category->products_count); ?>" title="Sil">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-tags display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Henüz Kategori Yok</h3>
                <p class="text-muted mb-4">İlk kategorinizi oluşturarak başlayın!</p>
                <a href="<?php echo e(route('admin.categories.create')); ?>" class="btn btn-primary btn-lg">
                    <i class="bi bi-plus-circle me-2"></i>İlk Kategoriyi Ekle
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Kategoriyi Sil</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Dikkat!</strong> Bu işlem geri alınamaz.
                </div>
                <p id="delete-message"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <form id="delete-form" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Evet, Sil</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Category status toggle
    document.querySelectorAll('.category-toggle').forEach(toggle => {
        toggle.addEventListener('change', function() {
            const categoryId = this.dataset.categoryId;
            const isActive = this.checked;
            
            fetch(`/admin/categories/${categoryId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !isActive; // Revert on error
                    alert('Durum güncellenirken hata oluştu!');
                }
            })
            .catch(error => {
                this.checked = !isActive; // Revert on error
                alert('Bir hata oluştu!');
            });
        });
    });

    // Delete category
    document.querySelectorAll('.delete-category').forEach(button => {
        button.addEventListener('click', function() {
            const categoryId = this.dataset.categoryId;
            const categoryName = this.dataset.categoryName;
            const productsCount = parseInt(this.dataset.productsCount);
            
            const deleteForm = document.getElementById('delete-form');
            const deleteMessage = document.getElementById('delete-message');
            
            deleteForm.action = `/admin/categories/${categoryId}`;
            
            if (productsCount > 0) {
                deleteMessage.innerHTML = `<strong>${categoryName}</strong> kategorisini silmek istediğinizden emin misiniz?<br><br>Bu kategoride <strong>${productsCount} ürün</strong> bulunmaktadır. Kategori silindiğinde bu ürünler kategorisiz kalacaktır.`;
            } else {
                deleteMessage.innerHTML = `<strong>${categoryName}</strong> kategorisini silmek istediğinizden emin misiniz?`;
            }
            
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>