<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Çiçek Bahçesi')); ?> - <?php echo $__env->yieldContent('title', 'Giriş'); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

        <!-- Bootstrap Icons -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

        <style>
            :root {
                --primary-color: #E91E63;
                --secondary-color: #4CAF50;
            }

            body {
                font-family: 'Poppins', sans-serif;
                background: linear-gradient(135deg, #E91E63, #4CAF50);
                min-height: 100vh;
            }

            .auth-card {
                backdrop-filter: blur(10px);
                background: rgba(255, 255, 255, 0.95);
                border: none;
                box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            }

            .btn-primary {
                background-color: var(--primary-color);
                border-color: var(--primary-color);
            }

            .btn-primary:hover {
                background-color: #C2185B;
                border-color: #C2185B;
            }

            .form-control:focus {
                border-color: var(--primary-color);
                box-shadow: 0 0 0 0.2rem rgba(233, 30, 99, 0.25);
            }
        </style>
    </head>
    <body class="d-flex align-items-center justify-content-center min-vh-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-4">
                    <div class="text-center mb-4">
                        <a href="<?php echo e(route('home')); ?>" class="text-decoration-none">
                            <h2 class="text-white fw-bold">
                                <i class="bi bi-flower1 me-2"></i>
                                <?php echo e(config('app.name', 'Çiçek Bahçesi')); ?>

                            </h2>
                        </a>
                    </div>

                    <div class="card auth-card">
                        <div class="card-body p-4">
                            <?php echo e($slot); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bootstrap JS -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    </body>
</html>
<?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/layouts/guest.blade.php ENDPATH**/ ?>