<?php $__env->startSection('title', 'Slider Düzenle'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.sliders.index')); ?>">Slider Yönetimi</a></li>
                    <li class="breadcrumb-item active"><?php echo e($slider->title); ?> - Düzenle</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-2">
                <i class="bi bi-pencil me-2"></i>Slider Düzenle
            </h1>
            <p class="text-muted mb-0"><?php echo e($slider->title); ?> slider'ını düzenleyin</p>
        </div>
    </div>

    <form action="<?php echo e(route('admin.sliders.update', $slider->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <!-- Main Slider Info -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Temel Bilgiler
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Slider Başlığı *</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="title" name="title" value="<?php echo e(old('title', $slider->title)); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" name="description" rows="3"><?php echo e(old('description', $slider->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-8 mb-3">
                                <label for="button_text" class="form-label">Buton Metni</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['button_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="button_text" name="button_text" value="<?php echo e(old('button_text', $slider->button_text)); ?>">
                                <?php $__errorArgs = ['button_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="sort_order" class="form-label">Sıralama</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="sort_order" name="sort_order" value="<?php echo e(old('sort_order', $slider->sort_order)); ?>" min="0">
                                <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="button_link" class="form-label">Buton Linki</label>
                            <input type="url" class="form-control <?php $__errorArgs = ['button_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="button_link" name="button_link" value="<?php echo e(old('button_link', $slider->button_link)); ?>" 
                                   placeholder="https://example.com">
                            <?php $__errorArgs = ['button_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">Buton tıklandığında yönlendirilecek URL</div>
                        </div>
                    </div>
                </div>

                <!-- Slider Image -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-image me-2"></i>Slider Resmi
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Current Image -->
                        <?php if($slider->image): ?>
                        <div class="mb-3">
                            <label class="form-label">Mevcut Resim</label>
                            <div class="text-center">
                                <img src="<?php echo e(asset('storage/' . $slider->image)); ?>" 
                                     alt="<?php echo e($slider->title); ?>" 
                                     class="img-thumbnail" 
                                     style="max-width: 100%; max-height: 200px;">
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="mb-3">
                            <label for="image" class="form-label">
                                <?php echo e($slider->image ? 'Yeni Resim Yükle (İsteğe Bağlı)' : 'Slider Resmi *'); ?>

                            </label>
                            <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="image" name="image" accept="image/*" <?php echo e(!$slider->image ? 'required' : ''); ?>>
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">
                                JPG, PNG veya WebP formatında, maksimum 2MB. Önerilen boyut: 1920x600px
                                <?php if($slider->image): ?>
                                    <br><strong>Not:</strong> Yeni resim yüklerseniz mevcut resim silinecektir.
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- New Image Preview -->
                        <div id="image_preview" class="text-center" style="display: none;">
                            <label class="form-label">Yeni Resim Önizlemesi</label>
                            <br>
                            <img id="preview_img" src="" alt="Önizleme" class="img-thumbnail" style="max-width: 100%; max-height: 300px;">
                            <br>
                            <button type="button" class="btn btn-outline-danger btn-sm mt-2" id="remove_image">
                                <i class="bi bi-trash me-1"></i>Yeni Resmi Kaldır
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Preview -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-eye me-2"></i>Önizleme
                        </h5>
                    </div>
                    <div class="card-body">
                        <div id="slider_preview" class="position-relative rounded overflow-hidden" style="height: 200px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <div id="preview_image_container" class="position-absolute w-100 h-100">
                                <img id="preview_slider_img" 
                                     src="<?php echo e($slider->image ? asset('storage/' . $slider->image) : ''); ?>" 
                                     alt="Slider Resmi" 
                                     class="w-100 h-100" 
                                     style="object-fit: cover; <?php echo e(!$slider->image ? 'display: none;' : ''); ?>">
                            </div>
                            <div class="position-absolute bottom-0 start-0 p-3 text-white w-100" style="background: linear-gradient(transparent, rgba(0,0,0,0.7));">
                                <h5 id="preview_title" class="mb-2"><?php echo e($slider->title); ?></h5>
                                <p id="preview_description" class="mb-2 small"><?php echo e($slider->description ?: 'Slider açıklaması burada görünecek'); ?></p>
                                <div id="preview_button_container" style="<?php echo e($slider->button_text ? 'display: block;' : 'display: none;'); ?>">
                                    <button id="preview_button" class="btn btn-primary btn-sm"><?php echo e($slider->button_text ?: 'Buton Metni'); ?></button>
                                </div>
                            </div>
                        </div>
                        <small class="text-muted d-block mt-2 text-center">Bu slider ana sayfada böyle görünecek</small>
                    </div>
                </div>

                <!-- Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-gear me-2"></i>Ayarlar
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" 
                                   <?php echo e(old('is_active', $slider->is_active) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Slider Aktif
                            </label>
                            <div class="form-text">Pasif slider'lar ana sayfada gösterilmez</div>
                        </div>
                    </div>
                </div>

                <!-- Slider Info -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Slider Bilgileri
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6">
                                <div class="border-end">
                                    <h6 class="text-primary mb-1"><?php echo e($slider->sort_order); ?></h6>
                                    <small class="text-muted">Sıra</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <h6 class="text-<?php echo e($slider->is_active ? 'success' : 'secondary'); ?> mb-1">
                                    <i class="bi bi-<?php echo e($slider->is_active ? 'check-circle' : 'x-circle'); ?>"></i>
                                </h6>
                                <small class="text-muted"><?php echo e($slider->is_active ? 'Aktif' : 'Pasif'); ?></small>
                            </div>
                        </div>
                        <hr>
                        <div class="text-center">
                            <small class="text-muted">
                                <strong>Oluşturulma:</strong> <?php echo e($slider->created_at->format('d.m.Y H:i')); ?><br>
                                <strong>Son Güncelleme:</strong> <?php echo e($slider->updated_at->format('d.m.Y H:i')); ?>

                            </small>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i>Değişiklikleri Kaydet
                            </button>
                            <a href="<?php echo e(route('admin.sliders.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Geri Dön
                            </a>
                            <?php if($slider->button_link): ?>
                            <a href="<?php echo e($slider->button_link); ?>" target="_blank" class="btn btn-outline-info">
                                <i class="bi bi-box-arrow-up-right me-2"></i>Linki Aç
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const titleInput = document.getElementById('title');
    const descriptionInput = document.getElementById('description');
    const buttonTextInput = document.getElementById('button_text');
    
    const previewTitle = document.getElementById('preview_title');
    const previewDescription = document.getElementById('preview_description');
    const previewButton = document.getElementById('preview_button');
    const previewButtonContainer = document.getElementById('preview_button_container');

    function updatePreview() {
        const title = titleInput.value || 'Slider Başlığı';
        const description = descriptionInput.value || 'Slider açıklaması burada görünecek';
        const buttonText = buttonTextInput.value;

        previewTitle.textContent = title;
        previewDescription.textContent = description;
        
        if (buttonText) {
            previewButton.textContent = buttonText;
            previewButtonContainer.style.display = 'block';
        } else {
            previewButtonContainer.style.display = 'none';
        }
    }

    // Event listeners
    titleInput.addEventListener('input', updatePreview);
    descriptionInput.addEventListener('input', updatePreview);
    buttonTextInput.addEventListener('input', updatePreview);

    // Image preview
    const imageInput = document.getElementById('image');
    const imagePreview = document.getElementById('image_preview');
    const previewImg = document.getElementById('preview_img');
    const removeImageBtn = document.getElementById('remove_image');
    const previewSliderImg = document.getElementById('preview_slider_img');

    imageInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            // File size check (2MB)
            if (file.size > 2 * 1024 * 1024) {
                alert('Dosya boyutu 2MB\'dan büyük olamaz!');
                this.value = '';
                return;
            }

            // File type check
            if (!file.type.startsWith('image/')) {
                alert('Lütfen geçerli bir resim dosyası seçin!');
                this.value = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
                
                // Update slider preview
                previewSliderImg.src = e.target.result;
                previewSliderImg.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
            // Reset to original image if exists
            <?php if($slider->image): ?>
            previewSliderImg.src = "<?php echo e(asset('storage/' . $slider->image)); ?>";
            previewSliderImg.style.display = 'block';
            <?php else: ?>
            previewSliderImg.style.display = 'none';
            <?php endif; ?>
        }
    });

    removeImageBtn.addEventListener('click', function() {
        imageInput.value = '';
        imagePreview.style.display = 'none';
        // Reset to original image if exists
        <?php if($slider->image): ?>
        previewSliderImg.src = "<?php echo e(asset('storage/' . $slider->image)); ?>";
        previewSliderImg.style.display = 'block';
        <?php else: ?>
        previewSliderImg.style.display = 'none';
        <?php endif; ?>
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/sliders/edit.blade.php ENDPATH**/ ?>