<?php $__env->startSection('title', 'Raporlar ve İstatistikler'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-graph-up me-2"></i>Raporlar ve İstatistikler
                    </h1>
                    <p class="text-muted mb-0">İşletmenizin performansını takip edin</p>
                </div>
                <div>
                    <button class="btn btn-outline-primary me-2" onclick="window.print()">
                        <i class="bi bi-printer me-2"></i>Yazdır
                    </button>
                    <button class="btn btn-primary" onclick="exportData()">
                        <i class="bi bi-download me-2"></i>Dışa Aktar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="p-3 rounded-circle bg-primary bg-opacity-10">
                                <i class="bi bi-box-seam text-primary" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Ürün</h6>
                            <h3 class="mb-0"><?php echo e(number_format($totalProducts)); ?></h3>
                            <small class="text-success">
                                <i class="bi bi-check-circle me-1"></i><?php echo e($activeProducts); ?> aktif
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="p-3 rounded-circle bg-success bg-opacity-10">
                                <i class="bi bi-cart-check text-success" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Sipariş</h6>
                            <h3 class="mb-0"><?php echo e(number_format($totalOrders)); ?></h3>
                            <small class="text-info">
                                <i class="bi bi-calendar-month me-1"></i>Bu ay: <?php echo e($monthlyOrders); ?>

                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="p-3 rounded-circle bg-warning bg-opacity-10">
                                <i class="bi bi-currency-dollar text-warning" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Gelir</h6>
                            <h3 class="mb-0">₺<?php echo e(number_format($totalRevenue, 2)); ?></h3>
                            <small class="text-info">
                                <i class="bi bi-calendar-month me-1"></i>Bu ay: ₺<?php echo e(number_format($monthlyRevenue, 2)); ?>

                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="p-3 rounded-circle bg-info bg-opacity-10">
                                <i class="bi bi-people text-info" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Toplam Kullanıcı</h6>
                            <h3 class="mb-0"><?php echo e(number_format($totalUsers)); ?></h3>
                            <small class="text-success">
                                <i class="bi bi-person-plus me-1"></i>Bu ay: <?php echo e($monthlyUsers); ?>

                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Sales Chart -->
        <div class="col-xl-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-graph-up me-2"></i>Son 7 Gün Satış Grafiği
                    </h5>
                </div>
                <div class="card-body">
                    <canvas id="salesChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!-- Order Status -->
        <div class="col-xl-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-pie-chart me-2"></i>Sipariş Durumları
                    </h5>
                </div>
                <div class="card-body">
                    <canvas id="orderStatusChart" height="300"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-1">
        <!-- Top Products -->
        <div class="col-xl-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-trophy me-2"></i>En Çok Satan Ürünler
                    </h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex align-items-center mb-3 <?php echo e($loop->last ? '' : 'border-bottom pb-3'); ?>">
                        <div class="flex-shrink-0">
                            <span class="badge bg-primary rounded-pill"><?php echo e($index + 1); ?></span>
                        </div>
                        <div class="flex-shrink-0 ms-3">
                            <?php if($product->image): ?>
                            <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                                 alt="<?php echo e($product->name); ?>" 
                                 class="rounded" 
                                 style="width: 40px; height: 40px; object-fit: cover;">
                            <?php else: ?>
                            <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="width: 40px; height: 40px;">
                                <i class="bi bi-image text-muted"></i>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-1"><?php echo e($product->name); ?></h6>
                            <small class="text-muted"><?php echo e($product->order_items_count); ?> satış</small>
                        </div>
                        <div class="flex-shrink-0">
                            <span class="badge bg-success">₺<?php echo e(number_format($product->price, 2)); ?></span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4">
                        <i class="bi bi-box display-4 text-muted mb-3"></i>
                        <p class="text-muted">Henüz satış verisi yok</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Category Sales -->
        <div class="col-xl-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-tags me-2"></i>Kategori Bazında Satışlar
                    </h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $categorySales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="d-flex align-items-center mb-3 <?php echo e($loop->last ? '' : 'border-bottom pb-3'); ?>">
                        <div class="flex-shrink-0">
                            <div class="p-2 rounded" style="background-color: <?php echo e($category['color']); ?>20;">
                                <div class="rounded-circle" 
                                     style="width: 12px; height: 12px; background-color: <?php echo e($category['color']); ?>;"></div>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="mb-1"><?php echo e($category['name']); ?></h6>
                            <small class="text-muted"><?php echo e($category['products_count']); ?> ürün</small>
                        </div>
                        <div class="flex-shrink-0">
                            <span class="badge bg-primary"><?php echo e($category['sales']); ?> satış</span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4">
                        <i class="bi bi-tags display-4 text-muted mb-3"></i>
                        <p class="text-muted">Kategori verisi yok</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Orders -->
    <div class="row g-4 mt-1">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-clock-history me-2"></i>Son Siparişler
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Sipariş No</th>
                                    <th>Müşteri</th>
                                    <th>Ürünler</th>
                                    <th>Tutar</th>
                                    <th>Durum</th>
                                    <th>Tarih</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <strong>#<?php echo e($order->order_number); ?></strong>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" 
                                                     style="width: 32px; height: 32px;">
                                                    <i class="bi bi-person text-primary"></i>
                                                </div>
                                            </div>
                                            <div class="ms-2">
                                                <div class="fw-semibold"><?php echo e($order->user->name); ?></div>
                                                <small class="text-muted"><?php echo e($order->user->email); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($order->items->count()); ?> ürün</small>
                                    </td>
                                    <td>
                                        <strong>₺<?php echo e(number_format($order->total_amount, 2)); ?></strong>
                                    </td>
                                    <td>
                                        <?php
                                            $statusColors = [
                                                'pending' => 'warning',
                                                'processing' => 'info',
                                                'shipped' => 'primary',
                                                'completed' => 'success',
                                                'cancelled' => 'danger'
                                            ];
                                            $statusTexts = [
                                                'pending' => 'Bekliyor',
                                                'processing' => 'İşleniyor',
                                                'shipped' => 'Kargoda',
                                                'completed' => 'Tamamlandı',
                                                'cancelled' => 'İptal'
                                            ];
                                        ?>
                                        <span class="badge bg-<?php echo e($statusColors[$order->status] ?? 'secondary'); ?>">
                                            <?php echo e($statusTexts[$order->status] ?? $order->status); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></small>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <i class="bi bi-inbox display-4 text-muted mb-3"></i>
                                        <p class="text-muted">Henüz sipariş yok</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Chart
    const salesCtx = document.getElementById('salesChart').getContext('2d');
    const salesData = <?php echo json_encode($salesChart, 15, 512) ?>;
    
    new Chart(salesCtx, {
        type: 'line',
        data: {
            labels: salesData.map(item => item.date),
            datasets: [{
                label: 'Günlük Satış (₺)',
                data: salesData.map(item => item.sales),
                borderColor: '#0d6efd',
                backgroundColor: 'rgba(13, 110, 253, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '₺' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Order Status Chart
    const statusCtx = document.getElementById('orderStatusChart').getContext('2d');
    const orderStatuses = <?php echo json_encode($orderStatuses, 15, 512) ?>;
    
    const statusLabels = {
        'pending': 'Bekliyor',
        'processing': 'İşleniyor', 
        'shipped': 'Kargoda',
        'completed': 'Tamamlandı',
        'cancelled': 'İptal'
    };
    
    const statusColors = {
        'pending': '#ffc107',
        'processing': '#0dcaf0',
        'shipped': '#0d6efd', 
        'completed': '#198754',
        'cancelled': '#dc3545'
    };

    new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: Object.keys(orderStatuses).map(status => statusLabels[status] || status),
            datasets: [{
                data: Object.values(orderStatuses),
                backgroundColor: Object.keys(orderStatuses).map(status => statusColors[status] || '#6c757d'),
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});

function exportData() {
    // Basit CSV export
    const data = [
        ['Metrik', 'Değer'],
        ['Toplam Ürün', '<?php echo e($totalProducts); ?>'],
        ['Aktif Ürün', '<?php echo e($activeProducts); ?>'],
        ['Toplam Sipariş', '<?php echo e($totalOrders); ?>'],
        ['Toplam Gelir', '<?php echo e($totalRevenue); ?>'],
        ['Toplam Kullanıcı', '<?php echo e($totalUsers); ?>'],
        ['Bu Ay Sipariş', '<?php echo e($monthlyOrders); ?>'],
        ['Bu Ay Gelir', '<?php echo e($monthlyRevenue); ?>'],
        ['Bu Ay Yeni Kullanıcı', '<?php echo e($monthlyUsers); ?>']
    ];
    
    const csvContent = data.map(row => row.join(',')).join('\n');
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    const url = URL.createObjectURL(blob);
    link.setAttribute('href', url);
    link.setAttribute('download', 'raporlar_' + new Date().toISOString().split('T')[0] + '.csv');
    link.style.visibility = 'hidden';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/reports/index.blade.php ENDPATH**/ ?>