<?php $__env->startSection('title', 'Hakkımızda'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <!-- Page Header -->
    <div class="row mb-5">
        <div class="col-12 text-center">
            <h1 class="display-4 fw-bold text-primary mb-3"><?php echo e(\App\Models\Setting::get('about_page_title', 'Hakkımızda')); ?></h1>
            <p class="lead text-muted"><?php echo e(\App\Models\Setting::get('about_page_subtitle', 'Çiçek Bahçesi olarak hikayemizi keşfedin')); ?></p>
        </div>
    </div>

    <!-- About Content -->
    <div class="row align-items-center mb-5">
        <div class="col-lg-6 mb-4">
            <div class="bg-gradient p-5 text-center rounded-3" style="background: linear-gradient(135deg, #E91E6320, #E1F5FE);">
                <i class="bi bi-flower1 display-1 text-primary mb-3"></i>
                <h3 class="fw-bold text-primary">Çiçek Bahçesi</h3>
                <p class="text-muted">2024'ten beri hizmetinizdeyiz</p>
            </div>
        </div>
        <div class="col-lg-6">
            <h2 class="fw-bold text-primary mb-4"><?php echo e(\App\Models\Setting::get('about_story_title', 'Hikayemiz')); ?></h2>
            <?php
                $storyContent = \App\Models\Setting::get('about_story_content', 'Çiçek Bahçesi, 2024 yılında çiçek severlerin ihtiyaçlarını karşılamak amacıyla kurulmuştur.');
                $paragraphs = explode("\n\n", $storyContent);
            ?>
            <?php $__currentLoopData = $paragraphs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paragraph): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(trim($paragraph)): ?>
                <p class="text-muted <?php echo e($loop->last ? '' : 'mb-3'); ?>"><?php echo e(trim($paragraph)); ?></p>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Values Section -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="fw-bold text-primary text-center mb-5"><?php echo e(\App\Models\Setting::get('about_values_title', 'Değerlerimiz')); ?></h2>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-heart-fill fs-2 text-primary"></i>
                    </div>
                    <h5 class="fw-bold mb-3"><?php echo e(\App\Models\Setting::get('about_value1_title', 'Kalite')); ?></h5>
                    <p class="text-muted"><?php echo e(\App\Models\Setting::get('about_value1_content', 'En taze ve kaliteli çiçekleri özenle seçiyor, sizlere sunuyoruz.')); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-truck fs-2 text-success"></i>
                    </div>
                    <h5 class="fw-bold mb-3"><?php echo e(\App\Models\Setting::get('about_value2_title', 'Hızlı Teslimat')); ?></h5>
                    <p class="text-muted"><?php echo e(\App\Models\Setting::get('about_value2_content', 'Siparişlerinizi aynı gün veya ertesi gün güvenle teslim ediyoruz.')); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="bi bi-people-fill fs-2 text-warning"></i>
                    </div>
                    <h5 class="fw-bold mb-3"><?php echo e(\App\Models\Setting::get('about_value3_title', 'Müşteri Memnuniyeti')); ?></h5>
                    <p class="text-muted"><?php echo e(\App\Models\Setting::get('about_value3_content', 'Müşterilerimizin memnuniyeti bizim için en önemli önceliktir.')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Team Section -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="fw-bold text-primary text-center mb-5"><?php echo e(\App\Models\Setting::get('about_team_title', 'Ekibimiz')); ?></h2>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-gradient rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                         style="width: 100px; height: 100px; background: linear-gradient(135deg, #E91E63, #4CAF50);">
                        <i class="bi bi-person-fill fs-1 text-white"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Ahmet Yılmaz</h5>
                    <p class="text-primary mb-2">Kurucu & CEO</p>
                    <p class="text-muted small">15 yıllık çiçekçilik deneyimi</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-gradient rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                         style="width: 100px; height: 100px; background: linear-gradient(135deg, #4CAF50, #FF9800);">
                        <i class="bi bi-person-fill fs-1 text-white"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Ayşe Demir</h5>
                    <p class="text-success mb-2">Baş Tasarımcı</p>
                    <p class="text-muted small">Çiçek düzenleme uzmanı</p>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm text-center">
                <div class="card-body p-4">
                    <div class="bg-gradient rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                         style="width: 100px; height: 100px; background: linear-gradient(135deg, #FF9800, #E91E63);">
                        <i class="bi bi-person-fill fs-1 text-white"></i>
                    </div>
                    <h5 class="fw-bold mb-2">Mehmet Kaya</h5>
                    <p class="text-warning mb-2">Operasyon Müdürü</p>
                    <p class="text-muted small">Lojistik ve teslimat uzmanı</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact CTA -->
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm bg-primary text-white text-center">
                <div class="card-body p-5">
                    <h3 class="fw-bold mb-3"><?php echo e(\App\Models\Setting::get('about_contact_title', 'Bizimle İletişime Geçin')); ?></h3>
                    <p class="mb-4"><?php echo e(\App\Models\Setting::get('about_contact_content', 'Sorularınız için her zaman buradayız. Çiçek siparişleriniz için bize ulaşın!')); ?></p>
                    <div class="row justify-content-center">
                        <div class="col-md-4 mb-3">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="bi bi-telephone-fill me-2"></i>
                                <span><?php echo e(\App\Models\Setting::get('footer_contact_phone', '+90 (212) 123 45 67')); ?></span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="bi bi-envelope-fill me-2"></i>
                                <span><?php echo e(\App\Models\Setting::get('footer_contact_email', 'info@cicekbahcesi.com')); ?></span>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="bi bi-geo-alt-fill me-2"></i>
                                <span><?php echo e(\App\Models\Setting::get('footer_contact_address', 'İstanbul, Türkiye')); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-light btn-lg">
                            <i class="bi bi-flower1 me-2"></i>Ürünlerimizi İnceleyin
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/about.blade.php ENDPATH**/ ?>