<?php $__env->startSection('title', 'Ana Sayfa'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Slider -->
<?php if($sliders->count() > 0): ?>
<div id="heroCarousel" class="carousel slide mb-5 position-relative hero-carousel-enhanced" data-bs-ride="carousel" data-bs-interval="8000">
    <div class="carousel-inner rounded-4 overflow-hidden shadow-lg">
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="carousel-item <?php echo e($index === 0 ? 'active' : ''); ?>" data-slide-index="<?php echo e($index); ?>">
            <div class="hero-slide position-relative" style="height: 500px;">
                <!-- Main Background -->
                <div class="hero-background position-absolute w-100 h-100">
                    <!-- Animated Gradient Overlay -->
                    <div class="gradient-overlay position-absolute w-100 h-100 animated-gradient"
                         style="background: linear-gradient(135deg, <?php echo e($slider->background_color); ?>f0 0%, <?php echo e($slider->background_color); ?>cc 50%, <?php echo e($slider->background_color); ?>99 100%);">
                    </div>

                    <!-- Background Image with Ken Burns Effect -->
                    <?php if($slider->image_url): ?>
                    <div class="bg-image position-absolute w-100 h-100 ken-burns-effect"
                         style="background-image: url('<?php echo e($slider->image_url); ?>');
                                background-size: cover;
                                background-position: center;
                                opacity: 0.4;">
                    </div>
                    <?php endif; ?>

                    <!-- Dynamic Light Effects -->
                    <div class="light-effects position-absolute w-100 h-100">
                        <div class="light-beam light-beam-1"></div>
                        <div class="light-beam light-beam-2"></div>
                        <div class="light-beam light-beam-3"></div>
                    </div>
                </div>

                <!-- Enhanced Decorative Elements -->
                <div class="decorative-elements position-absolute w-100 h-100 overflow-hidden">
                    <!-- Enhanced Floating Shapes -->
                    <div class="floating-shape shape-1 enhanced-shape"></div>
                    <div class="floating-shape shape-2 enhanced-shape"></div>
                    <div class="floating-shape shape-3 enhanced-shape"></div>

                    <!-- Enhanced Particle Effects -->
                    <div class="particles">
                        <div class="particle particle-1 pulse-particle"></div>
                        <div class="particle particle-2 float-particle"></div>
                        <div class="particle particle-3 rotate-particle"></div>
                        <div class="particle particle-4 bounce-particle"></div>
                        <div class="particle particle-5 fade-particle"></div>
                        <div class="particle particle-6 scale-particle"></div>
                        <div class="particle particle-7 drift-particle"></div>
                        <div class="particle particle-8 spin-particle"></div>
                    </div>

                    <!-- Floating Icons -->
                    <div class="floating-icons">
                        <i class="bi bi-flower1 floating-icon icon-1"></i>
                        <i class="bi bi-heart floating-icon icon-2"></i>
                        <i class="bi bi-star floating-icon icon-3"></i>
                        <i class="bi bi-gem floating-icon icon-4"></i>
                    </div>
                </div>

                <!-- Content -->
                <div class="container h-100 position-relative" style="z-index: 10;">
                    <div class="row h-100 align-items-center">
                        <div class="col-lg-6 col-xl-7">
                            <div class="hero-content text-start" style="color: <?php echo e($slider->text_color); ?>;">
                                <!-- Badge -->
                                <div class="hero-badge mb-3 fade-in-up" style="animation-delay: 0.1s;">
                                    <span class="badge rounded-pill px-4 py-2"
                                          style="background: rgba(255,255,255,0.15);
                                                 color: <?php echo e($slider->text_color); ?>;
                                                 backdrop-filter: blur(10px);
                                                 border: 1px solid rgba(255,255,255,0.2);">
                                        <i class="bi bi-sparkles me-2"></i>Özel Koleksiyon
                                    </span>
                                </div>

                                <!-- Title -->
                                <h1 class="hero-title display-4 fw-bold mb-4 fade-in-up" style="animation-delay: 0.2s;">
                                    <?php echo e($slider->title); ?>

                                </h1>

                                <!-- Description -->
                                <?php if($slider->description): ?>
                                <p class="hero-description fs-5 mb-4 fade-in-up" style="animation-delay: 0.3s; opacity: 0.95;">
                                    <?php echo e($slider->description); ?>

                                </p>
                                <?php endif; ?>

                                <!-- Actions -->
                                <?php if($slider->button_text && $slider->button_link): ?>
                                <div class="hero-actions fade-in-up" style="animation-delay: 0.4s;">
                                    <a href="<?php echo e($slider->button_link); ?>" class="btn btn-hero btn-lg px-5 py-3 me-3 mb-2">
                                        <i class="bi bi-flower1 me-2"></i><?php echo e($slider->button_text); ?>

                                    </a>
                                    <a href="#stories" class="btn btn-outline-hero btn-lg px-4 py-3 mb-2">
                                        <i class="bi bi-arrow-down me-2"></i>Keşfet
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Visual Side -->
                        <div class="col-lg-6 col-xl-5 text-center d-none d-lg-block">
                            <div class="hero-visual position-relative">
                                <!-- Animated Circles -->
                                <div class="visual-circle circle-1"></div>
                                <div class="visual-circle circle-2"></div>
                                <div class="visual-circle circle-3"></div>

                                <!-- Main Icon -->
                                <div class="main-visual fade-in-scale" style="animation-delay: 0.5s;">
                                    <i class="bi bi-flower2" style="font-size: 8rem; color: <?php echo e($slider->text_color); ?>; opacity: 0.9;"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Custom Navigation -->
    <?php if($sliders->count() > 1): ?>
    <div class="hero-navigation">
        <!-- Previous Button -->
        <button class="hero-nav-btn hero-nav-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
            <i class="bi bi-chevron-left"></i>
        </button>

        <!-- Next Button -->
        <button class="hero-nav-btn hero-nav-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
            <i class="bi bi-chevron-right"></i>
        </button>

        <!-- Indicators -->
        <div class="hero-indicators">
            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <button type="button"
                    data-bs-target="#heroCarousel"
                    data-bs-slide-to="<?php echo e($index); ?>"
                    class="hero-indicator <?php echo e($index === 0 ? 'active' : ''); ?>"
                    aria-label="Slide <?php echo e($index + 1); ?>">
            </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php endif; ?>

<!-- Stories Section -->
<?php if($stories->count() > 0): ?>
<div class="container mb-5">
    <div class="row">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <h2 class="fw-bold text-primary mb-0">
                    <i class="bi bi-collection-play me-2"></i>Öne Çıkanlar
                </h2>
                <div class="d-flex align-items-center">
                    <button class="btn btn-outline-primary btn-sm me-2" id="stories-prev">
                        <i class="bi bi-chevron-left"></i>
                    </button>
                    <button class="btn btn-outline-primary btn-sm" id="stories-next">
                        <i class="bi bi-chevron-right"></i>
                    </button>
                </div>
            </div>

            <div class="stories-container position-relative">
                <!-- Navigation Buttons -->
                <button class="story-nav-btn story-nav-prev position-absolute start-0 top-50 translate-middle-y bg-white border-0 rounded-circle shadow-sm d-none"
                        style="width: 40px; height: 40px; z-index: 10;" id="story-prev-btn">
                    <i class="bi bi-chevron-left text-primary"></i>
                </button>
                <button class="story-nav-btn story-nav-next position-absolute end-0 top-50 translate-middle-y bg-white border-0 rounded-circle shadow-sm"
                        style="width: 40px; height: 40px; z-index: 10;" id="story-next-btn">
                    <i class="bi bi-chevron-right text-primary"></i>
                </button>

                <div class="stories-wrapper d-flex gap-3 overflow-hidden" id="stories-wrapper" style="scroll-behavior: smooth;">
                    <?php $__currentLoopData = $stories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="story-item flex-shrink-0" style="width: 120px;">
                        <a href="<?php echo e(route('story.show', $story)); ?>" class="text-decoration-none story-link"
                           data-story-id="<?php echo e($story->id); ?>">
                            <div class="story-circle position-relative mb-2">
                                <!-- Story Ring -->
                                <div class="story-ring position-absolute w-100 h-100 rounded-circle"
                                     style="background: linear-gradient(45deg, <?php echo e($story->background_color); ?>, <?php echo e($story->background_color); ?>80); padding: 3px;">
                                    <div class="story-inner position-relative w-100 h-100 rounded-circle overflow-hidden bg-white"
                                         style="padding: 2px;">
                                        <!-- Story Image -->
                                        <div class="story-image w-100 h-100 rounded-circle overflow-hidden position-relative"
                                             style="background: linear-gradient(135deg, <?php echo e($story->background_color); ?>, <?php echo e($story->background_color); ?>dd);">
                                            <?php if($story->image): ?>
                                            <img src="<?php echo e($story->image_url); ?>"
                                                 alt="<?php echo e($story->title); ?>"
                                                 class="w-100 h-100"
                                                 style="object-fit: cover; opacity: 0.8;">
                                            <?php endif; ?>

                                            <!-- Story Content Overlay -->
                                            <div class="position-absolute w-100 h-100 d-flex flex-column justify-content-center align-items-center text-center p-2 top-0"
                                                 style="background: linear-gradient(135deg, <?php echo e($story->background_color); ?>40, <?php echo e($story->background_color); ?>80);">
                                                <div class="story-text" style="color: <?php echo e($story->text_color); ?>;">
                                                    <div class="fw-bold" style="font-size: 0.7rem; line-height: 1;">
                                                        <?php echo e(Str::limit($story->title, 15)); ?>

                                                    </div>
                                                    <?php if($story->description): ?>
                                                    <div style="font-size: 0.6rem; line-height: 1; opacity: 0.9;">
                                                        <?php echo e(Str::limit($story->description, 20)); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Story Title -->
                            <div class="text-center">
                                <small class="text-muted fw-medium" style="font-size: 0.75rem;">
                                    <?php echo e(Str::limit($story->title, 12)); ?>

                                </small>
                            </div>
                        </a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Categories Section -->
<div class="container mb-5">
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="display-5 fw-bold text-primary mb-3">Kategoriler</h2>
            <p class="lead text-muted">İhtiyacınıza uygun çiçek kategorisini seçin</p>
        </div>
    </div>
    
    <div class="row g-4">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4 col-md-6">
            <div class="card category-card h-100 border-0 shadow-sm">
                <div class="position-relative">
                    <?php if($category->image): ?>
                        <img src="<?php echo e(asset('storage/' . $category->image)); ?>"
                             alt="<?php echo e($category->name); ?>"
                             class="card-img-top"
                             style="height: 200px; object-fit: cover;">
                        <div class="position-absolute top-0 start-0 w-100 h-100"
                             style="background: linear-gradient(135deg, <?php echo e($category->color); ?>40, transparent);"></div>
                    <?php else: ?>
                        <div class="card-img-top d-flex align-items-center justify-content-center"
                             style="height: 200px; background: linear-gradient(135deg, <?php echo e($category->color); ?>20, #FFF);">
                            <i class="<?php echo e($category->icon); ?>" style="font-size: 4rem; color: <?php echo e($category->color); ?>;"></i>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-body text-center p-4">
                    <h5 class="card-title fw-bold"><?php echo e($category->name); ?></h5>
                    <p class="card-text text-muted"><?php echo e($category->description); ?></p>
                    <a href="<?php echo e(route('categories.show', $category->slug)); ?>" class="btn" style="background-color: <?php echo e($category->color); ?>; color: white;">İncele</a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<!-- Featured Products Section -->
<div class="bg-light py-5">
    <div class="container">
        <div class="row mb-4">
            <div class="col-12 text-center">
                <h2 class="display-5 fw-bold text-primary mb-3">Öne Çıkan Ürünler</h2>
                <p class="lead text-muted">En çok tercih edilen çiçeklerimiz</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="position-relative">
                        <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="text-decoration-none">
                            <?php if($product->image): ?>
                                <img src="<?php echo e(asset('storage/' . $product->image)); ?>"
                                     alt="<?php echo e($product->name); ?>"
                                     class="card-img-top"
                                     style="height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-gradient p-5 text-center" style="background: linear-gradient(135deg, <?php echo e($product->category->color); ?>20, #E1F5FE); height: 200px;">
                                    <i class="<?php echo e($product->category->icon); ?> text-primary" style="font-size: 4rem; color: <?php echo e($product->category->color); ?>;"></i>
                                </div>
                            <?php endif; ?>
                        </a>
                        <?php if($product->discount_price): ?>
                        <span class="position-absolute top-0 end-0 badge bg-danger m-2">
                            -<?php echo e(number_format((($product->price - $product->discount_price) / $product->price) * 100, 0)); ?>%
                        </span>
                        <?php endif; ?>
                        <?php if($product->stock_quantity <= 5): ?>
                        <span class="position-absolute top-0 start-0 badge bg-warning m-2">Son <?php echo e($product->stock_quantity); ?> adet!</span>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="text-decoration-none">
                            <h6 class="card-title fw-bold text-dark"><?php echo e($product->name); ?></h6>
                        </a>
                        <p class="card-text text-muted small"><?php echo e($product->description ? Str::limit($product->description, 60) : $product->short_description); ?></p>
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <?php if($product->discount_price): ?>
                                <span class="text-decoration-line-through text-muted small">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                <span class="fw-bold text-primary ms-2">₺<?php echo e(number_format($product->discount_price, 2)); ?></span>
                                <?php else: ?>
                                <span class="fw-bold text-primary">₺<?php echo e(number_format($product->price, 2)); ?></span>
                                <?php endif; ?>
                            </div>
                            <form action="<?php echo e(route('cart.add', $product->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="quantity" value="1">
                                <button type="submit" class="btn btn-primary btn-sm" <?php echo e(!$product->in_stock ? 'disabled' : ''); ?>>
                                    <i class="bi bi-bag-plus"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div class="text-center mt-4">
            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary btn-lg">
                Tüm Ürünleri Gör <i class="bi bi-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</div>

<!-- Features Section -->
<div class="container py-5">
    <div class="row g-4">
        <div class="col-lg-3 col-md-6 text-center">
            <div class="p-4">
                <i class="bi bi-truck text-primary mb-3" style="font-size: 3rem;"></i>
                <h5 class="fw-bold">Hızlı Teslimat</h5>
                <p class="text-muted">Aynı gün teslimat imkanı</p>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 text-center">
            <div class="p-4">
                <i class="bi bi-shield-check text-success mb-3" style="font-size: 3rem;"></i>
                <h5 class="fw-bold">Güvenli Alışveriş</h5>
                <p class="text-muted">SSL sertifikası ile güvenli ödeme</p>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 text-center">
            <div class="p-4">
                <i class="bi bi-flower1 text-warning mb-3" style="font-size: 3rem;"></i>
                <h5 class="fw-bold">Taze Çiçekler</h5>
                <p class="text-muted">Her gün taze çiçek tedariki</p>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 text-center">
            <div class="p-4">
                <i class="bi bi-headset text-info mb-3" style="font-size: 3rem;"></i>
                <h5 class="fw-bold">7/24 Destek</h5>
                <p class="text-muted">Müşteri hizmetleri desteği</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('styles'); ?>
<style>
/* Enhanced Hero Slider Styles */
#heroCarousel {
    margin-bottom: 3rem;
}

.hero-carousel-enhanced {
    position: relative;
    overflow: hidden;
}

.hero-slide {
    position: relative;
    overflow: hidden;
}

.hero-background {
    z-index: 1;
}

/* Enhanced Gradient Animation */
.animated-gradient {
    animation: gradientPulse 12s ease-in-out infinite;
    background-size: 200% 200%;
}

@keyframes gradientPulse {
    0%, 100% {
        opacity: 1;
        background-position: 0% 50%;
    }
    25% {
        opacity: 0.95;
        background-position: 100% 50%;
    }
    50% {
        opacity: 0.9;
        background-position: 100% 100%;
    }
    75% {
        opacity: 0.95;
        background-position: 0% 100%;
    }
}

/* Ken Burns Effect for Background Images */
.ken-burns-effect {
    transition: transform 15s ease-in-out;
    z-index: 0;
    animation: kenBurns 20s ease-in-out infinite;
}

@keyframes kenBurns {
    0% {
        transform: scale(1) rotate(0deg);
        filter: brightness(1) saturate(1);
    }
    25% {
        transform: scale(1.08) rotate(0.5deg);
        filter: brightness(1.1) saturate(1.1);
    }
    50% {
        transform: scale(1.15) rotate(0deg);
        filter: brightness(1.05) saturate(1.2);
    }
    75% {
        transform: scale(1.08) rotate(-0.5deg);
        filter: brightness(1.1) saturate(1.1);
    }
    100% {
        transform: scale(1) rotate(0deg);
        filter: brightness(1) saturate(1);
    }
}

.carousel-item.active .ken-burns-effect {
    animation-play-state: running;
}

/* Dynamic Light Effects */
.light-effects {
    z-index: 2;
    pointer-events: none;
}

.light-beam {
    position: absolute;
    background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
    border-radius: 50%;
    filter: blur(2px);
}

.light-beam-1 {
    width: 200px;
    height: 200px;
    top: 10%;
    left: 20%;
    animation: lightMove1 15s ease-in-out infinite;
}

.light-beam-2 {
    width: 150px;
    height: 150px;
    top: 60%;
    right: 15%;
    animation: lightMove2 18s ease-in-out infinite;
    animation-delay: 5s;
}

.light-beam-3 {
    width: 100px;
    height: 100px;
    bottom: 20%;
    left: 10%;
    animation: lightMove3 12s ease-in-out infinite;
    animation-delay: 8s;
}

@keyframes lightMove1 {
    0%, 100% {
        transform: translate(0, 0) scale(1);
        opacity: 0.3;
    }
    50% {
        transform: translate(50px, -30px) scale(1.2);
        opacity: 0.6;
    }
}

@keyframes lightMove2 {
    0%, 100% {
        transform: translate(0, 0) scale(1);
        opacity: 0.2;
    }
    50% {
        transform: translate(-40px, 40px) scale(1.3);
        opacity: 0.5;
    }
}

@keyframes lightMove3 {
    0%, 100% {
        transform: translate(0, 0) scale(1);
        opacity: 0.4;
    }
    50% {
        transform: translate(30px, -50px) scale(1.1);
        opacity: 0.7;
    }
}

/* Enhanced Decorative Elements */
.decorative-elements {
    z-index: 2;
    pointer-events: none;
}

.floating-shape {
    position: absolute;
    border-radius: 50%;
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(5px);
    border: 1px solid rgba(255,255,255,0.2);
}

.enhanced-shape {
    box-shadow: 0 0 20px rgba(255,255,255,0.3);
    animation-duration: 12s !important;
}

.shape-1 {
    width: 120px;
    height: 120px;
    top: 10%;
    right: 15%;
    animation: floatShapeEnhanced1 12s ease-in-out infinite;
}

.shape-2 {
    width: 80px;
    height: 80px;
    top: 70%;
    right: 25%;
    animation: floatShapeEnhanced2 10s ease-in-out infinite reverse;
    animation-delay: 3s;
}

.shape-3 {
    width: 100px;
    height: 100px;
    top: 40%;
    right: 5%;
    animation: floatShapeEnhanced3 14s ease-in-out infinite;
    animation-delay: 6s;
}

@keyframes floatShapeEnhanced1 {
    0%, 100% {
        transform: translate(0, 0) rotate(0deg) scale(1);
        opacity: 0.6;
    }
    25% {
        transform: translate(20px, -30px) rotate(90deg) scale(1.1);
        opacity: 0.8;
    }
    50% {
        transform: translate(-10px, -50px) rotate(180deg) scale(0.9);
        opacity: 0.4;
    }
    75% {
        transform: translate(-30px, -20px) rotate(270deg) scale(1.2);
        opacity: 0.7;
    }
}

@keyframes floatShapeEnhanced2 {
    0%, 100% {
        transform: translate(0, 0) rotate(0deg) scale(1);
        opacity: 0.5;
    }
    33% {
        transform: translate(-25px, 20px) rotate(120deg) scale(1.3);
        opacity: 0.8;
    }
    66% {
        transform: translate(15px, -15px) rotate(240deg) scale(0.8);
        opacity: 0.3;
    }
}

@keyframes floatShapeEnhanced3 {
    0%, 100% {
        transform: translate(0, 0) rotate(0deg) scale(1);
        opacity: 0.7;
    }
    20% {
        transform: translate(30px, -20px) rotate(72deg) scale(1.1);
        opacity: 0.9;
    }
    40% {
        transform: translate(-20px, -40px) rotate(144deg) scale(0.9);
        opacity: 0.4;
    }
    60% {
        transform: translate(-40px, 10px) rotate(216deg) scale(1.2);
        opacity: 0.6;
    }
    80% {
        transform: translate(10px, 30px) rotate(288deg) scale(0.8);
        opacity: 0.8;
    }
}

@keyframes floatShape {
    0%, 100% { transform: translateY(0px) rotate(0deg); opacity: 0.3; }
    33% { transform: translateY(-20px) rotate(120deg); opacity: 0.6; }
    66% { transform: translateY(10px) rotate(240deg); opacity: 0.4; }
}

/* Enhanced Particles */
.particles {
    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 3;
}

.particle {
    position: absolute;
    background: rgba(255,255,255,0.7);
    border-radius: 50%;
    box-shadow: 0 0 10px rgba(255,255,255,0.5);
}

/* Different Particle Animations */
.pulse-particle {
    width: 6px;
    height: 6px;
    top: 15%;
    left: 12%;
    animation: pulseFloat 8s ease-in-out infinite;
}

.float-particle {
    width: 4px;
    height: 4px;
    top: 65%;
    left: 85%;
    animation: gentleFloat 12s linear infinite;
    animation-delay: 2s;
}

.rotate-particle {
    width: 8px;
    height: 8px;
    top: 25%;
    left: 75%;
    animation: rotateFloat 10s linear infinite;
    animation-delay: 4s;
}

.bounce-particle {
    width: 5px;
    height: 5px;
    top: 75%;
    left: 25%;
    animation: bounceFloat 6s ease-in-out infinite;
    animation-delay: 1s;
}

.fade-particle {
    width: 7px;
    height: 7px;
    top: 45%;
    left: 45%;
    animation: fadeFloat 14s ease-in-out infinite;
    animation-delay: 3s;
}

.scale-particle {
    width: 3px;
    height: 3px;
    top: 35%;
    left: 15%;
    animation: scaleFloat 9s ease-in-out infinite;
    animation-delay: 5s;
}

.drift-particle {
    width: 6px;
    height: 6px;
    top: 55%;
    left: 65%;
    animation: driftFloat 16s linear infinite;
    animation-delay: 7s;
}

.spin-particle {
    width: 4px;
    height: 4px;
    top: 85%;
    left: 55%;
    animation: spinFloat 11s linear infinite;
    animation-delay: 6s;
}

/* Particle Animation Keyframes */
@keyframes pulseFloat {
    0%, 100% {
        transform: translateY(0px) scale(1);
        opacity: 0.7;
    }
    50% {
        transform: translateY(-80px) scale(1.5);
        opacity: 1;
    }
}

@keyframes gentleFloat {
    0% {
        transform: translate(0, 0) rotate(0deg);
        opacity: 0;
    }
    10%, 90% {
        opacity: 0.8;
    }
    100% {
        transform: translate(50px, -120px) rotate(180deg);
        opacity: 0;
    }
}

@keyframes rotateFloat {
    0% {
        transform: translate(0, 0) rotate(0deg);
        opacity: 0.6;
    }
    100% {
        transform: translate(-60px, -100px) rotate(720deg);
        opacity: 0;
    }
}

@keyframes bounceFloat {
    0%, 100% {
        transform: translateY(0px);
        opacity: 0.5;
    }
    25% {
        transform: translateY(-40px);
        opacity: 1;
    }
    50% {
        transform: translateY(-80px);
        opacity: 0.8;
    }
    75% {
        transform: translateY(-60px);
        opacity: 0.9;
    }
}

@keyframes fadeFloat {
    0%, 100% {
        transform: translateY(0px);
        opacity: 0;
    }
    20%, 80% {
        opacity: 1;
    }
    50% {
        transform: translateY(-90px);
        opacity: 0.3;
    }
}

@keyframes scaleFloat {
    0% {
        transform: scale(0) translateY(0px);
        opacity: 0;
    }
    20% {
        transform: scale(1) translateY(-20px);
        opacity: 1;
    }
    80% {
        transform: scale(2) translateY(-70px);
        opacity: 0.6;
    }
    100% {
        transform: scale(0) translateY(-100px);
        opacity: 0;
    }
}

@keyframes driftFloat {
    0% {
        transform: translate(0, 0);
        opacity: 0.4;
    }
    25% {
        transform: translate(30px, -30px);
        opacity: 0.8;
    }
    50% {
        transform: translate(-20px, -60px);
        opacity: 1;
    }
    75% {
        transform: translate(40px, -90px);
        opacity: 0.6;
    }
    100% {
        transform: translate(-10px, -120px);
        opacity: 0;
    }
}

@keyframes spinFloat {
    0% {
        transform: rotate(0deg) translateY(0px);
        opacity: 0.7;
    }
    100% {
        transform: rotate(1080deg) translateY(-110px);
        opacity: 0;
    }
}

/* Floating Icons */
.floating-icons {
    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 4;
    pointer-events: none;
}

.floating-icon {
    position: absolute;
    color: rgba(255,255,255,0.6);
    font-size: 1.5rem;
    text-shadow: 0 0 10px rgba(255,255,255,0.8);
}

.icon-1 {
    top: 20%;
    left: 20%;
    animation: iconFloat1 18s ease-in-out infinite;
}

.icon-2 {
    top: 60%;
    right: 20%;
    animation: iconFloat2 15s ease-in-out infinite;
    animation-delay: 4s;
}

.icon-3 {
    bottom: 30%;
    left: 15%;
    animation: iconFloat3 20s ease-in-out infinite;
    animation-delay: 8s;
}

.icon-4 {
    top: 40%;
    right: 10%;
    animation: iconFloat4 12s ease-in-out infinite;
    animation-delay: 2s;
}

@keyframes iconFloat1 {
    0%, 100% {
        transform: translate(0, 0) rotate(0deg) scale(1);
        opacity: 0.4;
    }
    25% {
        transform: translate(20px, -20px) rotate(90deg) scale(1.2);
        opacity: 0.8;
    }
    50% {
        transform: translate(-10px, -40px) rotate(180deg) scale(0.8);
        opacity: 0.6;
    }
    75% {
        transform: translate(-30px, -10px) rotate(270deg) scale(1.1);
        opacity: 0.7;
    }
}

@keyframes iconFloat2 {
    0%, 100% {
        transform: translate(0, 0) scale(1);
        opacity: 0.5;
    }
    50% {
        transform: translate(-25px, 30px) scale(1.3);
        opacity: 0.9;
    }
}

@keyframes iconFloat3 {
    0%, 100% {
        transform: translate(0, 0) rotate(0deg);
        opacity: 0.3;
    }
    33% {
        transform: translate(30px, -15px) rotate(120deg);
        opacity: 0.8;
    }
    66% {
        transform: translate(-15px, -30px) rotate(240deg);
        opacity: 0.6;
    }
}

@keyframes iconFloat4 {
    0%, 100% {
        transform: translate(0, 0) scale(1) rotate(0deg);
        opacity: 0.6;
    }
    20% {
        transform: translate(15px, -25px) scale(1.1) rotate(72deg);
        opacity: 0.9;
    }
    40% {
        transform: translate(-20px, -35px) scale(0.9) rotate(144deg);
        opacity: 0.4;
    }
    60% {
        transform: translate(-25px, 5px) scale(1.2) rotate(216deg);
        opacity: 0.7;
    }
    80% {
        transform: translate(10px, 20px) scale(0.8) rotate(288deg);
        opacity: 0.8;
    }
}

/* Content Animations */
.fade-in-up {
    opacity: 0;
    transform: translateY(30px);
    animation: fadeInUp 1s ease-out forwards;
}

.fade-in-scale {
    opacity: 0;
    transform: scale(0.8);
    animation: fadeInScale 1s ease-out forwards;
}

@keyframes fadeInUp {
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeInScale {
    to {
        opacity: 1;
        transform: scale(1);
    }
}

/* Typography */
.hero-title {
    text-shadow: 2px 2px 8px rgba(0,0,0,0.3);
    line-height: 1.2;
    font-weight: 700;
}

.hero-description {
    text-shadow: 1px 1px 4px rgba(0,0,0,0.2);
    line-height: 1.6;
}

/* Buttons */
.btn-hero {
    background: rgba(255,255,255,0.95);
    color: #333;
    border: none;
    border-radius: 50px;
    font-weight: 600;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    backdrop-filter: blur(10px);
}

.btn-hero:hover {
    background: white;
    color: #333;
    transform: translateY(-3px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.25);
}

.btn-outline-hero {
    border: 2px solid rgba(255,255,255,0.8);
    color: white;
    background: rgba(255,255,255,0.1);
    border-radius: 50px;
    font-weight: 600;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.btn-outline-hero:hover {
    background: rgba(255,255,255,0.2);
    border-color: white;
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 8px 30px rgba(255,255,255,0.2);
}

/* Hero Visual */
.hero-visual {
    position: relative;
    height: 400px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.visual-circle {
    position: absolute;
    border-radius: 50%;
    border: 2px solid rgba(255,255,255,0.2);
    background: rgba(255,255,255,0.05);
}

.circle-1 {
    width: 300px;
    height: 300px;
    animation: rotateClockwise 20s linear infinite;
}

.circle-2 {
    width: 200px;
    height: 200px;
    animation: rotateCounterClockwise 15s linear infinite;
}

.circle-3 {
    width: 100px;
    height: 100px;
    animation: rotateClockwise 10s linear infinite;
}

@keyframes rotateClockwise {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

@keyframes rotateCounterClockwise {
    from { transform: rotate(360deg); }
    to { transform: rotate(0deg); }
}

.main-visual {
    position: relative;
    z-index: 5;
    animation: iconPulse 4s ease-in-out infinite;
}

@keyframes iconPulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

/* Navigation */
.hero-navigation {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
    z-index: 15;
}

.hero-nav-btn {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: rgba(255,255,255,0.9);
    border: none;
    color: #333;
    font-size: 1.2rem;
    transition: all 0.3s ease;
    pointer-events: all;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    backdrop-filter: blur(10px);
}

.hero-nav-prev {
    left: 20px;
}

.hero-nav-next {
    right: 20px;
}

.hero-nav-btn:hover {
    background: white;
    transform: translateY(-50%) scale(1.1);
    box-shadow: 0 6px 25px rgba(0,0,0,0.2);
}

.hero-nav-btn:active {
    transform: translateY(-50%) scale(0.95);
}

/* Indicators */
.hero-indicators {
    position: absolute;
    bottom: 20px;
    left: 50%;
    transform: translateX(-50%);
    display: flex;
    gap: 8px;
    pointer-events: all;
}

.hero-indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid rgba(255,255,255,0.6);
    background: transparent;
    transition: all 0.3s ease;
    cursor: pointer;
}

.hero-indicator.active,
.hero-indicator:hover {
    background: white;
    border-color: white;
    transform: scale(1.2);
}

/* Responsive Design */
@media (max-width: 992px) {
    .hero-slide {
        height: 450px !important;
    }

    .hero-title {
        font-size: 2.5rem !important;
    }

    .hero-visual {
        height: 300px;
    }

    .main-visual i {
        font-size: 6rem !important;
    }

    .visual-circle {
        display: none;
    }
}

@media (max-width: 768px) {
    .hero-slide {
        height: 400px !important;
    }

    .hero-title {
        font-size: 2rem !important;
    }

    .hero-description {
        font-size: 1rem !important;
    }

    .hero-actions .btn {
        display: block;
        width: 100%;
        margin-bottom: 0.5rem;
    }

    .hero-nav-btn {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }

    .hero-nav-prev {
        left: 10px;
    }

    .hero-nav-next {
        right: 10px;
    }

    .decorative-elements {
        display: none;
    }
}

@media (max-width: 576px) {
    .hero-slide {
        height: 350px !important;
    }

    .hero-title {
        font-size: 1.75rem !important;
    }

    .hero-description {
        font-size: 0.9rem !important;
    }

    .hero-indicators {
        bottom: 10px;
    }

    .hero-indicator {
        width: 8px;
        height: 8px;
    }
}

/* Story Styles */
.story-circle {
    width: 100px;
    height: 100px;
    cursor: pointer;
    transition: transform 0.3s ease;
}

.story-circle:hover {
    transform: scale(1.05);
}

.story-ring {
    animation: story-pulse 2s infinite;
}

@keyframes story-pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.02); }
    100% { transform: scale(1); }
}

.story-link:hover .story-circle {
    transform: scale(1.1);
}

.stories-container {
    overflow: hidden;
}

.stories-wrapper {
    transition: transform 0.3s ease;
    scroll-behavior: smooth;
}

.story-item {
    min-width: 120px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .story-circle {
        width: 80px;
        height: 80px;
    }

    .story-item {
        min-width: 100px;
        width: 100px !important;
    }

    .story-text .fw-bold {
        font-size: 0.6rem !important;
    }

    .story-text div:last-child {
        font-size: 0.5rem !important;
    }
}

@media (max-width: 576px) {
    .story-circle {
        width: 70px;
        height: 70px;
    }

    .story-item {
        min-width: 85px;
        width: 85px !important;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Enhanced Hero Carousel
    const heroCarousel = document.getElementById('heroCarousel');
    if (heroCarousel) {
        const carousel = new bootstrap.Carousel(heroCarousel, {
            interval: 8000,
            wrap: true,
            touch: true
        });

        // Add slide transition effects
        heroCarousel.addEventListener('slide.bs.carousel', function (e) {
            const activeSlide = e.target.querySelector('.carousel-item.active');
            const nextSlide = e.relatedTarget;

            // Add entrance animation to next slide
            if (nextSlide) {
                const content = nextSlide.querySelector('.hero-content');
                if (content) {
                    content.style.opacity = '0';
                    content.style.transform = 'translateY(50px)';
                }
            }
        });

        heroCarousel.addEventListener('slid.bs.carousel', function (e) {
            const activeSlide = e.target.querySelector('.carousel-item.active');

            // Animate content entrance
            if (activeSlide) {
                const content = activeSlide.querySelector('.hero-content');
                if (content) {
                    setTimeout(() => {
                        content.style.transition = 'all 1s ease-out';
                        content.style.opacity = '1';
                        content.style.transform = 'translateY(0)';
                    }, 200);
                }

                // Restart particle animations
                const particles = activeSlide.querySelectorAll('.particle');
                particles.forEach((particle, index) => {
                    particle.style.animation = 'none';
                    setTimeout(() => {
                        particle.style.animation = '';
                    }, index * 100);
                });

                // Restart floating icon animations
                const icons = activeSlide.querySelectorAll('.floating-icon');
                icons.forEach((icon, index) => {
                    icon.style.animation = 'none';
                    setTimeout(() => {
                        icon.style.animation = '';
                    }, index * 200);
                });
            }
        });

        // Add parallax effect on mouse move
        heroCarousel.addEventListener('mousemove', function(e) {
            const rect = this.getBoundingClientRect();
            const x = (e.clientX - rect.left) / rect.width;
            const y = (e.clientY - rect.top) / rect.height;

            const activeSlide = this.querySelector('.carousel-item.active');
            if (activeSlide) {
                const shapes = activeSlide.querySelectorAll('.floating-shape');
                shapes.forEach((shape, index) => {
                    const moveX = (x - 0.5) * (15 + index * 8);
                    const moveY = (y - 0.5) * (15 + index * 8);
                    shape.style.transform = `translate(${moveX}px, ${moveY}px)`;
                });

                const lightBeams = activeSlide.querySelectorAll('.light-beam');
                lightBeams.forEach((beam, index) => {
                    const moveX = (x - 0.5) * (8 + index * 4);
                    const moveY = (y - 0.5) * (8 + index * 4);
                    beam.style.transform = `translate(${moveX}px, ${moveY}px)`;
                });
            }
        });
    }

    // Stories functionality
    const storiesWrapper = document.getElementById('stories-wrapper');
    const prevBtn = document.getElementById('story-prev-btn');
    const nextBtn = document.getElementById('story-next-btn');

    if (storiesWrapper && prevBtn && nextBtn) {

    const storyItems = storiesWrapper.querySelectorAll('.story-item');
    const itemWidth = 120 + 12; // width + gap
    const visibleItems = Math.floor(storiesWrapper.parentElement.offsetWidth / itemWidth);
    const maxScroll = Math.max(0, (storyItems.length - visibleItems) * itemWidth);

    let currentScroll = 0;

    function updateButtons() {
        if (currentScroll <= 0) {
            prevBtn.classList.add('d-none');
        } else {
            prevBtn.classList.remove('d-none');
        }

        if (currentScroll >= maxScroll) {
            nextBtn.classList.add('d-none');
        } else {
            nextBtn.classList.remove('d-none');
        }
    }

    function scrollStories(direction) {
        const scrollAmount = itemWidth * 3; // Scroll 3 items at a time

        if (direction === 'next' && currentScroll < maxScroll) {
            currentScroll = Math.min(currentScroll + scrollAmount, maxScroll);
        } else if (direction === 'prev' && currentScroll > 0) {
            currentScroll = Math.max(currentScroll - scrollAmount, 0);
        }

        storiesWrapper.style.transform = `translateX(-${currentScroll}px)`;
        updateButtons();
    }

    prevBtn.addEventListener('click', () => scrollStories('prev'));
    nextBtn.addEventListener('click', () => scrollStories('next'));

    // Initialize buttons
    updateButtons();

    // Handle window resize
    window.addEventListener('resize', function() {
        const newVisibleItems = Math.floor(storiesWrapper.parentElement.offsetWidth / itemWidth);
        const newMaxScroll = Math.max(0, (storyItems.length - newVisibleItems) * itemWidth);

        if (currentScroll > newMaxScroll) {
            currentScroll = newMaxScroll;
            storiesWrapper.style.transform = `translateX(-${currentScroll}px)`;
        }

        updateButtons();
    });

    // Touch/swipe support for mobile
    let startX = 0;
    let isDragging = false;

    storiesWrapper.addEventListener('touchstart', function(e) {
        startX = e.touches[0].clientX;
        isDragging = true;
    });

    storiesWrapper.addEventListener('touchmove', function(e) {
        if (!isDragging) return;
        e.preventDefault();
    });

    storiesWrapper.addEventListener('touchend', function(e) {
        if (!isDragging) return;

        const endX = e.changedTouches[0].clientX;
        const diffX = startX - endX;

        if (Math.abs(diffX) > 50) { // Minimum swipe distance
            if (diffX > 0) {
                scrollStories('next');
            } else {
                scrollStories('prev');
            }
        }

        isDragging = false;
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/home.blade.php ENDPATH**/ ?>