<?php $__env->startSection('title', 'Yeni Story Ekle'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.stories.index')); ?>">Story Yönetimi</a></li>
                    <li class="breadcrumb-item active">Yeni Story Ekle</li>
                </ol>
            </nav>
            <h1 class="display-6 fw-bold text-primary mb-2">
                <i class="bi bi-plus-circle me-2"></i>Yeni Story Ekle
            </h1>
            <p class="text-muted mb-0">Instagram benzeri yeni bir story oluşturun</p>
        </div>
    </div>

    <form action="<?php echo e(route('admin.stories.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <!-- Main Story Info -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-info-circle me-2"></i>Temel Bilgiler
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Story Başlığı *</label>
                            <input type="text" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="title" name="title" value="<?php echo e(old('title')); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      id="description" name="description" rows="3"><?php echo e(old('description')); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="type" class="form-label">Story Tipi *</label>
                                <select class="form-select <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="type" name="type" required>
                                    <option value="">Tip Seçin</option>
                                    <option value="product" <?php echo e(old('type') === 'product' ? 'selected' : ''); ?>>Ürün</option>
                                    <option value="category" <?php echo e(old('type') === 'category' ? 'selected' : ''); ?>>Kategori</option>
                                    <option value="custom" <?php echo e(old('type') === 'custom' ? 'selected' : ''); ?>>Özel</option>
                                    <option value="link" <?php echo e(old('type') === 'link' ? 'selected' : ''); ?>>Link</option>
                                </select>
                                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="sort_order" class="form-label">Sıralama</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="sort_order" name="sort_order" value="<?php echo e(old('sort_order', 0)); ?>" min="0">
                                <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Type Specific Fields -->
                <div class="card border-0 shadow-sm mb-4" id="type-fields" style="display: none;">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-link-45deg me-2"></i>Bağlantı Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Product Selection -->
                        <div id="product-field" style="display: none;">
                            <div class="mb-3">
                                <label for="product_id" class="form-label">Ürün Seçin *</label>
                                <select class="form-select <?php $__errorArgs = ['product_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="product_id" name="product_id">
                                    <option value="">Ürün Seçin</option>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($product->id); ?>" <?php echo e(old('product_id') == $product->id ? 'selected' : ''); ?>>
                                            <?php echo e($product->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['product_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Category Selection -->
                        <div id="category-field" style="display: none;">
                            <div class="mb-3">
                                <label for="category_id" class="form-label">Kategori Seçin *</label>
                                <select class="form-select <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="category_id" name="category_id">
                                    <option value="">Kategori Seçin</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e(old('category_id') == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Custom Link -->
                        <div id="link-field" style="display: none;">
                            <div class="mb-3">
                                <label for="custom_link" class="form-label">Özel Link *</label>
                                <input type="url" class="form-control <?php $__errorArgs = ['custom_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="custom_link" name="custom_link" value="<?php echo e(old('custom_link')); ?>" 
                                       placeholder="https://example.com">
                                <?php $__errorArgs = ['custom_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Story Image -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-image me-2"></i>Story Resmi *
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="image" class="form-label">Story Resmi *</label>
                            <input type="file" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="image" name="image" accept="image/*" required>
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">JPG, PNG veya WebP formatında, maksimum 2MB. Önerilen boyut: 400x600px (9:16 oran)</div>
                        </div>
                        
                        <!-- Image Preview -->
                        <div id="image_preview" class="text-center" style="display: none;">
                            <img id="preview_img" src="" alt="Önizleme" class="img-thumbnail" style="max-width: 200px; max-height: 300px;">
                            <br>
                            <button type="button" class="btn btn-outline-danger btn-sm mt-2" id="remove_image">
                                <i class="bi bi-trash me-1"></i>Resmi Kaldır
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Design Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-palette me-2"></i>Tasarım Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="background_color" class="form-label">Arkaplan Rengi</label>
                                <input type="color" class="form-control form-control-color <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="background_color" name="background_color" value="<?php echo e(old('background_color', '#FF6B6B')); ?>">
                                <?php $__errorArgs = ['background_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="text_color" class="form-label">Metin Rengi</label>
                                <input type="color" class="form-control form-control-color <?php $__errorArgs = ['text_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="text_color" name="text_color" value="<?php echo e(old('text_color', '#FFFFFF')); ?>">
                                <?php $__errorArgs = ['text_color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Expiry Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-clock me-2"></i>Süre Ayarları
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="expires_at" class="form-label">Son Geçerlilik Tarihi</label>
                            <input type="datetime-local" class="form-control <?php $__errorArgs = ['expires_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="expires_at" name="expires_at" value="<?php echo e(old('expires_at')); ?>">
                            <?php $__errorArgs = ['expires_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">Boş bırakırsanız story süresiz olur</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Preview -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-eye me-2"></i>Story Önizleme
                        </h5>
                    </div>
                    <div class="card-body">
                        <div id="story_preview" class="position-relative rounded overflow-hidden mx-auto" 
                             style="width: 200px; height: 300px; background: linear-gradient(135deg, #FF6B6B 0%, #FF6B6Bdd 100%);">
                            
                            <div id="preview_image_container" class="position-absolute w-100 h-100" style="display: none;">
                                <img id="preview_story_img" src="" alt="Story Resmi" class="w-100 h-100" style="object-fit: cover;">
                            </div>
                            
                            <div class="position-absolute w-100 h-100 d-flex flex-column justify-content-center align-items-center text-center p-3"
                                 id="story_overlay" style="background: linear-gradient(135deg, #FF6B6B66, #FF6B6B99);">
                                <h6 id="preview_title" class="text-white fw-bold mb-2">Story Başlığı</h6>
                                <p id="preview_description" class="text-white small mb-0">Story açıklaması burada görünecek</p>
                            </div>
                        </div>
                        <small class="text-muted d-block mt-2 text-center">Bu story ana sayfada böyle görünecek</small>
                    </div>
                </div>

                <!-- Settings -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">
                            <i class="bi bi-gear me-2"></i>Ayarlar
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" 
                                   <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Story Aktif
                            </label>
                            <div class="form-text">Pasif story'ler ana sayfada gösterilmez</div>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i>Story'i Kaydet
                            </button>
                            <a href="<?php echo e(route('admin.stories.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Geri Dön
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const typeFields = document.getElementById('type-fields');
    const productField = document.getElementById('product-field');
    const categoryField = document.getElementById('category-field');
    const linkField = document.getElementById('link-field');
    
    const titleInput = document.getElementById('title');
    const descriptionInput = document.getElementById('description');
    const backgroundColorInput = document.getElementById('background_color');
    const textColorInput = document.getElementById('text_color');
    
    const previewTitle = document.getElementById('preview_title');
    const previewDescription = document.getElementById('preview_description');
    const storyPreview = document.getElementById('story_preview');
    const storyOverlay = document.getElementById('story_overlay');

    // Type change handler
    typeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        
        // Hide all fields first
        productField.style.display = 'none';
        categoryField.style.display = 'none';
        linkField.style.display = 'none';
        
        if (selectedType) {
            typeFields.style.display = 'block';
            
            switch(selectedType) {
                case 'product':
                    productField.style.display = 'block';
                    break;
                case 'category':
                    categoryField.style.display = 'block';
                    break;
                case 'custom':
                case 'link':
                    linkField.style.display = 'block';
                    break;
            }
        } else {
            typeFields.style.display = 'none';
        }
    });

    // Preview update function
    function updatePreview() {
        const title = titleInput.value || 'Story Başlığı';
        const description = descriptionInput.value || 'Story açıklaması burada görünecek';
        const backgroundColor = backgroundColorInput.value;
        const textColor = textColorInput.value;

        previewTitle.textContent = title;
        previewDescription.textContent = description;
        previewTitle.style.color = textColor;
        previewDescription.style.color = textColor;
        
        storyPreview.style.background = `linear-gradient(135deg, ${backgroundColor} 0%, ${backgroundColor}dd 100%)`;
        storyOverlay.style.background = `linear-gradient(135deg, ${backgroundColor}66, ${backgroundColor}99)`;
    }

    // Event listeners
    titleInput.addEventListener('input', updatePreview);
    descriptionInput.addEventListener('input', updatePreview);
    backgroundColorInput.addEventListener('change', updatePreview);
    textColorInput.addEventListener('change', updatePreview);

    // Image preview
    const imageInput = document.getElementById('image');
    const imagePreview = document.getElementById('image_preview');
    const previewImg = document.getElementById('preview_img');
    const removeImageBtn = document.getElementById('remove_image');
    const previewStoryImg = document.getElementById('preview_story_img');
    const previewImageContainer = document.getElementById('preview_image_container');

    imageInput.addEventListener('change', function() {
        const file = this.files[0];
        if (file) {
            // File size check (2MB)
            if (file.size > 2 * 1024 * 1024) {
                alert('Dosya boyutu 2MB\'dan büyük olamaz!');
                this.value = '';
                return;
            }

            // File type check
            if (!file.type.startsWith('image/')) {
                alert('Lütfen geçerli bir resim dosyası seçin!');
                this.value = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
                
                // Update story preview
                previewStoryImg.src = e.target.result;
                previewImageContainer.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
            previewImageContainer.style.display = 'none';
        }
    });

    removeImageBtn.addEventListener('click', function() {
        imageInput.value = '';
        imagePreview.style.display = 'none';
        previewImageContainer.style.display = 'none';
    });

    // Initialize
    typeSelect.dispatchEvent(new Event('change'));
    updatePreview();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/admin/stories/create.blade.php ENDPATH**/ ?>