<?php $__env->startSection('title', 'Sipariş Başarılı'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Success Message -->
    <div class="row justify-content-center mb-5">
        <div class="col-md-8 text-center">
            <div class="mb-4">
                <i class="bi bi-check-circle-fill text-success" style="font-size: 5rem;"></i>
            </div>
            <h1 class="display-5 fw-bold text-success mb-3">Siparişiniz Alındı!</h1>
            <p class="lead text-muted mb-4">
                Siparişiniz başarıyla kaydedildi. En kısa sürede hazırlanarak size ulaştırılacaktır.
            </p>
            <div class="alert alert-success">
                <h5 class="fw-bold mb-2">Sipariş Numaranız: <?php echo e($order->order_number); ?></h5>
                <p class="mb-0">Bu numarayı sipariş takibi için saklayınız.</p>
            </div>
        </div>
    </div>

    <!-- Order Details -->
    <div class="row">
        <div class="col-lg-8">
            <!-- Order Items -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-bag-check me-2"></i>Sipariş Detayları
                    </h5>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row align-items-center py-3 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                        <div class="col-md-2">
                            <div class="bg-gradient p-3 text-center rounded" 
                                 style="background: linear-gradient(135deg, <?php echo e($item->product->category->color); ?>20, #E1F5FE);">
                                <i class="<?php echo e($item->product->category->icon); ?> fs-3" 
                                   style="color: <?php echo e($item->product->category->color); ?>;"></i>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold mb-1"><?php echo e($item->product_name); ?></h6>
                            <p class="text-muted small mb-0">Ürün Kodu: <?php echo e($item->product_sku); ?></p>
                            <small class="text-muted"><?php echo e($item->product->category->name); ?></small>
                        </div>
                        <div class="col-md-2 text-center">
                            <span class="fw-bold"><?php echo e($item->quantity); ?> adet</span>
                        </div>
                        <div class="col-md-2 text-end">
                            <span class="fw-bold text-primary">₺<?php echo e(number_format($item->total_price, 2)); ?></span>
                            <br>
                            <small class="text-muted">₺<?php echo e(number_format($item->unit_price, 2)); ?> / adet</small>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Delivery Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-truck me-2"></i>Teslimat Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslim Alacak Kişi:</h6>
                            <p class="mb-3"><?php echo e($order->delivery_name); ?></p>
                            
                            <h6 class="fw-bold">Telefon:</h6>
                            <p class="mb-3"><?php echo e($order->delivery_phone); ?></p>
                        </div>
                        <div class="col-md-6">
                            <h6 class="fw-bold">Teslimat Tarihi:</h6>
                            <p class="mb-3"><?php echo e($order->delivery_date->format('d.m.Y')); ?>

                                <?php if($order->delivery_time): ?>
                                    <span class="text-muted">(<?php echo e($order->delivery_time); ?>)</span>
                                <?php endif; ?>
                            </p>
                            
                            <h6 class="fw-bold">Ödeme Yöntemi:</h6>
                            <p class="mb-3">
                                <?php switch($order->payment_method):
                                    case ('cash'): ?>
                                        <i class="bi bi-cash me-1"></i>Kapıda Ödeme
                                        <?php break; ?>
                                    <?php case ('card'): ?>
                                        <i class="bi bi-credit-card me-1"></i>Kredi Kartı
                                        <?php break; ?>
                                    <?php case ('transfer'): ?>
                                        <i class="bi bi-bank me-1"></i>Havale/EFT
                                        <?php break; ?>
                                <?php endswitch; ?>
                            </p>
                        </div>
                    </div>
                    
                    <h6 class="fw-bold">Teslimat Adresi:</h6>
                    <p class="mb-3">
                        <?php echo e($order->delivery_address); ?><br>
                        <?php echo e($order->delivery_district); ?>, <?php echo e($order->delivery_city); ?>

                    </p>
                    
                    <?php if($order->delivery_notes): ?>
                    <h6 class="fw-bold">Teslimat Notları:</h6>
                    <p class="mb-0"><?php echo e($order->delivery_notes); ?></p>
                    <?php endif; ?>
                </div>
            </div>

            <?php if($order->notes): ?>
            <!-- Order Notes -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-chat-text me-2"></i>Sipariş Notları
                    </h5>
                </div>
                <div class="card-body">
                    <p class="mb-0"><?php echo e($order->notes); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Order Summary -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Sipariş Özeti</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span>₺<?php echo e(number_format($order->subtotal, 2)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span class="<?php echo e($order->shipping_cost == 0 ? 'text-success' : ''); ?>">
                            <?php if($order->shipping_cost == 0): ?>
                                Ücretsiz
                            <?php else: ?>
                                ₺<?php echo e(number_format($order->shipping_cost, 2)); ?>

                            <?php endif; ?>
                        </span>
                    </div>
                    <?php if($order->discount_amount > 0): ?>
                    <div class="d-flex justify-content-between mb-2">
                        <span>İndirim:</span>
                        <span class="text-success">-₺<?php echo e(number_format($order->discount_amount, 2)); ?></span>
                    </div>
                    <?php endif; ?>
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary fs-5">₺<?php echo e(number_format($order->total_amount, 2)); ?></strong>
                    </div>
                    
                    <!-- Order Status -->
                    <div class="alert alert-info">
                        <h6 class="fw-bold mb-2">
                            <i class="bi bi-info-circle me-2"></i>Sipariş Durumu
                        </h6>
                        <span class="badge bg-warning fs-6"><?php echo e($order->status_text); ?></span>
                        <p class="small mb-0 mt-2">
                            Siparişiniz hazırlanmaya başlandı. Kargo takip numaranız SMS ile bildirilecektir.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Next Steps -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0">
                        <i class="bi bi-list-check me-2"></i>Sonraki Adımlar
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0">
                        <li class="mb-3">
                            <i class="bi bi-check-circle text-success me-2"></i>
                            <strong>Sipariş Alındı</strong>
                            <br>
                            <small class="text-muted"><?php echo e($order->created_at->format('d.m.Y H:i')); ?></small>
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-hourglass-split text-warning me-2"></i>
                            <strong>Hazırlanıyor</strong>
                            <br>
                            <small class="text-muted">Çiçekleriniz özenle hazırlanıyor</small>
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-truck text-muted me-2"></i>
                            <strong>Kargoya Verilecek</strong>
                            <br>
                            <small class="text-muted">Teslimat için yola çıkacak</small>
                        </li>
                        <li class="mb-0">
                            <i class="bi bi-house text-muted me-2"></i>
                            <strong>Teslim Edilecek</strong>
                            <br>
                            <small class="text-muted"><?php echo e($order->delivery_date->format('d.m.Y')); ?> tarihinde</small>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="row mt-4">
        <div class="col-12 text-center">
            <a href="<?php echo e(route('orders.show', $order->id)); ?>" class="btn btn-primary me-3">
                <i class="bi bi-eye me-2"></i>Siparişi Takip Et
            </a>
            <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-primary me-3">
                <i class="bi bi-house me-2"></i>Ana Sayfaya Dön
            </a>
            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-outline-secondary">
                <i class="bi bi-flower1 me-2"></i>Alışverişe Devam Et
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/fatihbilgin/Desktop/cicek-bahcesi/resources/views/checkout/success.blade.php ENDPATH**/ ?>