<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CartController;
use Illuminate\Support\Facades\Route;

// Ana sayfa
Route::get('/', [HomeController::class, 'index'])->name('home');

// Hakkımızda
Route::get('/about', [HomeController::class, 'about'])->name('about');

// Ürünler
Route::get('/products', [ProductController::class, 'index'])->name('products.index');
Route::get('/products/{product}', [ProductController::class, 'show'])->name('products.show');
Route::get('/search', [ProductController::class, 'search'])->name('products.search');

// Kategoriler
Route::get('/categories', [CategoryController::class, 'index'])->name('categories.index');
Route::get('/categories/{category}', [CategoryController::class, 'show'])->name('categories.show');

// Story
Route::get('/story/{story}', [HomeController::class, 'showStory'])->name('story.show');

// Sepet
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::get('/cart/count', [CartController::class, 'count'])->name('cart.count');
Route::post('/cart/add/{product}', [CartController::class, 'add'])->name('cart.add');
Route::patch('/cart/update/{product}', [CartController::class, 'update'])->name('cart.update');
Route::delete('/cart/remove/{product}', [CartController::class, 'remove'])->name('cart.remove');
Route::post('/cart/clear', [CartController::class, 'clear'])->name('cart.clear');

// Checkout (Sipariş)
Route::middleware('auth')->group(function () {
    Route::get('/checkout', [\App\Http\Controllers\CheckoutController::class, 'index'])->name('checkout.index');
    Route::post('/checkout', [\App\Http\Controllers\CheckoutController::class, 'store'])->name('checkout.store');
    Route::get('/checkout/success/{orderNumber}', [\App\Http\Controllers\CheckoutController::class, 'success'])->name('checkout.success');
});

// Payment (Ödeme)
Route::middleware('auth')->group(function () {
    Route::get('/payment/credit-card', [\App\Http\Controllers\PaymentController::class, 'creditCard'])->name('payment.credit-card');
    Route::get('/payment/status', [\App\Http\Controllers\PaymentController::class, 'status'])->name('payment.status');
});

// PayTR Callbacks (Auth gerektirmez)
Route::post('/payment/callback', [\App\Http\Controllers\PaymentController::class, 'callback'])->name('payment.callback');
Route::get('/payment/success', [\App\Http\Controllers\PaymentController::class, 'success'])->name('payment.success');
Route::get('/payment/fail', [\App\Http\Controllers\PaymentController::class, 'fail'])->name('payment.fail');

// Admin Dashboard
Route::get('/dashboard', [\App\Http\Controllers\AdminController::class, 'dashboard'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::get('/admin/dashboard', [\App\Http\Controllers\AdminController::class, 'dashboard'])
    ->middleware(['auth', 'verified'])
    ->name('admin.dashboard');

// Admin Routes
Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    // Ürün Yönetimi
    Route::get('/products', [\App\Http\Controllers\AdminController::class, 'products'])->name('products.index');
    Route::get('/products/create', [\App\Http\Controllers\AdminController::class, 'createProduct'])->name('products.create');
    Route::post('/products', [\App\Http\Controllers\AdminController::class, 'storeProduct'])->name('products.store');
    Route::get('/products/{product}/edit', [\App\Http\Controllers\AdminController::class, 'editProduct'])->name('products.edit');
    Route::put('/products/{product}', [\App\Http\Controllers\AdminController::class, 'updateProduct'])->name('products.update');
    Route::delete('/products/{product}', [\App\Http\Controllers\AdminController::class, 'destroyProduct'])->name('products.destroy');
    Route::patch('/products/{product}/toggle-status', [\App\Http\Controllers\AdminController::class, 'toggleProductStatus'])->name('products.toggle-status');
    Route::patch('/products/bulk-update-status', [\App\Http\Controllers\AdminController::class, 'bulkUpdateProductStatus'])->name('products.bulk-update-status');
    Route::delete('/products/bulk-delete', [\App\Http\Controllers\AdminController::class, 'bulkDeleteProducts'])->name('products.bulk-delete');

    // Sipariş Yönetimi
    Route::get('/orders', [\App\Http\Controllers\AdminController::class, 'orders'])->name('orders.index');
    Route::get('/orders/{order}', [\App\Http\Controllers\AdminController::class, 'showOrder'])->name('orders.show');
    Route::patch('/orders/{order}/update-status', [\App\Http\Controllers\AdminController::class, 'updateOrderStatus'])->name('orders.update-status');
    Route::patch('/orders/{order}/update-tracking', [\App\Http\Controllers\AdminController::class, 'updateOrderTracking'])->name('orders.update-tracking');

    // Kategori Yönetimi
    Route::get('/categories', [\App\Http\Controllers\AdminController::class, 'categories'])->name('categories.index');
    Route::get('/categories/create', [\App\Http\Controllers\AdminController::class, 'createCategory'])->name('categories.create');
    Route::post('/categories', [\App\Http\Controllers\AdminController::class, 'storeCategory'])->name('categories.store');
    Route::get('/categories/{category}/edit', [\App\Http\Controllers\AdminController::class, 'editCategory'])->name('categories.edit');
    Route::put('/categories/{category}', [\App\Http\Controllers\AdminController::class, 'updateCategory'])->name('categories.update');
    Route::delete('/categories/{category}', [\App\Http\Controllers\AdminController::class, 'destroyCategory'])->name('categories.destroy');
    Route::patch('/categories/{category}/toggle-status', [\App\Http\Controllers\AdminController::class, 'toggleCategoryStatus'])->name('categories.toggle-status');

    // Raporlar
    Route::get('/reports', [\App\Http\Controllers\AdminController::class, 'reports'])->name('reports.index');

    // Slider Yönetimi
    Route::get('/sliders', [\App\Http\Controllers\AdminController::class, 'sliders'])->name('sliders.index');
    Route::get('/sliders/create', [\App\Http\Controllers\AdminController::class, 'createSlider'])->name('sliders.create');
    Route::post('/sliders', [\App\Http\Controllers\AdminController::class, 'storeSlider'])->name('sliders.store');
    Route::get('/sliders/{slider}/edit', [\App\Http\Controllers\AdminController::class, 'editSlider'])->name('sliders.edit');
    Route::put('/sliders/{slider}', [\App\Http\Controllers\AdminController::class, 'updateSlider'])->name('sliders.update');
    Route::delete('/sliders/{slider}', [\App\Http\Controllers\AdminController::class, 'destroySlider'])->name('sliders.destroy');
    Route::patch('/sliders/{slider}/toggle-status', [\App\Http\Controllers\AdminController::class, 'toggleSliderStatus'])->name('sliders.toggle-status');

    // Site Ayarları
    Route::get('/settings', [\App\Http\Controllers\AdminController::class, 'settings'])->name('settings.index');
    Route::put('/settings', [\App\Http\Controllers\AdminController::class, 'updateSettings'])->name('settings.update');

    // Story Yönetimi
    Route::get('/stories', [\App\Http\Controllers\AdminController::class, 'stories'])->name('stories.index');
    Route::get('/stories/create', [\App\Http\Controllers\AdminController::class, 'createStory'])->name('stories.create');
    Route::post('/stories', [\App\Http\Controllers\AdminController::class, 'storeStory'])->name('stories.store');
    Route::get('/stories/{story}/edit', [\App\Http\Controllers\AdminController::class, 'editStory'])->name('stories.edit');
    Route::put('/stories/{story}', [\App\Http\Controllers\AdminController::class, 'updateStory'])->name('stories.update');
    Route::delete('/stories/{story}', [\App\Http\Controllers\AdminController::class, 'destroyStory'])->name('stories.destroy');
    Route::patch('/stories/{story}/toggle-status', [\App\Http\Controllers\AdminController::class, 'toggleStoryStatus'])->name('stories.toggle-status');

    // PayTR Ödeme Ayarları
    Route::get('/payment-settings', [\App\Http\Controllers\AdminController::class, 'paymentSettings'])->name('payment-settings');
    Route::post('/payment-settings', [\App\Http\Controllers\AdminController::class, 'updatePaymentSettings'])->name('payment-settings.update');
});

// Authenticated routes
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Sipariş yönetimi
    Route::get('/orders', [\App\Http\Controllers\OrderController::class, 'index'])->name('orders.index');
    Route::get('/orders/{order}', [\App\Http\Controllers\OrderController::class, 'show'])->name('orders.show');
    Route::patch('/orders/{order}/cancel', [\App\Http\Controllers\OrderController::class, 'cancel'])->name('orders.cancel');

    // Profil sayfası (geçici)
    Route::get('/my-profile', function () { return view('profile.index'); })->name('profile.index');
});

require __DIR__.'/auth.php';
