<form method="post" action="{{ route('password.update') }}">
    @csrf
    @method('put')

    <div class="mb-3">
        <label for="current_password" class="form-label">Mevcut Şifre</label>
        <input type="password" class="form-control @error('current_password', 'updatePassword') is-invalid @enderror"
               id="current_password" name="current_password" autocomplete="current-password">
        @error('current_password', 'updatePassword')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="password" class="form-label">Yeni Şifre</label>
            <input type="password" class="form-control @error('password', 'updatePassword') is-invalid @enderror"
                   id="password" name="password" autocomplete="new-password">
            @error('password', 'updatePassword')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-3">
            <label for="password_confirmation" class="form-label">Yeni Şifre (Tekrar)</label>
            <input type="password" class="form-control @error('password_confirmation', 'updatePassword') is-invalid @enderror"
                   id="password_confirmation" name="password_confirmation" autocomplete="new-password">
            @error('password_confirmation', 'updatePassword')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="d-flex align-items-center">
        <button type="submit" class="btn btn-warning">
            <i class="bi bi-shield-lock me-2"></i>Şifreyi Güncelle
        </button>

        @if (session('status') === 'password-updated')
            <div class="alert alert-success ms-3 mb-0 py-2 px-3">
                <small><i class="bi bi-check-circle me-1"></i>Şifre güncellendi!</small>
            </div>
        @endif
    </div>
</form>
