<x-guest-layout>
    <div class="text-center mb-4">
        <h4 class="fw-bold text-primary">Kayıt Ol</h4>
        <p class="text-muted">Yeni hesap oluşturun</p>
    </div>

    <form method="POST" action="{{ route('register') }}">
        @csrf

        <!-- Name -->
        <div class="mb-3">
            <label for="name" class="form-label">Ad Soyad</label>
            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror"
                   name="name" value="{{ old('name') }}" required autofocus autocomplete="name">
            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Email Address -->
        <div class="mb-3">
            <label for="email" class="form-label">E-posta Adresi</label>
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror"
                   name="email" value="{{ old('email') }}" required autocomplete="username">
            @error('email')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Phone -->
        <div class="mb-3">
            <label for="phone" class="form-label">Telefon Numarası</label>
            <input id="phone" type="tel" class="form-control @error('phone') is-invalid @enderror"
                   name="phone" value="{{ old('phone') }}" placeholder="+90 5XX XXX XX XX">
            @error('phone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Password -->
        <div class="mb-3">
            <label for="password" class="form-label">Şifre</label>
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror"
                   name="password" required autocomplete="new-password">
            @error('password')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <!-- Confirm Password -->
        <div class="mb-3">
            <label for="password_confirmation" class="form-label">Şifre Tekrar</label>
            <input id="password_confirmation" type="password" class="form-control @error('password_confirmation') is-invalid @enderror"
                   name="password_confirmation" required autocomplete="new-password">
            @error('password_confirmation')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="d-grid gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-person-plus me-2"></i>Kayıt Ol
            </button>
        </div>

        <hr class="my-3">

        <div class="text-center">
            <p class="mb-0 small text-muted">Zaten hesabınız var mı?</p>
            <a href="{{ route('login') }}" class="text-decoration-none">
                <strong>Giriş Yapın</strong>
            </a>
        </div>
    </form>
</x-guest-layout>
