@extends('layouts.app')

@section('title', 'Story Yönetimi')

@section('content')
<div class="container-fluid py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="display-6 fw-bold text-primary mb-2">
                        <i class="bi bi-collection-play me-2"></i>Story Yönetimi
                    </h1>
                    <p class="text-muted mb-0">Instagram benzeri story'leri yönetin</p>
                </div>
                <div>
                    <a href="{{ route('admin.stories.create') }}" class="btn btn-primary btn-lg">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Story Ekle
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Stories Grid -->
    <div class="row g-4">
        @forelse($stories as $story)
        <div class="col-xl-4 col-lg-6 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <!-- Story Preview -->
                <div class="position-relative">
                    <div class="story-preview rounded-top overflow-hidden" 
                         style="height: 200px; background: linear-gradient(135deg, {{ $story->background_color }} 0%, {{ $story->background_color }}dd 100%);">
                        
                        <!-- Background Image -->
                        @if($story->image)
                        <img src="{{ asset('storage/' . $story->image) }}" 
                             alt="{{ $story->title }}" 
                             class="position-absolute w-100 h-100" 
                             style="object-fit: cover; opacity: 0.8;">
                        @endif
                        
                        <!-- Story Content Overlay -->
                        <div class="position-absolute w-100 h-100 d-flex flex-column justify-content-center align-items-center text-center p-3"
                             style="background: linear-gradient(135deg, {{ $story->background_color }}66, {{ $story->background_color }}99);">
                            <h5 class="text-white fw-bold mb-2" style="color: {{ $story->text_color }} !important;">
                                {{ $story->title }}
                            </h5>
                            @if($story->description)
                            <p class="text-white small mb-0" style="color: {{ $story->text_color }} !important;">
                                {{ Str::limit($story->description, 60) }}
                            </p>
                            @endif
                        </div>
                        
                        <!-- Status Toggle -->
                        <div class="position-absolute top-0 end-0 m-2">
                            <div class="form-check form-switch">
                                <input class="form-check-input story-toggle bg-white shadow" type="checkbox" 
                                       data-story-id="{{ $story->id }}"
                                       {{ $story->is_active ? 'checked' : '' }}>
                            </div>
                        </div>
                        
                        <!-- Sort Order Badge -->
                        <div class="position-absolute top-0 start-0 m-2">
                            <span class="badge bg-dark bg-opacity-75">{{ $story->sort_order }}</span>
                        </div>
                        
                        <!-- Type Badge -->
                        <div class="position-absolute bottom-0 start-0 m-2">
                            <span class="badge bg-info">{{ $story->type_text }}</span>
                        </div>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="flex-grow-1">
                            <h6 class="card-title mb-1">{{ $story->title }}</h6>
                            <small class="text-muted">
                                @if($story->type === 'product' && $story->product)
                                    Ürün: {{ $story->product->name }}
                                @elseif($story->type === 'category' && $story->category)
                                    Kategori: {{ $story->category->name }}
                                @elseif($story->custom_link)
                                    Link: {{ Str::limit($story->custom_link, 30) }}
                                @endif
                            </small>
                        </div>
                        <div class="flex-shrink-0 ms-2">
                            <span class="badge bg-{{ $story->status_badge }}">
                                {{ $story->status_text }}
                            </span>
                        </div>
                    </div>
                    
                    <!-- Story Stats -->
                    <div class="row text-center mb-3">
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-primary mb-1">{{ $story->sort_order }}</h6>
                                <small class="text-muted">Sıra</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="border-end">
                                <h6 class="text-info mb-1">{{ $story->type_text }}</h6>
                                <small class="text-muted">Tip</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <h6 class="text-{{ $story->expires_at ? ($story->is_expired ? 'danger' : 'warning') : 'success' }} mb-1">
                                @if($story->expires_at)
                                    @if($story->is_expired)
                                        <i class="bi bi-clock-history"></i>
                                    @else
                                        <i class="bi bi-clock"></i>
                                    @endif
                                @else
                                    <i class="bi bi-infinity"></i>
                                @endif
                            </h6>
                            <small class="text-muted">
                                {{ $story->expires_at ? ($story->is_expired ? 'Dolmuş' : 'Süreli') : 'Süresiz' }}
                            </small>
                        </div>
                    </div>
                    
                    @if($story->expires_at)
                    <div class="mb-3">
                        <small class="text-muted">
                            <i class="bi bi-calendar me-1"></i>
                            @if($story->is_expired)
                                Süresi {{ $story->expires_at->diffForHumans() }} doldu
                            @else
                                {{ $story->expires_at->diffForHumans() }} sona erecek
                            @endif
                        </small>
                    </div>
                    @endif
                </div>
                
                <div class="card-footer bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <small class="text-muted">
                            {{ $story->updated_at->format('d.m.Y H:i') }}
                        </small>
                        <div class="btn-group btn-group-sm">
                            @if($story->link !== '#')
                            <a href="{{ $story->link }}" 
                               class="btn btn-outline-info" target="_blank" title="Story Linkini Aç">
                                <i class="bi bi-box-arrow-up-right"></i>
                            </a>
                            @endif
                            <a href="{{ route('admin.stories.edit', $story->id) }}" 
                               class="btn btn-outline-primary" title="Düzenle">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <button type="button" class="btn btn-outline-danger delete-story" 
                                    data-story-id="{{ $story->id }}" 
                                    data-story-title="{{ $story->title }}" title="Sil">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @empty
        <div class="col-12">
            <div class="text-center py-5">
                <i class="bi bi-collection-play display-1 text-muted mb-4" style="opacity: 0.3;"></i>
                <h3 class="text-muted mb-3">Henüz Story Yok</h3>
                <p class="text-muted mb-4">İlk story'nizi oluşturarak başlayın!</p>
                <a href="{{ route('admin.stories.create') }}" class="btn btn-primary btn-lg">
                    <i class="bi bi-plus-circle me-2"></i>İlk Story'i Ekle
                </a>
            </div>
        </div>
        @endforelse
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Story'i Sil</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Dikkat!</strong> Bu işlem geri alınamaz.
                </div>
                <p id="delete-message"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                <form id="delete-form" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Evet, Sil</button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Story status toggle
    document.querySelectorAll('.story-toggle').forEach(toggle => {
        toggle.addEventListener('change', function() {
            const storyId = this.dataset.storyId;
            const isActive = this.checked;
            
            fetch(`/admin/stories/${storyId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({ is_active: isActive })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    this.checked = !isActive; // Revert on error
                    alert('Durum güncellenirken hata oluştu!');
                }
            })
            .catch(error => {
                this.checked = !isActive; // Revert on error
                alert('Bir hata oluştu!');
            });
        });
    });

    // Delete story
    document.querySelectorAll('.delete-story').forEach(button => {
        button.addEventListener('click', function() {
            const storyId = this.dataset.storyId;
            const storyTitle = this.dataset.storyTitle;
            
            const deleteForm = document.getElementById('delete-form');
            const deleteMessage = document.getElementById('delete-message');
            
            deleteForm.action = `/admin/stories/${storyId}`;
            deleteMessage.innerHTML = `<strong>${storyTitle}</strong> story'sini silmek istediğinizden emin misiniz?`;
            
            new bootstrap.Modal(document.getElementById('deleteModal')).show();
        });
    });
});
</script>
@endpush
@endsection
