<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
header("Content-Type: text/plain; charset=UTF-8");

// .env yükle (Laravel olmadan)
$baseDir = dirname(__DIR__);
$envPath = $baseDir . '/.env';
if (is_readable($envPath)) {
    $env = @parse_ini_file($envPath, false, INI_SCANNER_RAW);
    if (is_array($env)) {
        foreach ($env as $k => $v) {
            if (!getenv($k)) { putenv("{$k}={$v}"); }
        }
    }
}

$phpVersion = phpversion();
$extensions = get_loaded_extensions();

$host = getenv("DB_HOST") ?: "localhost";
$db   = getenv("DB_DATABASE") ?: "";
$user = getenv("DB_USERNAME") ?: "";
$pass = getenv("DB_PASSWORD") ?: "";
$port = getenv("DB_PORT") ?: 3306;

$mysqlOk = false;
$mysqlErr = "";
try {
    $dsn = "mysql:host={$host};port={$port};dbname={$db};charset=utf8mb4";
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_TIMEOUT => 5,
    ]);
    $mysqlOk = true;
} catch (Throwable $e) {
    $mysqlErr = $e->getMessage();
}

print("PHP Version: {$phpVersion}\n");
print("Extensions (first 20):\n - " . implode("\n - ", array_slice($extensions, 0, 20)) . "\n\n");
print("MySQL Connection: " . ($mysqlOk ? "OK" : "FAILED") . "\n");
if (!$mysqlOk) {
    print("MySQL Error: {$mysqlErr}\n");
}

print("\nDocRoot: " . ($_SERVER['DOCUMENT_ROOT'] ?? '') . "\n");
print("Script: " . (__FILE__) . "\n");
print("APP_URL: " . (getenv("APP_URL") ?: '') . "\n");
print("DB_HOST: {$host}\nDB_DATABASE: {$db}\nDB_USERNAME: {$user}\nPort: {$port}\n");

exit(0);
